package cn.myapps.conf;

import java.util.HashMap;
import java.util.Map;

import javax.sql.DataSource;


import cn.myapps.common.DataSourceFactory;
import com.bcxin.saas.core.components.JsonProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

import cn.myapps.common.util.DbUtil;

/**
 * Created by arnold.zhu on 6/13/2017.
 */
@Configuration
@ComponentScan(basePackages = "com.bcxin.web.commons.components" )
public class DataSourceConfig  implements TransactionManagementConfigurer{
    @Value("${spring.datasource.url}")
    private String dbUrl;

    @Value("${spring.datasource.username}")
    private String username;

    @Value("${spring.datasource.password}")
    private String password;

    @Value("${spring.datasource.driver-class-name}")
    private String driverClassName;

    @Value("${spring.datasource.validationQuery}")
    private String validationQuery;
    
    @Bean
    public DataSource druidDataSource() {
        DataSource ds = null;
        Map<String,String> properties =  new HashMap<String, String>();
        properties.put("driverClassName", driverClassName);
        properties.put("url", dbUrl);
        properties.put("username", username);
        properties.put("password", password);
        validationQuery = DbUtil.getValidationQuery(driverClassName);
        properties.put("validationQuery",validationQuery );
        try {
            ds = DataSourceFactory.create(properties);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ds;
    }
    
    
    @Bean
    public JdbcTemplate jdbcTemplate(DataSource kmDataSource){
		return new JdbcTemplate(kmDataSource);
    	
    }
    
	@Override
	public PlatformTransactionManager annotationDrivenTransactionManager() {
		return new DataSourceTransactionManager(druidDataSource());
	}

    @Bean
    public JsonProvider jsonProvider()
    {
        return new JsonProvider.JsonProviderImpl();
    }
}