/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.util;

import com.teemlink.email.util.EmailConfig;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class Utility {
    private static final char[] trChars = new char[]{'\u0131', '\u0130', '\u015f', '\u015e', '\u011f', '\u011e', '\u00fd', '\u00dd', '\u00fe', '\u00de', '\u00f0', '\u00d0', '\u00e7', '\u00c7', '\u00fc', '\u00dc', '\u00f6', '\u00d6'};
    private static final char[] enChars = new char[]{'i', 'I', 's', 'S', 'g', 'G', 'i', 'I', 's', 'S', 'g', 'G', 'c', 'C', 'u', 'U', 'o', 'O'};
    private static final char[] enLowerCaseChars = new char[]{'i', 'i', 's', 's', 'g', 'g', 'i', 'i', 's', 's', 'g', 'g', 'c', 'c', 'u', 'u', 'o', 'o'};
    private static final String[] trUnicodes = new String[]{"&#305;", "&#304;", "&#351;", "&#350;", "&#287;", "&#286;", "&#305;", "&#304;", "&#351;", "&#350;", "&#287;", "&#286;", "&#231;", "&#199;", "&#252;", "&#220;", "&#246;", "&#214;"};
    private static final char[] trDirtyChars = new char[]{'\u00fd', '\u00dd', '\u00fe', '\u00de', '\u00f0', '\u00d0'};
    private static final char[] trCleanChars = new char[]{'\u0131', '\u0130', '\u015f', '\u015e', '\u011f', '\u011e'};
    private static Pattern encodePattern = Pattern.compile("=\\?(.+)\\?(B|Q)\\?(.+)\\?=", 34);

    public static String replaceAllOccurances(String str, String from, String to) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (str.length() == 1 && str.equals(from)) {
            return to;
        }
        if (str.length() == 1 && !str.equals(from)) {
            return str;
        }
        int j = -1;
        while ((j = str.indexOf(from)) >= 0) {
            str = str.substring(0, j) + '\u0005' + str.substring(j + from.length());
        }
        int i = -1;
        while ((i = str.indexOf(5)) >= 0) {
            str = str.substring(0, i) + to + str.substring(i + 1);
        }
        return str;
    }

    public static String extendedTrim(String str, String trimStr) {
        if (str == null || str.length() == 0) {
            return str;
        }
        str = str.trim();
        while (str.startsWith(trimStr)) {
            str = str.substring(trimStr.length()).trim();
        }
        while (str.endsWith(trimStr)) {
            str = str.substring(0, str.length() - trimStr.length()).trim();
        }
        return str;
    }

    public static Object checkDecimalFormat(Object number) {
        String str = "-";
        try {
            int lastPosDot;
            str = number.toString();
            int posDot = str.indexOf(".");
            int posComma = str.indexOf(",");
            if (posComma > posDot) {
                str = Utility.replaceAllOccurances(str, ".", "");
                str = Utility.replaceAllOccurances(str, ",", ".");
            } else if (posComma == -1 && posDot > 0 && posDot != (lastPosDot = str.lastIndexOf("."))) {
                str = Utility.replaceAllOccurances(str, ".", "");
            }
        }
        catch (Exception e) {
            str = "-";
        }
        return str;
    }

    public static String doCharsetCorrections(String str) {
        if (str == null) {
            return "";
        }
        String[] extraChars = new String[]{"\u00fd", "\u00dd", "\u00fe", "\u00de", "\u00f0", "\u00d0"};
        String[] unicode = new String[]{"\u0131", "\u0130", "\u015f", "\u015e", "\u011f", "\u011e"};
        for (int i = 0; i < extraChars.length; ++i) {
            while (str.indexOf(extraChars[i]) != -1) {
                String tmp = str;
                str = tmp.substring(0, tmp.indexOf(extraChars[i])) + unicode[i] + tmp.substring(tmp.indexOf(extraChars[i]) + 1, tmp.length());
            }
        }
        return str;
    }

    public static String htmlSpecialChars(String input) {
        StringBuffer filtered;
        try {
            filtered = new StringBuffer(input.length());
            for (int i = 0; i < input.length(); ++i) {
                char c = input.charAt(i);
                if (c == '<') {
                    filtered.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    filtered.append("&gt;");
                    continue;
                }
                if (c == '\"') {
                    filtered.append("&quot;");
                    continue;
                }
                if (c == '&') {
                    filtered.append("&amp;");
                    continue;
                }
                filtered.append(c);
            }
        }
        catch (Exception e) {
            return input;
        }
        return filtered.toString();
    }

    public static String convertTRCharsToHtmlSafe(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        int pos = -1;
        for (int i = 0; i < trChars.length; ++i) {
            while ((pos = str.indexOf(trChars[i])) != -1) {
                str = str.substring(0, pos) + trUnicodes[i] + str.substring(pos + 1, str.length());
            }
        }
        return str;
    }

    public static String updateTRChars(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        String ret = "";
        try {
            ret = MimeUtility.decodeText((String)str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String strLowerCase = ret.toLowerCase(new Locale("en", "US"));
        if (strLowerCase.startsWith("=?iso-8859-9?q?")) {
            ret = ret.substring(15);
            if (strLowerCase.endsWith("?=")) {
                ret = ret.substring(0, ret.length() - 2);
            } else {
                int pos = -1;
                while ((pos = ret.indexOf("?=")) != -1) {
                    ret = ret.substring(0, pos) + ret.substring(pos + 2, ret.length());
                }
            }
            try {
                ret = ret.replace('=', '%');
                ret = URLDecoder.decode(ret, "iso-8859-9");
            }
            catch (Exception pos) {
                // empty catch block
            }
        }
        for (int i = 0; i < trDirtyChars.length; ++i) {
            int pos = -1;
            while ((pos = ret.indexOf(trDirtyChars[i])) != -1) {
                ret = ret.substring(0, pos) + trCleanChars[i] + ret.substring(pos + 1, ret.length());
            }
        }
        return ret;
    }

    public static String convertTRCharsToENChars(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        int pos = -1;
        for (int i = 0; i < trChars.length; ++i) {
            while ((pos = str.indexOf(trChars[i])) != -1) {
                str = str.substring(0, pos) + enChars[i] + str.substring(pos + 1, str.length());
            }
        }
        return str;
    }

    public static String convertTRCharsToENLowerCaseChars(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        int pos = -1;
        for (int i = 0; i < trChars.length; ++i) {
            while ((pos = str.indexOf(trChars[i])) != -1) {
                str = str.substring(0, pos) + enLowerCaseChars[i] + str.substring(pos + 1, str.length());
            }
        }
        return str;
    }

    public static String[] addressArrToStringArr(Address[] addr) {
        if (addr != null && addr.length > 0) {
            String[] str = new String[addr.length];
            for (int j = 0; j < addr.length; ++j) {
                InternetAddress add = (InternetAddress)addr[j];
                String personal = Utility.doCharsetCorrections(add.getPersonal());
                String address = Utility.doCharsetCorrections(add.getAddress());
                if (personal != null && personal.length() > 0) {
                    if (address != null && address.length() > 0) {
                        str[j] = personal + " <" + address + ">";
                        continue;
                    }
                    str[j] = personal;
                    continue;
                }
                str[j] = address != null && address.length() > 0 ? address : "";
            }
            return str;
        }
        return null;
    }

    public static String addressArrToString(Address[] addr) {
        StringBuffer addrStr = new StringBuffer();
        String[] str = Utility.addressArrToStringArr(addr);
        if (str != null && str.length > 0) {
            for (int i = 0; i < str.length; ++i) {
                addrStr.append(str[i]).append(", ");
            }
        }
        String msg = Utility.extendedTrim(addrStr.toString(), ",");
        return Utility.doCharsetCorrections(msg);
    }

    public static String[] addressArrToStringArrShort(Address[] addr) {
        if (addr != null && addr.length > 0) {
            String[] str = new String[addr.length];
            for (int j = 0; j < addr.length; ++j) {
                InternetAddress add = (InternetAddress)addr[j];
                String personal = Utility.doCharsetCorrections(add.getPersonal());
                String address = Utility.doCharsetCorrections(add.getAddress());
                str[j] = personal != null && personal.length() > 0 ? personal : (address != null && address.length() > 0 ? address : "Unknown");
            }
            return str;
        }
        return null;
    }

    public static String addressArrToStringShort(Address[] addr) {
        StringBuffer addrStr = new StringBuffer();
        String[] str = Utility.addressArrToStringArrShort(addr);
        if (str != null && str.length > 0) {
            for (int i = 0; i < str.length; ++i) {
                addrStr.append(str[i] + ", ");
            }
        }
        String msg = Utility.extendedTrim(addrStr.toString(), ",");
        msg = Utility.doCharsetCorrections(msg);
        return msg;
    }

    public static Address[] stringToAddressArray(String str) throws Exception {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        str = Utility.extendedTrim(str, ",");
        StringTokenizer token = new StringTokenizer(str = Utility.extendedTrim(str, ";"), ",");
        if (token == null || token.countTokens() == 1) {
            token = new StringTokenizer(str, ";");
        }
        if (token.countTokens() != 0) {
            Address[] outAddr = new Address[token.countTokens()];
            int counter = 0;
            while (token.hasMoreTokens()) {
                String addr = token.nextToken().trim();
                addr = Utility.replaceAllOccurances(addr, "&lt;", "<");
                addr = Utility.replaceAllOccurances(addr, "&gt;", ">");
                String fullname = "";
                String email = "";
                try {
                    int j = addr.indexOf("<");
                    if (j > 0) {
                        fullname = Utility.extendedTrim(addr.substring(0, j).trim(), "\"");
                        email = Utility.extendedTrim(Utility.extendedTrim(addr.substring(j + 1), ">"), "\"").trim();
                        String charset = EmailConfig.getString("charset", "UTF-8");
                        outAddr[counter] = new InternetAddress(email, fullname, charset);
                    } else {
                        outAddr[counter] = new InternetAddress(addr);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                catch (AddressException e) {
                    e.printStackTrace();
                }
                ++counter;
            }
            return outAddr;
        }
        return null;
    }

    public static String sizeToHumanReadable(long size) {
        String sizeString = String.valueOf(Math.round((float)size / 1024.0f));
        if (sizeString.equals("0")) {
            sizeString = size + "B";
        } else {
            StringBuffer temp = new StringBuffer();
            char[] chars = sizeString.toCharArray();
            int count = 0;
            for (int i = chars.length - 1; i >= 0; --i) {
                temp.insert(0, chars[i]);
                if (++count % 3 != 0 || temp.length() >= chars.length) continue;
                temp.insert(0, ',');
                count = 0;
            }
            temp.append("k");
            sizeString = temp.toString();
        }
        return sizeString;
    }

    public static String stripHTMLTags(String message) {
        StringBuffer returnMessage = new StringBuffer(message);
        try {
            int startPosition = message.indexOf("<");
            int endPosition = message.indexOf(">");
            while (startPosition != -1) {
                returnMessage.delete(startPosition, endPosition + 1);
                returnMessage.insert(startPosition, " ");
                startPosition = returnMessage.toString().indexOf("<");
                endPosition = returnMessage.toString().indexOf(">");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return returnMessage.toString();
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean checkEmailAddress(String address) {
        if (!Utility.isBlank(address)) {
            return address.matches("^(([a-zA-Z0-9_.-]){1,20}@([a-zA-Z0-9_-])+(\\.([a-zA-Z0-9_-])+)+){0,1}$");
        }
        return false;
    }

    public static String getDateToString() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(new Date());
    }

    public static String getEmailAddress(String account) {
        if (account.indexOf(64) >= 0) {
            return account;
        }
        return account + "@" + EmailConfig.getEmailDomain();
    }

    public static String getDateToString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public static String getDateToString(Date date, String formatString) {
        SimpleDateFormat format = new SimpleDateFormat(formatString);
        return format.format(date);
    }

    public static void main(String[] args) {
    }

    public static String decodeText(String text) {
        try {
            String result;
            if (!Utility.isBlank(text) && !Utility.isBlank(result = MimeUtility.decodeText((String)text))) {
                Matcher matcher = encodePattern.matcher(result);
                if (matcher.find()) {
                    return MimeUtility.decodeWord((String)result);
                }
                return result;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return text;
    }
}

