/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;

public final class JacksonUtil<T> {
    public static ObjectMapper objectMapper;

    public static <T> T readValue(String jsonStr, Class<T> valueType) {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
        }
        try {
            return (T)objectMapper.readValue(jsonStr, valueType);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T readValue(String jsonStr, TypeReference<T> valueTypeRef) {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
        }
        try {
            return (T)objectMapper.readValue(jsonStr, valueTypeRef);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String toJSon(Object object) {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
        }
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void save(Object object, File file) {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
        }
        try {
            objectMapper.writerWithDefaultPrettyPrinter().writeValue(file, object);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> T get(File file, Class<T> valueType, Class clazz) {
        Object t = null;
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
        }
        try {
            JavaType javaType = objectMapper.getTypeFactory().constructParametricType(valueType, new Class[]{clazz});
            t = objectMapper.readValue(file, javaType);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (T)t;
    }
}

