/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.DecimalFormat;

public class FileUtil {
    public static void copyFile(String newPath, String oldPath) throws Exception {
        InputStream inStream = null;
        FileOutputStream fs = null;
        try {
            int bytesum = 0;
            int byteread = 0;
            File oldfile = new File(oldPath);
            if (oldfile.exists()) {
                inStream = new FileInputStream(oldPath);
                fs = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                while ((byteread = inStream.read(buffer)) != -1) {
                    bytesum += byteread;
                    fs.write(buffer, 0, byteread);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            if (fs != null) {
                fs.close();
            }
        }
    }

    public static void copyDir(String des, String src) throws Exception {
        File srcFile = new File(src);
        File[] srcFs = srcFile.listFiles();
        File desFile = new File(des);
        if (!desFile.exists()) {
            desFile.mkdirs();
        }
        for (File srcFileItem : srcFs) {
            if (srcFileItem.isFile()) {
                FileUtil.copyFile(des + File.separator + srcFileItem.getName(), srcFileItem.getPath());
                continue;
            }
            if (!srcFileItem.isDirectory()) continue;
            FileUtil.copyDir(des + File.separator + srcFileItem.getName(), srcFileItem.getPath());
        }
    }

    public static String FormetFileSize(long fileS) {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = "";
        fileSizeString = fileS < 1024L ? df.format((double)fileS) + "B" : (fileS < 0x100000L ? df.format((double)fileS / 1024.0) + "K" : (fileS < 0x40000000L ? df.format((double)fileS / 1048576.0) + "M" : df.format((double)fileS / 1.073741824E9) + "G"));
        return fileSizeString;
    }

    public static void main(String[] args) {
    }
}

