/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.util;

import cn.myapps.common.util.PropertyUtil;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Value;

public class Environment
implements Serializable {
    private static final long serialVersionUID = 7874636871392290110L;
    private String _wcpath;
    private String _contextPath;
    private String encoding = "UTF-8";
    private String baseUrl;
    @Value(value="${server.context-path:/}")
    private String contextPath;
    private String workspaceRootPath = null;
    private static Environment env = null;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public static Environment getInstance() {
        if (env == null) {
            env = new Environment();
        }
        return env;
    }

    private Environment() {
        String workRootPath;
        this.setContextPath(this.contextPath);
        this.workspaceRootPath = workRootPath = PropertyUtil.getPath() + "/workspace";
        this._wcpath = PropertyUtil.getPath();
    }

    public void setApplicationRealPath(String wcpath) {
        this._wcpath = wcpath;
    }

    public String getApplicationRealPath() {
        return this._wcpath != null ? this._wcpath : "";
    }

    public String getRealPath(String path) {
        String realpath = path != null ? this.getApplicationRealPath() + path : "";
        realpath = realpath.replaceAll("\\\\", "/");
        return realpath;
    }

    public String setContextPath(String cpath) {
        this._contextPath = cpath;
        return this._contextPath;
    }

    public String getContextPath() {
        return this._contextPath != null ? this._contextPath : "/";
    }

    public String getContext(String uri) {
        if (this._contextPath.equals("/")) {
            return uri;
        }
        return this._contextPath + uri;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

