/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.util;

import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.StringUtil;
import com.teemlink.email.runtime.mail.ConnectionProfile;
import com.teemlink.email.util.Constants;

public class EmailConfig {
    private static ConnectionProfile profile;

    private EmailConfig() {
    }

    private static void initConnectionProfile() {
        profile = new ConnectionProfile();
        profile.setFetchPort(EmailConfig.getString("fetch.server.port", "143"));
        profile.setFetchServer(EmailConfig.getString("fetch.server", "127.0.0.1"));
        profile.setFetchSSL(EmailConfig.getString("fetch.ssl", "false"));
        profile.setProtocol(EmailConfig.getString("fetch.protocol", "imap"));
        profile.setShortName(EmailConfig.getString("shortname", "localhost"));
        profile.setSmtpAuthenticated(EmailConfig.getString("smtp.authenticated", "false"));
        profile.setSmtpPort(EmailConfig.getString("smtp.server.port", "25"));
        profile.setSmtpServer(EmailConfig.getString("smtp.server", "127.0.0.1"));
        profile.setSmtpSSL(EmailConfig.getString("smtp.ssl", "false"));
        profile.setFolderNameSpace(EmailConfig.getString("folder.namespace"));
    }

    public static String getString(String name) {
        String result = PropertyUtil.getByPropName((String)"email", (String)name);
        if (!StringUtil.isBlank((String)result)) {
            return result.trim();
        }
        return "";
    }

    public static String getString(String name, String defaultValue) {
        String result = EmailConfig.getString(name);
        if (StringUtil.isBlank((String)result)) {
            result = defaultValue;
        }
        return result.trim();
    }

    public static int getInteger(String name, int defaultInt) {
        try {
            String result = EmailConfig.getString(name);
            if (!StringUtil.isBlank((String)result)) {
                return Integer.parseInt(result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultInt;
    }

    public static boolean getBoolean(String name, boolean defaultInt) {
        try {
            String result = EmailConfig.getString(name);
            if (!StringUtil.isBlank((String)result)) {
                return Boolean.parseBoolean(result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultInt;
    }

    public static String getEmailDomain() {
        String domain = EmailConfig.getString("domain");
        if (StringUtil.isBlank((String)domain)) {
            return "localhost";
        }
        return domain;
    }

    public static ConnectionProfile getConnectionProfile() {
        return profile;
    }

    public static boolean isUserEmail() {
        String bool = PropertyUtil.getByPropName((String)"email", (String)"USER_EMAIL_FUNCTION");
        return Boolean.parseBoolean(bool);
    }

    public static void initEmailConfig() {
        Constants.DEFAULT_FOLDER_JUNK = EmailConfig.getString("folder.trash");
        Constants.DEFAULT_FOLDER_SENT = EmailConfig.getString("folder.sent");
        Constants.DEFAULT_FOLDER_REMOVED = EmailConfig.getString("folder.removed");
        Constants.DEFAULT_FOLDER_DRAFTS = EmailConfig.getString("folder.drafts");
        EmailConfig.initConnectionProfile();
    }

    static {
        EmailConfig.initConnectionProfile();
    }
}

