/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.util;

import cn.myapps.common.util.StringUtil;
import com.teemlink.email.email.model.EmailUser;
import com.teemlink.email.util.EmailConfig;

public final class Constants {
    public static final String DEFAULT_FOLDER_INBOX = "INBOX";
    public static String DEFAULT_FOLDER_JUNK = "Junk";
    public static String DEFAULT_FOLDER_SENT = "Sent";
    public static String DEFAULT_FOLDER_REMOVED = "Removed";
    public static String DEFAULT_FOLDER_DRAFTS = "Drafts";
    public static final String SYSTEM_FOLDER_ID = "0000-0000-00000000-0000-000000000000";
    public static final int CONNECT_TYPE_READ_ONLY = 1;
    public static final int CONNECT_TYPE_READ_WRITE = 2;
    public static final String EMAIL_BASE_URL = "portal/share/email/index.jsp";

    public static String getFolderDisplay(String folderName) {
        if (DEFAULT_FOLDER_INBOX.equals(folderName)) {
            return "\u6536\u4ef6\u7bb1";
        }
        if (DEFAULT_FOLDER_DRAFTS.equals(folderName)) {
            return "\u8349\u7a3f\u7bb1";
        }
        if (DEFAULT_FOLDER_SENT.equals(folderName)) {
            return "\u53d1\u9001\u7bb1";
        }
        if (DEFAULT_FOLDER_REMOVED.equals(folderName)) {
            return "\u5df2\u5220\u9664";
        }
        if (DEFAULT_FOLDER_JUNK.equals(folderName)) {
            return "\u5783\u573e\u7bb1";
        }
        return folderName;
    }

    public static boolean isSystemFolder(String folderName) {
        if (DEFAULT_FOLDER_INBOX.equals(folderName)) {
            return true;
        }
        if (DEFAULT_FOLDER_DRAFTS.equals(folderName)) {
            return true;
        }
        if (DEFAULT_FOLDER_SENT.equals(folderName)) {
            return true;
        }
        if (DEFAULT_FOLDER_REMOVED.equals(folderName)) {
            return true;
        }
        return DEFAULT_FOLDER_JUNK.equals(folderName);
    }

    public static String accountToEmailShowAddress(EmailUser user) {
        StringBuffer buffer = new StringBuffer();
        if (user != null) {
            String address = user.getAccount() + "@" + EmailConfig.getEmailDomain();
            if (StringUtil.isBlank((String)user.getName())) {
                buffer.append(address);
            } else {
                buffer.append(user.getName());
                buffer.append(" <").append(address).append(">");
            }
        }
        return buffer.toString();
    }

    public static String emailShowAddressToAddress(String showAddress) {
        if (StringUtil.isBlank((String)showAddress)) {
            return "";
        }
        int start = showAddress.indexOf(60) + 1;
        int end = showAddress.lastIndexOf(62);
        if (end < 0) {
            end = showAddress.length();
        }
        if (start >= 0 && end > 0 && start < end) {
            return showAddress.substring(start, end).trim();
        }
        return "";
    }

    public static String emailAddress2Account(String address) {
        String temp = Constants.emailShowAddressToAddress(address);
        int index = temp.indexOf(64);
        if (index < 0) {
            index = temp.length();
        }
        return temp.substring(0, index);
    }

    public static void main(String[] args) throws Exception {
        EmailUser user = new EmailUser();
        user.setAccount("aaaa");
        user.setName("niuB");
    }

    static {
        DEFAULT_FOLDER_JUNK = EmailConfig.getString("folder.trash");
        DEFAULT_FOLDER_SENT = EmailConfig.getString("folder.sent");
        DEFAULT_FOLDER_REMOVED = EmailConfig.getString("folder.removed");
        DEFAULT_FOLDER_DRAFTS = EmailConfig.getString("folder.drafts");
    }
}

