/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.util;

import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.StringUtil;
import com.teemlink.email.attachment.model.Attachment;
import com.teemlink.email.util.EmailConfig;
import com.teemlink.email.util.Environment;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AttachmentUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AttachmentUtil.class);

    public static Attachment saveAttachmentFile(String fileName, InputStream inputStream) throws Exception {
        FilterOutputStream bufferedOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            File file = AttachmentUtil.createAttachmentFile(fileName);
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            bufferedInputStream = new BufferedInputStream(inputStream);
            int line = 0;
            while ((line = bufferedInputStream.read()) != -1) {
                ((BufferedOutputStream)bufferedOutputStream).write(line);
                ((BufferedOutputStream)bufferedOutputStream).flush();
            }
            Attachment attachment = new Attachment();
            attachment.setFileName(fileName);
            attachment.setPath(AttachmentUtil.getAttachmentDir() + "/" + file.getName());
            Attachment attachment2 = attachment;
            return attachment2;
        }
        catch (Exception exception) {
            LOG.error(exception.toString());
            throw exception;
        }
        finally {
            if (bufferedOutputStream != null) {
                bufferedOutputStream.close();
            }
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
    }

    public static File createAttachmentFile(String fileName) throws Exception {
        try {
            File file = new File(AttachmentUtil.getAttachmentDir() + "/" + fileName);
            int i = 0;
            while (file.exists()) {
                file = new File(AttachmentUtil.getAttachmentDir() + "/" + AttachmentUtil.countFileName(fileName, i));
                ++i;
            }
            if (!file.createNewFile()) {
                throw new OBPMValidateException("Can't create file\uff01");
            }
            return file;
        }
        catch (Exception e) {
            LOG.error(e.toString());
            throw e;
        }
    }

    private static String countFileName(String fileName, int count) {
        int spx = fileName.lastIndexOf(46);
        String name = fileName.substring(0, spx);
        String type = fileName.substring(spx + 1);
        return name + String.valueOf(count) + "." + type;
    }

    public static String getAttachmentDir() throws Exception {
        String attachmentDir = EmailConfig.getString("attachment.dir", PropertyUtil.getPath() + "/email/attachment");
        if (StringUtil.isBlank((String)attachmentDir)) {
            throw new FileNotFoundException("E-mail storage system can not find the path!");
        }
        String osName = System.getProperty("os.name");
        if (attachmentDir.indexOf(58) >= 0 && osName.toLowerCase().indexOf("win") != -1) {
            File result = new File(attachmentDir);
            if (!result.exists() && !result.mkdirs()) {
                LOG.error("\u7cfb\u7edf\u65e0\u6cd5\u521b\u5efa\u90ae\u4ef6\u5b58\u653e\u8def\u5f84\uff01");
                throw new OBPMValidateException("The system can not create mail storage path!");
            }
            return attachmentDir;
        }
        String webPath = Environment.getInstance().getRealPath(attachmentDir);
        File result = new File(attachmentDir);
        if (!result.exists() && !result.mkdirs()) {
            throw new OBPMValidateException("System can't create file\uff01");
        }
        return webPath;
    }

    public static File createAttachmentTempFile() throws Exception {
        File tempFile = new File(AttachmentUtil.getAttachmentDir() + "/temp");
        if (!tempFile.exists() && !tempFile.mkdirs()) {
            LOG.warn("{}", (Object)"Can not create folder\uff01");
            throw new OBPMValidateException("Can not create folder!");
        }
        return tempFile;
    }

    public static void removeAttachmentFile(String fileName) {
        try {
            File file = new File(AttachmentUtil.getAttachmentDir() + "/" + fileName);
            if (file.exists() && file.delete()) {
                LOG.debug("{}", (Object)("Delete file: " + file.getPath() + " success"));
            }
        }
        catch (Exception e) {
            LOG.warn("{}", (Throwable)e);
        }
    }
}

