/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.runtime.parser;

import com.teemlink.email.runtime.model.Email;
import com.teemlink.email.runtime.model.EmailHeader;
import com.teemlink.email.runtime.model.EmailPart;
import com.teemlink.email.runtime.model.EmailSensitivity;
import com.teemlink.email.util.Environment;
import com.teemlink.email.util.FileOperate;
import com.teemlink.email.util.Utility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.mail.Flags;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageParser {
    private static final Logger log = LoggerFactory.getLogger(MessageParser.class);

    public static final Email parseMessage(Message message) {
        return MessageParser.parseMessage(message, false);
    }

    public static final Email parseMessage(Message message, boolean loadPartBody) {
        Email email = new Email();
        try {
            EmailHeader header = new EmailHeader();
            header.setFrom(message.getFrom());
            header.setTo(message.getRecipients(Message.RecipientType.TO));
            header.setCc(message.getRecipients(Message.RecipientType.CC));
            header.setBcc(message.getRecipients(Message.RecipientType.BCC));
            header.setReplyTo(message.getReplyTo());
            header.setDate(message.getSentDate());
            header.setSize(message.getSize());
            header.setSubject(Utility.decodeText(message.getSubject()));
            header.setUnread(!message.isSet(Flags.Flag.SEEN));
            header.setDateString(Utility.getDateToString(header.getDate()));
            header.setFromString(Utility.addressArrToString(header.getFrom()));
            header.setToString(Utility.addressArrToString(header.getTo()));
            header.setCcString(Utility.addressArrToString(header.getCc()));
            header.setSizeString(Utility.sizeToHumanReadable(header.getSize()));
            MessageParser.setHeaders(message, header);
            email.setBaseHeader(header);
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        List<EmailPart> parts = new ArrayList<EmailPart>();
        parts = MessageParser.fetchParts((Part)message, parts, loadPartBody);
        if (parts != null) {
            EmailPart part = null;
            for (int i = 0; i < parts.size(); ++i) {
                part = parts.get(i);
                part.setId(i);
            }
        }
        email.setParts(parts);
        try {
            Enumeration en = message.getAllHeaders();
            String val = "";
            Header tmp = null;
            while (en.hasMoreElements()) {
                tmp = (Header)en.nextElement();
                String name = tmp.getName();
                val = tmp.getValue();
                email.addHeader(name, val);
            }
        }
        catch (MessagingException e1) {
            log.error(e1.toString());
        }
        return email;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<EmailPart> fetchParts(Part part, List<EmailPart> parts, boolean loadPartBody) {
        block39: {
            if (part == null) {
                return null;
            }
            try {
                HashMap<String, String> emailImgMap = new HashMap<String, String>();
                if (!part.isMimeType("text/rfc822-headers") && part.isMimeType("text/*")) {
                    try {
                        Object pContent;
                        EmailPart myPart = new EmailPart();
                        myPart.setSize(part.getSize());
                        myPart.setContentType(part.getContentType());
                        myPart.setFileName(Utility.decodeText(part.getFileName()));
                        myPart.setDisposition(Utility.decodeText(part.getDisposition()));
                        try {
                            pContent = part.getContent();
                        }
                        catch (UnsupportedEncodingException e) {
                            pContent = "Message has an illegal encoding. " + e.getLocalizedMessage();
                        }
                        if (pContent != null) {
                            myPart.setContent(Utility.decodeText(pContent.toString()));
                        } else {
                            myPart.setContent("Illegal content");
                        }
                        parts.add(myPart);
                    }
                    catch (Exception e) {
                        log.error("Part is mimeType text/rfc822-headers and is mimeType text/* but exception occured", (Throwable)e);
                    }
                    break block39;
                }
                if (part.isMimeType("multipart/*")) {
                    try {
                        Multipart mp = (Multipart)part.getContent();
                        int count = mp.getCount();
                        for (int i = 0; i < count; ++i) {
                            MessageParser.fetchParts((Part)mp.getBodyPart(i), parts, loadPartBody);
                        }
                        break block39;
                    }
                    catch (Exception e) {
                        log.error("Part is mimeType multipart/* but exception occured", (Throwable)e);
                        break block39;
                    }
                }
                if (part.isMimeType("message/rfc822")) {
                    MessageParser.fetchParts((Part)part.getContent(), parts, loadPartBody);
                    break block39;
                }
                if (part.isMimeType("IMAGE/*")) {
                    try (InputStream is = null;){
                        is = part.getInputStream();
                        Environment env = Environment.getInstance();
                        String path = "/uploads/email/images/" + Utility.decodeText(part.getFileName());
                        String realPath = env.getRealPath(path);
                        FileOperate.writeFile(realPath, is);
                        String[] headContentID = part.getHeader("Content-ID");
                        if (headContentID != null) {
                            String cidString = "cid:" + headContentID[0].substring(1, headContentID[0].length() - 1);
                            emailImgMap.put(cidString, env.getContextPath() + path);
                            for (EmailPart part1 : parts) {
                                if (StringUtils.isBlank((String)part1.getContentType()) || !part1.getContentType().toLowerCase().equals("text/html; charset=gb2312")) continue;
                                String newContent = part1.getContent().toString().replace(cidString, (String)emailImgMap.get(cidString));
                                part1.setContent(newContent);
                            }
                        }
                        break block39;
                    }
                }
                try {
                    EmailPart myPart = new EmailPart();
                    myPart.setSize(part.getSize());
                    myPart.setContentType(part.getContentType());
                    myPart.setFileName(part.getFileName() == null ? "rfc822.txt" : Utility.decodeText(part.getFileName()));
                    myPart.setDisposition(Utility.decodeText(part.getDisposition()));
                    String[] headContentID = part.getHeader("Content-ID");
                    if (headContentID != null) {
                        myPart.setContentId(headContentID[0]);
                    }
                    if (loadPartBody) {
                        InputStream is = null;
                        ByteArrayOutputStream baos = null;
                        try {
                            is = part.getInputStream();
                            baos = new ByteArrayOutputStream();
                            int byteCount = 0;
                            while ((byteCount = is.read()) != -1) {
                                baos.write(byteCount);
                            }
                            myPart.setContent(baos);
                        }
                        catch (Exception e) {
                            log.error(e.toString());
                        }
                        finally {
                            if (baos != null) {
                                baos.close();
                            }
                            if (is != null) {
                                is.close();
                            }
                        }
                    }
                    parts.add(myPart);
                }
                catch (Exception e) {
                    log.error(e.toString());
                }
            }
            catch (MessagingException e) {
                log.error("fetchParts", (Throwable)e);
            }
            catch (IOException e) {
                log.error("fetchParts", (Throwable)e);
            }
        }
        return parts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final EmailPart parseMessagePart(Part part, String fileName) {
        EmailPart result = null;
        try {
            if (part.isMimeType("multipart/*")) {
                try {
                    Multipart mp = (Multipart)part.getContent();
                    int count = mp.getCount();
                    int i = 0;
                    while (i < count) {
                        result = MessageParser.parseMessagePart((Part)mp.getBodyPart(i), fileName);
                        if (result != null) {
                            return result;
                        }
                        ++i;
                    }
                    return result;
                }
                catch (Exception e) {
                    log.error("Part is mimeType multipart/* but exception occured", (Throwable)e);
                    return result;
                }
            }
            if (part.isMimeType("message/rfc822")) {
                return MessageParser.parseMessagePart((Part)part.getContent(), fileName);
            }
            InputStream is = null;
            ByteArrayOutputStream baos = null;
            try {
                String name;
                String string = name = part.getFileName() == null ? "rfc822.txt" : part.getFileName();
                if (!fileName.equals(Utility.decodeText(name))) {
                    EmailPart emailPart = null;
                    return emailPart;
                }
                result = new EmailPart();
                result.setSize(part.getSize());
                result.setContentType(part.getContentType());
                result.setFileName(name);
                result.setDisposition(part.getDisposition());
                String[] headContentID = part.getHeader("Content-ID");
                if (headContentID != null) {
                    result.setContentId(headContentID[0]);
                }
                is = part.getInputStream();
                baos = new ByteArrayOutputStream();
                int byteCount = 0;
                while ((byteCount = is.read()) != -1) {
                    baos.write(byteCount);
                }
                result.setContent(baos);
                return result;
            }
            catch (Exception e) {
                log.error(e.toString());
                return result;
            }
            finally {
                if (baos != null) {
                    baos.close();
                }
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        return result;
    }

    public static void setHeaders(Message email, EmailHeader header) throws MessagingException {
        Enumeration msgHeaders = email.getAllHeaders();
        while (msgHeaders.hasMoreElements()) {
            String value;
            Header msgHeader = (Header)msgHeaders.nextElement();
            String key = msgHeader.getName().toLowerCase();
            if (key.equals("disposition-notification-to")) {
                value = msgHeader.getValue().trim();
                if (value == null || value.length() <= 0) continue;
                header.setRequestReceiptNotification(true);
                header.setReceiptNotificationEmail(value);
                continue;
            }
            if (key.equals("x-priority")) {
                value = msgHeader.getValue().trim();
                try {
                    header.setPriority(Short.valueOf(value));
                }
                catch (Exception exception) {}
                continue;
            }
            if (key.equals("x-msmail-priority")) {
                if (header.getPriority() != 0) continue;
                value = msgHeader.getValue().trim();
                try {
                    header.setPriority(Short.valueOf(value));
                }
                catch (Exception exception) {}
                continue;
            }
            if (!key.equals("sensitivity")) continue;
            value = msgHeader.getValue().trim();
            try {
                header.setSensitivity(EmailSensitivity.valueOf(value));
            }
            catch (Exception e) {
                log.warn("{}", (Object)"Sensitivity exception!");
            }
        }
    }
}

