/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.runtime.model;

import com.teemlink.email.util.Utility;
import javax.activation.DataSource;

public class EmailPart {
    private static final long serialVersionUID = -1253290214253743384L;
    private int id;
    private Object content;
    private String disposition;
    private String contentType;
    private String contentId;
    private long size;
    private String sizeReadable;
    private String fileName;
    private String shortname;
    private DataSource dataSource;
    public static final String TEXT_BODY = "Text Body";
    public static final String BODY = "Body";
    public static final String HTML_BODY = "Html Body";

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Object getContent() {
        return this.content;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public void setDisposition(String disposition) {
        this.disposition = disposition;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentId() {
        return this.contentId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
        this.sizeReadable = Utility.sizeToHumanReadable(size);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
        if (this.fileName == null) {
            this.fileName = this.getContentType().toLowerCase().indexOf("text/html") >= 0 ? HTML_BODY : (this.getContentType().toLowerCase().indexOf("text/plain") >= 0 ? TEXT_BODY : BODY);
        }
        this.shortname = this.fileName;
    }

    public boolean isPlainText() {
        return this.contentType != null && this.contentType.indexOf("text/plain") >= 0;
    }

    public boolean isHTMLText() {
        return this.contentType != null && this.contentType.toLowerCase().indexOf("text/html") >= 0;
    }

    public boolean isImage() {
        return this.contentType != null && this.contentType.indexOf("image/") >= 0;
    }

    public boolean isAudio() {
        return this.contentType != null && this.contentType.indexOf("audio/") >= 0;
    }

    public String getSizeReadable() {
        return this.sizeReadable;
    }

    public void setSizeReadable(String string) {
        this.sizeReadable = string;
    }

    public String getShortname() {
        return this.shortname;
    }

    public void setShortname(String string) {
        this.shortname = string;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource source) {
        this.dataSource = source;
    }

    public void setContent(Object content, String type) {
        this.content = content;
        this.contentType = type;
    }
}

