/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.runtime.model;

import com.teemlink.email.runtime.model.ByteArrayDataSource;
import com.teemlink.email.runtime.model.EmailHeader;
import com.teemlink.email.runtime.model.EmailPart;
import com.teemlink.email.runtime.model.EmailPriority;
import com.teemlink.email.runtime.model.EmailSensitivity;
import com.teemlink.email.util.EmailConfig;
import com.teemlink.email.util.Utility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class Email
implements Serializable {
    private static final long serialVersionUID = 318395800499501554L;
    private Long uid;
    private List<EmailPart> parts = new ArrayList<EmailPart>();
    private EmailHeader baseHeader;
    private List<String> headers = new ArrayList<String>();
    private String bodyText;

    public List<EmailPart> getParts() {
        return this.parts;
    }

    public void setParts(List<EmailPart> parts) {
        this.parts = parts;
    }

    public boolean addHeader(String name, Object value) {
        this.headers.add(name + '\u0006' + value);
        return true;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<String> list) {
        this.headers = list;
    }

    public EmailHeader getBaseHeader() {
        if (this.baseHeader == null) {
            this.baseHeader = new EmailHeader();
        }
        return this.baseHeader;
    }

    public void setBaseHeader(EmailHeader header) {
        this.baseHeader = header;
    }

    public boolean isCcExists() {
        return this.getBaseHeader().getCc() != null;
    }

    public boolean isDateExists() {
        return this.getBaseHeader().getDate() != null;
    }

    public String getTo() {
        return Utility.addressArrToString(this.getBaseHeader().getTo());
    }

    public String getFrom() {
        String from = Utility.addressArrToString(this.getBaseHeader().getFrom());
        if (from.equals("")) {
            from = "-";
        }
        return from;
    }

    public String getCc() {
        return Utility.addressArrToString(this.getBaseHeader().getCc());
    }

    public Date getDate() {
        return this.getBaseHeader().getDate();
    }

    public String getSubject() {
        String subject = Utility.doCharsetCorrections(this.getBaseHeader().getSubject());
        if (subject == null || subject.length() == 0) {
            subject = "No Subject";
        }
        return subject;
    }

    public String getBodyText() {
        return this.bodyText;
    }

    public void setBodyText(String string) {
        this.bodyText = string;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public void addPart(EmailPart part) {
        if (this.getParts() == null) {
            this.setParts(new ArrayList<EmailPart>());
        }
        if (part != null) {
            this.getParts().add(part);
        }
    }

    public Message toMessage(Session session) throws MessagingException, IOException {
        boolean isTextBody;
        Address[] to = this.getBaseHeader().getTo();
        Address[] cc = this.getBaseHeader().getCc();
        Address[] bcc = this.getBaseHeader().getBcc();
        Address[] replyTo = this.getBaseHeader().getReplyTo();
        Boolean requestReceiptNotification = this.getBaseHeader().getRequestReceiptNotification();
        short priority = this.getBaseHeader().getPriority();
        short sensitivity = this.getBaseHeader().getSensitivity();
        MimeMessage mimeMsg = new MimeMessage(session);
        String subject = this.getBaseHeader().getSubject();
        Address[] froms = this.getBaseHeader().getFrom();
        if (froms != null && froms.length > 0) {
            mimeMsg.setFrom(froms[0]);
            if (requestReceiptNotification != null) {
                mimeMsg.addHeader("Disposition-Notification-To", froms[0].toString());
            }
        }
        if (to != null) {
            mimeMsg.setRecipients(Message.RecipientType.TO, to);
        }
        if (cc != null) {
            mimeMsg.setRecipients(Message.RecipientType.CC, cc);
        }
        if (bcc != null) {
            mimeMsg.setRecipients(Message.RecipientType.BCC, bcc);
        }
        if (replyTo != null) {
            mimeMsg.setReplyTo(replyTo);
        }
        mimeMsg.setSentDate(new Date());
        if (subject == null || subject.length() == 0) {
            subject = "No subject";
        }
        if (priority > 0) {
            mimeMsg.addHeader("X-Priority", String.valueOf(priority));
            mimeMsg.addHeader("X-MSMail-Priority", EmailPriority.toStringValue(priority));
        }
        if (sensitivity > 0) {
            mimeMsg.addHeader("Sensitivity", EmailSensitivity.toStringValue(sensitivity));
        }
        String charset = EmailConfig.getString("charset", "UTF-8");
        mimeMsg.setSubject(MimeUtility.encodeText((String)subject, (String)charset, null));
        List<EmailPart> parts = this.getParts();
        EmailPart bodyPart = parts.get(0);
        boolean bl = isTextBody = !bodyPart.isHTMLText();
        if (parts.size() == 1 && isTextBody) {
            mimeMsg.setText((String)bodyPart.getContent(), charset);
        } else {
            MimeBodyPart bp = new MimeBodyPart();
            bp.setContent((Object)((String)bodyPart.getContent()), bodyPart.getContentType());
            bp.setHeader("Content-Type", bodyPart.getContentType());
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)bp);
            MimeBodyPart attPart = null;
            EmailPart myPart = null;
            DataSource dataSource = null;
            String tmpContType = null;
            int pos = -1;
            for (int i = 1; i < this.getParts().size(); ++i) {
                myPart = this.getParts().get(i);
                attPart = new MimeBodyPart();
                dataSource = myPart.getDataSource();
                if (dataSource == null) {
                    if (myPart.getContent() instanceof ByteArrayOutputStream) {
                        ByteArrayOutputStream bos = (ByteArrayOutputStream)myPart.getContent();
                        dataSource = new ByteArrayDataSource(bos.toByteArray(), myPart.getContentType(), myPart.getFileName());
                        attPart.setDataHandler(new DataHandler(dataSource));
                        bos.close();
                    } else if (myPart.getContent() instanceof ByteArrayInputStream) {
                        ByteArrayInputStream bis = (ByteArrayInputStream)myPart.getContent();
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        int j = -1;
                        while ((j = bis.read()) != -1) {
                            bos.write(j);
                        }
                        dataSource = new ByteArrayDataSource(bos.toByteArray(), myPart.getContentType(), myPart.getFileName());
                        attPart.setDataHandler(new DataHandler(dataSource));
                        bos.close();
                        bis.close();
                    } else {
                        attPart.setContent(myPart.getContent(), myPart.getContentType());
                    }
                } else {
                    attPart.setDataHandler(new DataHandler(dataSource));
                }
                attPart.setDisposition(myPart.getDisposition());
                attPart.setFileName(MimeUtility.encodeText((String)myPart.getFileName(), (String)charset, null));
                tmpContType = myPart.getContentType() == null ? "application/octet-stream" : myPart.getContentType();
                pos = tmpContType.indexOf(";");
                if (pos >= 0) {
                    tmpContType = tmpContType.substring(0, pos);
                }
                attPart.setHeader("Content-Type", tmpContType);
                multipart.addBodyPart((BodyPart)attPart);
            }
            mimeMsg.setContent((Multipart)multipart);
        }
        return mimeMsg;
    }
}

