/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.runtime.mail;

import com.sun.mail.smtp.SMTPMessage;
import com.sun.net.ssl.internal.ssl.Provider;
import com.teemlink.email.runtime.mail.AuthProfile;
import com.teemlink.email.runtime.mail.ConnectionProfile;
import com.teemlink.email.runtime.mail.OBPMAuthenticator;
import com.teemlink.email.runtime.model.ByteArrayDataSource;
import com.teemlink.email.runtime.model.Email;
import com.teemlink.email.runtime.model.EmailPart;
import com.teemlink.email.runtime.model.EmailPriority;
import com.teemlink.email.runtime.model.EmailSensitivity;
import com.teemlink.email.util.EmailConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.Security;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Smtp {
    private static Logger log = LoggerFactory.getLogger(Smtp.class);
    private Session session = null;
    private ConnectionProfile profile;
    private AuthProfile auth;

    public Smtp(ConnectionProfile profile, AuthProfile auth, String emailDomain) {
        Properties props = new Properties();
        this.profile = profile;
        this.auth = auth;
        props.setProperty("mail.debug", "true");
        if (profile.getSmtpSSL() != null && profile.getSmtpSSL().toLowerCase().equals("true")) {
            Security.addProvider((java.security.Provider)new Provider());
            Security.setProperty("ssl.SocketFactory.provider", "javax.net.ssl.SSLSocketFactory");
            props.setProperty("mail.smtps.socketFactory.class", "com.teemlink.email.runtime.mail.OBPMSSLSocketFactory");
            props.setProperty("mail.smtps.socketFactory.fallback", "false");
            props.setProperty("mail.smtps.socketFactory.port", Integer.toString(profile.getISmtpPort()));
            props.put("mail.smtps.host", profile.getSmtpServer());
            props.put("mail.smtps.port", Integer.toString(profile.getISmtpPort()));
        } else {
            props.put("mail.smtp.host", profile.getSmtpServer());
            props.put("mail.smtp.port", Integer.toString(profile.getISmtpPort()));
        }
        if (profile.getSmtpAuthenticated() != null && profile.getSmtpAuthenticated().equals("true")) {
            if (profile.getSmtpSSL() != null && profile.getSmtpSSL().toLowerCase().equals("true")) {
                props.setProperty("mail.smtps.auth", "true");
            } else {
                props.setProperty("mail.smtp.auth", "true");
            }
            OBPMAuthenticator authenticator = new OBPMAuthenticator(auth.getUserName() + "@" + emailDomain, auth.getPassword());
            this.session = Session.getInstance((Properties)props, (Authenticator)authenticator);
        } else {
            this.session = Session.getInstance((Properties)props, null);
        }
        if (log.isDebugEnabled()) {
            this.session.setDebug(true);
        }
    }

    public HashMap sendEmail(Email msg, boolean simulate, String emailDomain) throws Exception {
        boolean isTextBody;
        Address from = msg.getBaseHeader().getFrom()[0];
        if (from == null) {
            String address = this.auth.getUserName() + "@" + emailDomain;
            from = new InternetAddress(address);
        }
        Address[] to = msg.getBaseHeader().getTo();
        Address[] cc = msg.getBaseHeader().getCc();
        Address[] bcc = msg.getBaseHeader().getBcc();
        Address[] replyTo = msg.getBaseHeader().getReplyTo();
        Boolean requestReceiptNotification = msg.getBaseHeader().getRequestReceiptNotification();
        short priority = msg.getBaseHeader().getPriority();
        short sensitivity = msg.getBaseHeader().getSensitivity();
        SMTPMessage mimeMsg = new SMTPMessage(this.session);
        String subject = msg.getBaseHeader().getSubject();
        mimeMsg.setFrom(from);
        if (to != null) {
            mimeMsg.setRecipients(Message.RecipientType.TO, to);
        }
        if (cc != null) {
            mimeMsg.setRecipients(Message.RecipientType.CC, cc);
        }
        if (bcc != null) {
            mimeMsg.setRecipients(Message.RecipientType.BCC, bcc);
        }
        if (replyTo != null) {
            mimeMsg.setReplyTo(replyTo);
        }
        mimeMsg.setSentDate(new Date());
        if (subject == null || subject.length() == 0) {
            subject = "No subject";
        }
        if (requestReceiptNotification != null) {
            mimeMsg.addHeader("Disposition-Notification-To", from.toString());
        }
        if (priority > 0) {
            mimeMsg.addHeader("X-Priority", String.valueOf(priority));
            mimeMsg.addHeader("X-MSMail-Priority", EmailPriority.toStringValue(priority));
        }
        if (sensitivity > 0) {
            mimeMsg.addHeader("Sensitivity", EmailSensitivity.toStringValue(sensitivity));
        }
        String charset = EmailConfig.getString("charset", "UTF-8");
        mimeMsg.setSubject(MimeUtility.encodeText((String)subject, (String)charset, null));
        List<EmailPart> parts = msg.getParts();
        EmailPart bodyPart = parts.get(0);
        boolean bl = isTextBody = !bodyPart.isHTMLText();
        if (parts.size() == 1 && isTextBody) {
            mimeMsg.setText((String)bodyPart.getContent(), charset);
        } else {
            MimeBodyPart bp = new MimeBodyPart();
            bp.setContent((Object)((String)bodyPart.getContent()), bodyPart.getContentType());
            bp.setHeader("Content-Type", bodyPart.getContentType());
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)bp);
            MimeBodyPart attPart = null;
            EmailPart myPart = null;
            DataSource dataSource = null;
            String tmpContType = null;
            int pos = -1;
            for (int i = 1; i < msg.getParts().size(); ++i) {
                myPart = msg.getParts().get(i);
                attPart = new MimeBodyPart();
                dataSource = myPart.getDataSource();
                if (dataSource == null) {
                    if (myPart.getContent() instanceof ByteArrayOutputStream) {
                        ByteArrayOutputStream bos = (ByteArrayOutputStream)myPart.getContent();
                        dataSource = new ByteArrayDataSource(bos.toByteArray(), myPart.getContentType(), myPart.getFileName());
                        attPart.setDataHandler(new DataHandler(dataSource));
                        bos.close();
                    } else if (myPart.getContent() instanceof ByteArrayInputStream) {
                        ByteArrayInputStream bis = (ByteArrayInputStream)myPart.getContent();
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        int j = -1;
                        while ((j = bis.read()) != -1) {
                            bos.write(j);
                        }
                        dataSource = new ByteArrayDataSource(bos.toByteArray(), myPart.getContentType(), myPart.getFileName());
                        attPart.setDataHandler(new DataHandler(dataSource));
                        bos.close();
                        bis.close();
                    } else {
                        attPart.setContent(myPart.getContent(), myPart.getContentType());
                    }
                } else {
                    attPart.setDataHandler(new DataHandler(dataSource));
                }
                attPart.setDisposition(myPart.getDisposition());
                attPart.setFileName(MimeUtility.encodeText((String)myPart.getFileName(), (String)charset, null));
                tmpContType = myPart.getContentType() == null ? "application/octet-stream" : myPart.getContentType();
                pos = tmpContType.indexOf(";");
                if (pos >= 0) {
                    tmpContType = tmpContType.substring(0, pos);
                }
                attPart.setHeader("Content-Type", tmpContType);
                multipart.addBodyPart((BodyPart)attPart);
            }
            mimeMsg.setContent((Multipart)multipart);
        }
        mimeMsg.saveChanges();
        HashMap out = new HashMap();
        if (!simulate) {
            try {
                mimeMsg.setSendPartial(true);
                mimeMsg.setSentDate(new Date());
                this.sendEmail((Message)mimeMsg);
            }
            catch (SendFailedException sex) {
                throw new Exception(sex.getMessage());
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof SSLException) {
                    log.error("an SSL exception occured. try to go on." + ex);
                    throw ex;
                }
                throw ex;
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEmail(Message message) throws Exception {
        if (this.profile.getSmtpSSL() != null && this.profile.getSmtpSSL().toLowerCase().equals("true")) {
            Transport transport = null;
            try {
                transport = this.session.getTransport("smtps");
                transport.connect(this.profile.getSmtpServer(), this.auth.getUserName(), this.auth.getPassword());
                transport.sendMessage(message, message.getAllRecipients());
            }
            catch (Exception ex) {
                if (ex.getCause() != null) {
                    if (ex.getCause() instanceof SSLException) {
                        log.error("An SSL exception occured. try to go on." + ex);
                    }
                    throw ex;
                }
                throw ex;
            }
            finally {
                if (transport != null && transport.isConnected()) {
                    transport.close();
                }
            }
        } else {
            Transport.send((Message)message);
        }
    }

    public static void main(String[] args) {
    }
}

