/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.runtime.mail;

import com.teemlink.email.runtime.mail.AuthProfile;
import com.teemlink.email.runtime.mail.ConnectionMetaHandler;
import com.teemlink.email.runtime.mail.ConnectionProfile;
import com.teemlink.email.runtime.mail.ImapProtocolImpl;
import com.teemlink.email.runtime.mail.Pop3ProtocolImpl;
import com.teemlink.email.runtime.mail.Protocol;
import org.springframework.stereotype.Component;

@Component
public class ProtocolFactory {
    private static final long serialVersionUID = -6459184572982090224L;
    private ConnectionProfile profile;
    private AuthProfile auth;
    private ConnectionMetaHandler handler;
    private String emailDomain;

    public ProtocolFactory(ConnectionProfile profile, AuthProfile auth, ConnectionMetaHandler handler, String emailDomain) {
        this.profile = profile;
        this.auth = auth;
        this.handler = handler;
        this.emailDomain = emailDomain;
    }

    public ProtocolFactory() {
    }

    private Protocol getPop3Protocol(String folderName) {
        return new Pop3ProtocolImpl(this.profile, folderName, this.auth, this.handler, this.emailDomain);
    }

    private Protocol getImapProtocol(String folderName) {
        return new ImapProtocolImpl(this.profile, folderName, this.auth, this.handler, this.emailDomain);
    }

    public Protocol getProtocol(String folderName) {
        if (this.profile.getProtocol().equals("pop3")) {
            return this.getPop3Protocol(folderName);
        }
        return this.getImapProtocol(folderName);
    }

    public ConnectionProfile getProfile() {
        return this.profile;
    }

    public AuthProfile getAuth() {
        return this.auth;
    }

    public ConnectionMetaHandler getConnectionMetaHandler() {
        return this.handler;
    }

    public void setConnectionMetaHandler(ConnectionMetaHandler handler) {
        this.handler = handler;
    }
}

