/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.runtime.mail;

import cn.myapps.common.exception.OBPMValidateException;
import com.sun.mail.imap.AppendUID;
import com.sun.mail.imap.IMAPFolder;
import com.sun.net.ssl.internal.ssl.Provider;
import com.teemlink.email.runtime.mail.AuthProfile;
import com.teemlink.email.runtime.mail.ConnectionMetaHandler;
import com.teemlink.email.runtime.mail.ConnectionProfile;
import com.teemlink.email.runtime.mail.FolderCache;
import com.teemlink.email.runtime.mail.Protocol;
import com.teemlink.email.runtime.mail.ProtocolFactory;
import com.teemlink.email.runtime.model.Email;
import com.teemlink.email.runtime.model.EmailHeader;
import com.teemlink.email.util.Utility;
import java.security.Security;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImapProtocolImpl
implements Protocol {
    private static Logger log = LoggerFactory.getLogger(ImapProtocolImpl.class);
    private ConnectionMetaHandler handler;
    private String folderName;
    private ConnectionProfile profile;
    private AuthProfile auth;
    private String emailDomain;

    public ImapProtocolImpl(ConnectionProfile profile, String folderName, AuthProfile auth, ConnectionMetaHandler handler, String emailDomain) {
        this.profile = profile;
        this.folderName = folderName;
        this.auth = auth;
        this.handler = handler;
        this.emailDomain = emailDomain;
    }

    public void setEmailDomain(String emailDomain) {
        this.emailDomain = emailDomain;
    }

    @Override
    public ConnectionMetaHandler connect(int connectType) throws Exception {
        return this.connect(connectType, false);
    }

    @Override
    public ConnectionMetaHandler connect(int connectType, boolean debug) throws Exception {
        try {
            Properties props = System.getProperties();
            if (this.handler == null || this.handler.getStore() == null || !this.handler.getStore().isConnected()) {
                if (log.isDebugEnabled()) {
                    props.setProperty("mail.debug", "true");
                    System.setProperty("javax.net.debug", "all");
                }
                if (this.profile.getFetchSSL() != null && this.profile.getFetchSSL().toLowerCase().equals("true")) {
                    Security.addProvider((java.security.Provider)new Provider());
                    Security.setProperty("ssl.SocketFactory.provider", "javax.net.ssl.SSLSocketFactory");
                    props.setProperty("mail.store.protocol", "imap");
                    props.setProperty("mail.imap.host", this.profile.getFetchServer());
                    props.setProperty("mail.imap.port", this.profile.getFetchPort());
                    props.setProperty("mail.imap.socketFactory.class", "com.teemlink.email.runtime.mail.OBPMSSLSocketFactory");
                    props.setProperty("mail.imap.socketFactory.fallback", "false");
                    props.setProperty("mail.imap.socketFactory.port", this.profile.getFetchPort());
                } else {
                    Security.removeProvider("ssl.SocketFactory.provider");
                    props.remove("mail.imap.socketFactory.class");
                    props.remove("mail.imap.socketFactory.fallback");
                }
                props.setProperty("mail.imap.auth.plain.disable", "true");
                Session session = Session.getDefaultInstance((Properties)props);
                session.setDebug(debug);
                log.debug("{}", (Object)"session instance initiated");
                if (this.handler == null) {
                    this.handler = new ConnectionMetaHandler();
                }
                this.handler.setStore(session.getStore(this.profile.getProtocol()));
                log.debug("{}", (Object)("session store set. protocol is: " + this.profile.getProtocol()));
                this.handler.getStore().connect(this.profile.getFetchServer(), this.profile.getIFetchPort(), this.auth.getUserName() + "@" + this.emailDomain, this.auth.getPassword());
                if (this.handler.getStore().isConnected()) {
                    log.debug("{}", (Object)"Store has been connected... Successful");
                } else {
                    log.warn("{}", (Object)"Connection unsuccessfull...!!");
                }
                this.handler.initFolders();
            }
            Folder folder = this.handler.getStore().getFolder(this.folderName);
            this.handler.setFolder(folder);
            log.debug("{}", (Object)("Got mailbox folder. Folder is: " + folder.getFullName()));
            Map<String, Folder> imapUserFolders = FolderCache.getUserFolderMap(this.auth);
            imapUserFolders.put(this.folderName, folder);
            FolderCache.putUserFolderMap(this.auth, imapUserFolders);
        }
        catch (Exception e) {
            log.error(e.toString());
            throw e;
        }
        return this.handler;
    }

    @Override
    public ConnectionMetaHandler deleteMessages(int[] messageIds) throws Exception {
        Folder folder = null;
        folder = this.getFolder();
        if (messageIds != null && messageIds.length > 0) {
            for (int i = 0; i < messageIds.length; ++i) {
                try {
                    if (messageIds[i] <= 0) continue;
                    Message msg = folder.getMessage(messageIds[i]);
                    msg.setFlag(Flags.Flag.DELETED, true);
                    continue;
                }
                catch (Exception e) {
                    log.debug("{}", (Object)"error while deleting messsage", (Object)e);
                }
            }
            folder.expunge();
        }
        return this.handler;
    }

    @Override
    public void disconnect() throws Exception {
        try {
            Map<String, Folder> imapUserFolders = FolderCache.getUserFolderMap(this.auth);
            Iterator<String> iter = imapUserFolders.keySet().iterator();
            Folder tmp = null;
            while (iter.hasNext()) {
                try {
                    tmp = imapUserFolders.get(iter.next());
                    this.closeFolder(tmp);
                    tmp = null;
                }
                catch (Throwable e) {
                    log.debug("{}", (Object)("Unable to close folder:" + tmp));
                }
            }
            FolderCache.removeUserFolderMap(this.auth);
        }
        catch (Throwable e1) {
            e1.printStackTrace();
        }
    }

    public void updateFolders() throws Exception {
        if (this.handler != null) {
            this.handler.initFolders();
        }
    }

    public void closeFolder(Folder folder) {
        if (folder != null) {
            try {
                if (folder.isOpen()) {
                    folder.close(true);
                    log.debug("{}", (Object)("Folder: " + folder.getName() + " was open and now closed."));
                    Map<String, Folder> imapUserFolders = FolderCache.getUserFolderMap(this.auth);
                    imapUserFolders.put(folder.getName(), null);
                    FolderCache.putUserFolderMap(this.auth, imapUserFolders);
                } else {
                    log.debug("{}", (Object)("Folder: " + folder.getName() + " was already closed."));
                }
            }
            catch (MessagingException e) {
                log.debug("{}", (Object)("Error while closing folder: " + folder.getName()), (Object)e);
            }
        }
    }

    @Override
    public void emptyFolder() throws Exception {
        Folder folder = this.getFolder();
        try {
            Message[] msgs = folder.getMessages();
            FetchProfile fp = new FetchProfile();
            fp.add(FetchProfile.Item.ENVELOPE);
            folder.fetch(msgs, fp);
            int[] ids = new int[msgs.length];
            for (int i = 0; i < msgs.length; ++i) {
                ids[i] = msgs[i].getMessageNumber();
            }
            if (ids.length > 0) {
                this.flagAsDeleted(ids);
            }
        }
        catch (Exception e) {
            log.warn("{}", (Object)("Could not delete all messages in folder: " + this.folderName));
        }
    }

    public void renameFolder(String newName) throws Exception {
        Folder folder = this.getFolder();
        Folder fNew = this.handler.getStore().getFolder(this.profile.getFolderNameSpace() + newName);
        this.closeFolder(folder);
        folder.renameTo(fNew);
        fNew.setSubscribed(true);
    }

    @Override
    public Message getMessage(int messageId) throws Exception {
        Message message = null;
        Folder folder = null;
        try {
            folder = this.getFolder();
            message = folder.getMessage(messageId);
        }
        catch (MessagingException e) {
            log.error("Could not fetch message body from remote server.", (Throwable)e);
            throw e;
        }
        return message;
    }

    public String getMessageUID(Message message) throws Exception {
        IMAPFolder folder = null;
        folder = (IMAPFolder)this.getFolder();
        return String.valueOf(folder.getUID(message));
    }

    public Message getMessageByUID(long uid) throws Exception {
        Object messages = null;
        IMAPFolder folder = null;
        Message message = null;
        try {
            folder = (IMAPFolder)this.getFolder();
            message = folder.getMessage((int)uid);
        }
        catch (MessagingException e) {
            log.error("Could not fetch message body from remote server.", (Throwable)e);
            throw e;
        }
        return message;
    }

    @Override
    public Message[] getMessages(int stratid, int endid) throws Exception {
        Message[] messages = null;
        try {
            Folder folder = this.getFolder();
            messages = folder.getMessages(stratid, endid);
        }
        catch (MessagingException e) {
            log.error("Could not fetch message body from remote server.", (Throwable)e);
            throw e;
        }
        return messages;
    }

    public Message[] getMessagesByUID(long start, long end) throws Exception {
        Message[] messages = null;
        try {
            IMAPFolder folder = (IMAPFolder)this.getFolder();
            messages = folder.getMessagesByUID(start, end);
        }
        catch (MessagingException e) {
            log.error("Could not fetch message body from remote server.", (Throwable)e);
            throw e;
        }
        return messages;
    }

    public Message[] getMessagesByUID(long[] uids) throws Exception {
        Message[] messages = null;
        try {
            IMAPFolder folder = (IMAPFolder)this.getFolder();
            messages = folder.getMessagesByUID(uids);
        }
        catch (MessagingException e) {
            log.error("Could not fetch message body from remote server.", (Throwable)e);
            throw e;
        }
        return messages;
    }

    @Override
    public int getTotalMessageCount() throws Exception {
        Folder folder = this.getFolder();
        if (folder.exists()) {
            return folder.getMessageCount();
        }
        return 0;
    }

    @Override
    public int getUnreadMessageCount() throws Exception {
        Folder folder = this.getFolder();
        if (folder.exists()) {
            return folder.getUnreadMessageCount();
        }
        return 0;
    }

    public void markAsReadByUID(long uid) throws Exception {
        IMAPFolder folder = (IMAPFolder)this.getFolder();
        try {
            Message msg = folder.getMessage((int)uid);
            msg.setFlag(Flags.Flag.SEEN, true);
        }
        catch (MessagingException e) {
            log.warn("{}", (Object)"Marking as Read not worked.", (Object)e);
        }
    }

    public void markAsReadByUID(long uid, boolean read) throws Exception {
        IMAPFolder folder = (IMAPFolder)this.getFolder();
        try {
            Message msg = folder.getMessage((int)uid);
            msg.setFlag(Flags.Flag.SEEN, read);
        }
        catch (MessagingException e) {
            log.warn("{}", (Object)"Marking as Read not worked.", (Object)e);
        }
    }

    public Folder getImapFolder(boolean useCache) throws Exception {
        Folder myFolder = null;
        if (this.isBlank(this.folderName)) {
            this.folderName = "INBOX";
        }
        if (this.handler != null) {
            Store store = this.handler.getStore();
            if (store == null || !store.isConnected()) {
                log.debug("{}", (Object)"Connection is closed. Restoring it...");
                this.handler = this.connect(2);
                log.debug("{}", (Object)"Connection re-established");
            }
            Map<String, Folder> imapUserFolders = null;
            if (useCache) {
                imapUserFolders = FolderCache.getUserFolderMap(this.auth);
                myFolder = imapUserFolders.get(this.folderName);
            }
            if (myFolder == null) {
                myFolder = this.handler.getStore().getFolder(this.folderName);
            }
            if (!myFolder.isOpen()) {
                try {
                    log.debug("{}", (Object)("Folder :" + this.folderName + " is closed. Opening."));
                    myFolder.open(2);
                    log.debug("{}", (Object)"Folder is open.");
                }
                catch (Throwable e) {
                    log.debug("{}", (Object)"nevermind go on");
                }
            }
            if (useCache) {
                try {
                    imapUserFolders.put(this.folderName, myFolder);
                    FolderCache.putUserFolderMap(this.auth, imapUserFolders);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return myFolder;
    }

    @Override
    public Folder getFolder() throws Exception {
        return this.getImapFolder(true);
    }

    public void createFolder() throws Exception {
        Folder folder = this.getFolder();
        try {
            if (!folder.exists()) {
                folder.create(1);
                folder.setSubscribed(true);
            } else if (!folder.isSubscribed()) {
                folder.setSubscribed(true);
            }
        }
        catch (MessagingException e) {
            if (folder != null) {
                log.warn("{}", (Object)("Could not create folder: " + folder.getName()));
            }
            throw e;
        }
    }

    public void renameTo(String folderName) throws Exception {
        if (this.isBlank(folderName)) {
            throw new OBPMValidateException("\u6587\u4ef6\u5939\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.handler.getFolder().renameTo(this.handler.getStore().getFolder(folderName));
    }

    public void deleteFolder(boolean flag) throws Exception {
        long folderid = ((IMAPFolder)this.handler.getFolder()).getUIDValidity();
        this.handler.closeFolder(true);
        this.handler.getFolder().delete(flag);
        this.handler.removeFolder(folderid);
    }

    @Override
    public void flagAsDeleted(int[] ids) throws Exception {
        Folder folder = null;
        try {
            folder = this.getFolder();
            if (ids != null && ids.length > 0) {
                for (int i = 0; i < ids.length; ++i) {
                    try {
                        if (ids[i] <= 0) continue;
                        Message msg = folder.getMessage(ids[i]);
                        msg.setFlag(Flags.Flag.SEEN, true);
                        msg.setFlag(Flags.Flag.DELETED, true);
                        continue;
                    }
                    catch (Exception e) {
                        log.debug("{}", (Object)"error while deleting messsage", (Object)e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Could not delete message ids!", (Throwable)e);
            throw e;
        }
    }

    public void deletedMessageByUID(long[] uids) throws Exception {
        IMAPFolder folder = null;
        try {
            folder = (IMAPFolder)this.getFolder();
            if (uids != null && uids.length > 0) {
                for (int i = 0; i < uids.length; ++i) {
                    try {
                        if (uids[i] <= 0L) continue;
                        Message msg = folder.getMessage((int)uids[i]);
                        msg.setFlag(Flags.Flag.SEEN, true);
                        msg.setFlag(Flags.Flag.DELETED, true);
                        continue;
                    }
                    catch (Exception e) {
                        log.debug("{}", (Object)"error while deleting messsage", (Object)e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Could not delete message ids!", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Folder[] listFolders() throws Exception {
        ProtocolFactory factory = new ProtocolFactory(this.profile, this.auth, this.handler, this.emailDomain);
        ImapProtocolImpl protocol = (ImapProtocolImpl)factory.getProtocol(this.folderName);
        Folder folder = protocol.getFolder();
        Folder parent = null;
        Folder[] folders = null;
        try {
            parent = folder.getParent();
            folders = parent.list();
        }
        catch (MessagingException e) {
            log.warn("{}", (Object)"Cannot get folder list.");
        }
        return folders;
    }

    public void moveMessageByUID(long uid, String destFolder) throws Exception {
        ProtocolFactory factory = new ProtocolFactory(this.profile, this.auth, this.handler, this.emailDomain);
        ImapProtocolImpl fromProtocol = (ImapProtocolImpl)factory.getProtocol(this.folderName);
        ImapProtocolImpl destProtocol = (ImapProtocolImpl)factory.getProtocol(destFolder);
        Folder from = fromProtocol.getFolder();
        Folder dest = null;
        try {
            Message msg = fromProtocol.getMessageByUID(uid);
            if (msg != null) {
                from = fromProtocol.getFolder();
                dest = destProtocol.getFolder();
                from.copyMessages(new Message[]{msg}, dest);
                this.flagAsDeleted(new int[]{msg.getMessageNumber()});
            }
        }
        catch (IndexOutOfBoundsException e) {
            log.debug("{}", (Object)("Index ka\u00e7t\u0131. Moving message to folder : " + destFolder + " failed."), (Object)e);
        }
        catch (Exception e) {
            log.warn("{}", (Object)("Moving message to folder : " + destFolder + " failed."), (Object)e);
        }
    }

    public void moveMessagesByUID(long[] uids, String destFolder) throws Exception {
        ProtocolFactory factory = new ProtocolFactory(this.profile, this.auth, this.handler, this.emailDomain);
        ImapProtocolImpl fromProtocol = (ImapProtocolImpl)factory.getProtocol(this.folderName);
        ImapProtocolImpl destProtocol = (ImapProtocolImpl)factory.getProtocol(destFolder);
        Folder from = fromProtocol.getFolder();
        Folder dest = null;
        try {
            Message msg = null;
            int counter = 0;
            dest = destProtocol.getFolder();
            MimeMessage[] msgs = new MimeMessage[uids.length];
            int[] nums = new int[uids.length];
            for (int i = 0; i < uids.length; ++i) {
                try {
                    msg = fromProtocol.getMessageByUID(uids[i]);
                    if (msg == null) continue;
                    msgs[counter] = msg;
                    nums[counter] = msg.getMessageNumber();
                    ++counter;
                    continue;
                }
                catch (Exception e) {
                    log.debug("{}", (Object)"error while copying messages", (Object)e);
                }
            }
            from.copyMessages((Message[])msgs, dest);
            this.flagAsDeleted(nums);
        }
        catch (IndexOutOfBoundsException e) {
            log.debug("{}", (Object)("Index ka\u00e7t\u0131. Moving message to folder : " + destFolder + " failed."), (Object)e);
        }
        catch (Exception e) {
            log.warn("{}", (Object)("Moving message to folder : " + destFolder + " failed."), (Object)e);
        }
    }

    public void moveMessagesByUID(long[] uids, String[] destFolders) throws Exception {
        ProtocolFactory factory = new ProtocolFactory(this.profile, this.auth, this.handler, this.emailDomain);
        ImapProtocolImpl fromProtocol = (ImapProtocolImpl)factory.getProtocol(this.folderName);
        Folder from = fromProtocol.getFolder();
        Folder dest = null;
        try {
            Message msg = null;
            int[] nums = new int[uids.length];
            for (int i = 0; i < uids.length; ++i) {
                try {
                    msg = fromProtocol.getMessageByUID(uids[i]);
                    nums[i] = msg.getMessageNumber();
                    ImapProtocolImpl destProtocol = (ImapProtocolImpl)factory.getProtocol(destFolders[i]);
                    dest = destProtocol.getFolder();
                    from.copyMessages(new Message[]{msg}, dest);
                    continue;
                }
                catch (Exception e) {
                    log.debug("{}", (Object)"error while copying messages", (Object)e);
                }
            }
            this.flagAsDeleted(nums);
        }
        catch (Exception e) {
            log.warn("{}", (Object)"Moving message failed.", (Object)e);
        }
    }

    protected boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    @Override
    public List<EmailHeader> fetchAllHeaders() throws Exception {
        return this.fetchHeaders(null);
    }

    @Override
    public List<Message> fetchAllHeadersAsMessages() throws Exception {
        ArrayList<Message> headers = null;
        Folder folder = null;
        try {
            headers = new ArrayList<Message>();
            folder = this.getFolder();
            Message[] msgs = folder.getMessages();
            FetchProfile fp = new FetchProfile();
            fp.add(FetchProfile.Item.ENVELOPE);
            fp.add(FetchProfile.Item.FLAGS);
            fp.add(FetchProfile.Item.CONTENT_INFO);
            fp.add("Size");
            fp.add("Date");
            folder.fetch(msgs, fp);
            Message msg = null;
            for (int i = 0; i < msgs.length; ++i) {
                try {
                    msg = msgs[i];
                    boolean deleted = false;
                    Flags.Flag[] flags = msg.getFlags().getSystemFlags();
                    if (flags != null) {
                        Flags.Flag flag = null;
                        for (int m = 0; m < flags.length; ++m) {
                            flag = flags[m];
                            if (!flag.equals(Flags.Flag.DELETED)) continue;
                            deleted = true;
                        }
                    }
                    if (deleted) continue;
                    headers.add(msg);
                    continue;
                }
                catch (Exception e) {
                    log.debug("{}", (Object)"probably an error fetching list", (Object)e);
                }
            }
        }
        catch (MessagingException e) {
            log.error("Could not fetch message headers. Is mbox connection still alive???", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Could not fetch message headers. Is mbox connection still alive???", (Throwable)e);
            throw e;
        }
        return headers;
    }

    @Override
    public List<EmailHeader> fetchHeaders(int[] indexs) throws Exception {
        ArrayList<EmailHeader> headers = new ArrayList<EmailHeader>();
        IMAPFolder folder = null;
        try {
            folder = (IMAPFolder)this.getFolder();
            EmailHeader header = null;
            Message[] msgs = null;
            msgs = indexs == null ? folder.getMessages() : folder.getMessages(indexs);
            FetchProfile fp = new FetchProfile();
            fp.add(FetchProfile.Item.ENVELOPE);
            fp.add(FetchProfile.Item.FLAGS);
            fp.add(FetchProfile.Item.CONTENT_INFO);
            fp.add("Size");
            fp.add("Date");
            fp.add("Disposition-Notification-To");
            fp.add("X-Priority");
            fp.add("X-MSMail-Priority");
            fp.add("Sensitivity");
            folder.fetch(msgs, fp);
            Message msg = null;
            for (int i = 0; i < msgs.length; ++i) {
                try {
                    Flags.Flag[] flags;
                    header = new EmailHeader();
                    msg = msgs[i];
                    header.setEmailUID(msg.getMessageNumber());
                    header.setMultipart(msg.isMimeType("multipart/mixed"));
                    header.setNums(msgs[i].getMessageNumber());
                    header.setFrom(msg.getFrom());
                    header.setFolderid(folder.getName().hashCode() * folder.getFullName().hashCode());
                    header.setTo(msg.getRecipients(Message.RecipientType.TO));
                    header.setCc(msg.getRecipients(Message.RecipientType.CC));
                    header.setBcc(msg.getRecipients(Message.RecipientType.BCC));
                    header.setDate(msg.getSentDate());
                    header.setReplyTo(msg.getReplyTo());
                    header.setSize(msg.getSize());
                    header.setSubject(Utility.decodeText(msg.getSubject()));
                    header.setDateString(Utility.getDateToString(header.getDate()));
                    header.setFromString(Utility.updateTRChars(Utility.addressArrToStringShort(header.getFrom())));
                    header.setToString(Utility.addressArrToStringShort(header.getTo()));
                    header.setCcString(Utility.addressArrToStringShort(header.getCc()));
                    header.setSizeString(Utility.sizeToHumanReadable(header.getSize()));
                    boolean deleted = false;
                    if (this.profile.getProtocol().equals("imap") && (flags = msg.getFlags().getSystemFlags()) != null) {
                        Flags.Flag flag = null;
                        for (int m = 0; m < flags.length; ++m) {
                            flag = flags[m];
                            if (flag.equals(Flags.Flag.SEEN)) {
                                header.setUnread(false);
                            }
                            if (!flag.equals(Flags.Flag.DELETED)) continue;
                            deleted = true;
                        }
                    }
                    if (header.getUnread() == null) {
                        header.setUnread(true);
                    }
                    if (deleted) continue;
                    headers.add(header);
                    continue;
                }
                catch (MessagingException e1) {
                    log.error("Could not parse headers of e-mail. Message might be defuncted or illegal formatted.", (Throwable)e1);
                }
            }
        }
        catch (MessagingException e) {
            log.error("Could not fetch message headers. Is mbox connection still alive???", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Could not fetch message headers. Is mbox connection still alive???", (Throwable)e);
        }
        return headers;
    }

    public List<EmailHeader> fetchHeaders(int page, int lines, int sort) throws Exception {
        IMAPFolder folder = (IMAPFolder)this.getFolder();
        int startCount = (page - 1) * lines == 0 ? 1 : (page - 1) * lines + 1;
        int endCount = page * lines;
        if (startCount > folder.getMessageCount() && endCount > folder.getMessageCount()) {
            return new ArrayList<EmailHeader>();
        }
        if (startCount > folder.getMessageCount()) {
            startCount = folder.getMessageCount();
        }
        if (endCount > folder.getMessageCount()) {
            endCount = folder.getMessageCount();
        }
        int[] nums = new int[endCount - startCount + 1];
        if (sort != 1) {
            startCount = folder.getMessageCount() - endCount + 1;
        }
        for (int i = 0; i < nums.length; ++i) {
            nums[i] = sort != 1 ? startCount + nums.length - 1 - i : startCount + i;
        }
        return this.fetchHeaders(nums);
    }

    @Override
    public List<EmailHeader> getHeadersSortList(String sortCriteriaRaw, String sortDirectionRaw) throws Exception {
        return null;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public Email appendMessage(Email email) throws Exception {
        Message message = email.toMessage(null);
        IMAPFolder folder = (IMAPFolder)this.getFolder();
        AppendUID[] uids = folder.appendUIDMessages(new Message[]{message});
        if (uids != null && uids.length > 0) {
            email.setUid(uids[0].uid);
        }
        return email;
    }
}

