/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.runtime.mail;

import cn.myapps.common.util.StringUtil;
import com.teemlink.email.runtime.mail.AuthProfile;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Folder;

public final class FolderCache {
    private static Map<String, Map<String, Folder>> imapFolders = Collections.synchronizedMap(new HashMap());

    private FolderCache() {
    }

    public static void putUserFolderMap(AuthProfile auth, Map<String, Folder> userFolderMap) {
        imapFolders.put(auth.getUserName(), userFolderMap);
    }

    public static Map<String, Folder> getUserFolderMap(AuthProfile auth) {
        Map<String, Folder> result = null;
        if (auth != null && !StringUtil.isBlank((String)auth.getUserName()) && (result = imapFolders.get(auth.getUserName())) == null) {
            result = new HashMap<String, Folder>();
            FolderCache.putUserFolderMap(auth, result);
        }
        return result;
    }

    public static void removeUserFolderMap(AuthProfile auth) {
        if (auth != null && !StringUtil.isBlank((String)auth.getUserName())) {
            imapFolders.remove(auth.getUserName());
        }
    }

    public static void clearCache() {
        imapFolders.clear();
    }
}

