/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.runtime.mail;

import cn.myapps.common.exception.OBPMValidateException;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.pop3.POP3Folder;
import com.sun.mail.pop3.POP3Store;
import com.teemlink.email.util.Constants;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;

public class ConnectionMetaHandler {
    private static final long serialVersionUID = -5420747046218417670L;
    private Folder folder;
    private Store store;
    private Map<Long, Folder> systemFolders = new HashMap<Long, Folder>();
    private Map<Long, Folder> otherFolders = new HashMap<Long, Folder>();

    public Folder getFolder() {
        return this.folder;
    }

    public void setFolder(Folder folder) {
        this.folder = folder;
    }

    public Store getStore() {
        return this.store;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    public void closeFolder(boolean flag) throws MessagingException {
        if (this.folder != null && this.folder.isOpen()) {
            this.folder.close(flag);
        }
    }

    public void closeStore() throws MessagingException {
        if (this.store != null && this.store.isConnected()) {
            this.store.close();
        }
        if (this.systemFolders != null) {
            this.systemFolders.clear();
        }
        if (this.otherFolders != null) {
            this.otherFolders.clear();
        }
    }

    public static void main(String[] args) {
        ConnectionMetaHandler handler = new ConnectionMetaHandler();
        Properties props = new Properties();
        props.setProperty("mail.store.protocol", "pop3");
        props.setProperty("mail.pop3.auth.plain.disable", "true");
        props.setProperty("mail.pop3.host", "pop.exmail.qq.com");
        props.setProperty("mail.pop3.port", "995");
        props.setProperty("mail.debug", "true");
        props.setProperty("mail.pop3.ssl.enable", "true");
        Session session = Session.getDefaultInstance((Properties)props);
        try {
            handler.setStore(session.getStore("pop3"));
            handler.getStore().connect("gary@weioa365.com", "dhTRLBBnTm3gFk8L");
            Folder[] list = handler.getStore().getDefaultFolder().list();
            Folder f = handler.getStore().getFolder("INBOX");
            f.open(2);
            int inbox = f.getMessageCount();
            Message[] messages = f.getMessages();
            System.out.println("1111");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initFolders() throws Exception {
        if (this.store instanceof IMAPStore) {
            IMAPFolder[] imapFolders = (IMAPFolder[])this.store.getDefaultFolder().list();
            for (int i = 0; i < imapFolders.length; ++i) {
                IMAPFolder folder = imapFolders[i];
                String name = folder.getFullName();
                folder.open(1);
                long hashCode = folder.getName().hashCode() * folder.getFullName().hashCode();
                if (Constants.isSystemFolder(name)) {
                    if (this.systemFolders.containsKey(hashCode)) continue;
                    this.systemFolders.put(hashCode, (Folder)folder);
                    continue;
                }
                if (this.otherFolders.containsKey(hashCode)) continue;
                this.otherFolders.put(hashCode, (Folder)folder);
            }
        } else if (this.store instanceof POP3Store) {
            Folder[] pop3Folders = this.store.getDefaultFolder().list();
            for (int i = 0; i < pop3Folders.length; ++i) {
                POP3Folder folder = (POP3Folder)pop3Folders[i];
                String name = folder.getFullName();
                folder.open(1);
                long hashCode = folder.getName().hashCode() * folder.getFullName().hashCode();
                if (Constants.isSystemFolder(name)) {
                    if (this.systemFolders.containsKey(hashCode)) continue;
                    this.systemFolders.put(hashCode, (Folder)folder);
                    continue;
                }
                if (this.otherFolders.containsKey(hashCode)) continue;
                this.otherFolders.put(hashCode, (Folder)folder);
            }
        } else {
            throw new OBPMValidateException("\u65e0\u6cd5\u67e5\u627e\u76f8\u5e94\u90ae\u4ef6\u63a5\u6536\u534f\u8bae");
        }
    }

    public Folder getFolderByUID(long uid) {
        Folder folder = this.systemFolders.get(uid);
        if (folder == null) {
            folder = this.otherFolders.get(uid);
        }
        return folder;
    }

    public void removeFolder(long key) {
        this.otherFolders.remove(key);
    }

    public Map<Long, Folder> getSystemFolders() throws Exception {
        return this.systemFolders;
    }

    public Map<Long, Folder> getOtherFolders() throws Exception {
        return this.otherFolders;
    }

    public void removeOtherFolder() {
        if (this.folder instanceof IMAPFolder) {
            try {
                this.otherFolders.remove(((IMAPFolder)this.folder).getUIDValidity());
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
    }

    public Folder getFolderByName(String name, String ownerid) {
        Map<Long, Folder> folders = null;
        folders = "0000-0000-00000000-0000-000000000000".equals(ownerid) ? this.systemFolders : this.otherFolders;
        if (folders != null) {
            Set<Map.Entry<Long, Folder>> entrys = folders.entrySet();
            for (Map.Entry<Long, Folder> entry : entrys) {
                Folder folder = entry.getValue();
                if (!folder.getFullName().equals(name)) continue;
                return folder;
            }
        }
        return null;
    }
}

