/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.folder.service;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.StringUtil;
import com.sun.mail.pop3.POP3Folder;
import com.teemlink.email.email.base.EmailValueObject;
import com.teemlink.email.email.dao.IEamilDAO;
import com.teemlink.email.email.model.EmailUser;
import com.teemlink.email.email.service.AbstractEmailServiceImpl;
import com.teemlink.email.folder.model.EmailFolder;
import com.teemlink.email.folder.service.EmailFolderProcess;
import com.teemlink.email.runtime.mail.Pop3ProtocolImpl;
import com.teemlink.email.runtime.mail.ProtocolFactory;
import com.teemlink.email.util.Constants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.mail.Folder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailFolderProcessPop3Bean
extends AbstractEmailServiceImpl<EmailFolder>
implements EmailFolderProcess {
    private static final long serialVersionUID = 6319523364694651021L;
    private transient ProtocolFactory protocolFactory;
    private static final Logger LOG = LoggerFactory.getLogger(EmailFolderProcessPop3Bean.class);

    public EmailFolderProcessPop3Bean() {
    }

    public EmailFolderProcessPop3Bean(ProtocolFactory protocolFactory) throws Exception {
        this.protocolFactory = protocolFactory;
    }

    protected IEamilDAO<EmailFolder> getDAO() throws Exception {
        return null;
    }

    @Override
    public void doCreateEmailFolderByName(String folderName, String ownerId) throws Exception {
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl)this.protocolFactory.getProtocol(folderName);
        protocol.connect(1);
        protocol.createFolder();
        protocol.updateFolders();
    }

    private boolean createEmailFolderByName(Pop3ProtocolImpl protocol) throws Exception {
        if (this.getSystemEmailFolderByName(protocol.getFolderName()) == null) {
            protocol.connect(1);
            protocol.createFolder();
            Thread.sleep(1000L);
            return true;
        }
        return false;
    }

    @Override
    public EmailFolder getEmailFolderById(String folderid) throws Exception {
        try {
            POP3Folder folder = (POP3Folder)this.protocolFactory.getConnectionMetaHandler().getFolderByUID(Long.parseLong(folderid));
            if (folder != null) {
                return EmailFolder.valueOf((Folder)folder);
            }
        }
        catch (NumberFormatException e) {
            LOG.warn("{}", (Object)e.toString());
        }
        return null;
    }

    @Override
    public EmailFolder getEmailFolderByOwnerId(String folderName, String ownerId) throws Exception {
        Map<Long, Folder> folders = null;
        folders = "0000-0000-00000000-0000-000000000000".equals(ownerId) ? this.protocolFactory.getConnectionMetaHandler().getSystemFolders() : this.protocolFactory.getConnectionMetaHandler().getOtherFolders();
        if (folders != null) {
            Set<Map.Entry<Long, Folder>> entrys = folders.entrySet();
            for (Map.Entry<Long, Folder> entry : entrys) {
                POP3Folder folder = (POP3Folder)entry.getValue();
                if (!folder.getFullName().equals(folderName)) continue;
                return EmailFolder.valueOf((Folder)folder);
            }
        }
        return null;
    }

    @Override
    public DataPackage<EmailFolder> getPersonalEmailFolders(EmailUser user, int page, int lines) throws Exception {
        Map<Long, Folder> personalFolders = this.protocolFactory.getConnectionMetaHandler().getOtherFolders();
        ArrayList<EmailFolder> result = new ArrayList<EmailFolder>();
        Set<Map.Entry<Long, Folder>> entrys = personalFolders.entrySet();
        for (Map.Entry<Long, Folder> entry : entrys) {
            POP3Folder folder = (POP3Folder)entry.getValue();
            EmailFolder ef = EmailFolder.valueOf((Folder)folder);
            if (ef == null) continue;
            result.add(ef);
        }
        DataPackage dp = new DataPackage();
        dp.datas = result;
        dp.setPageNo(1);
        dp.setLinesPerPage(Integer.MAX_VALUE);
        dp.setRowCount(result.size());
        return dp;
    }

    @Override
    public Collection<EmailFolder> getSystemEmailFolders() throws Exception {
        Map<Long, Folder> systemFolders = this.protocolFactory.getConnectionMetaHandler().getSystemFolders();
        ArrayList<EmailFolder> result = new ArrayList<EmailFolder>();
        Set<Map.Entry<Long, Folder>> entrys = systemFolders.entrySet();
        for (Map.Entry<Long, Folder> entry : entrys) {
            POP3Folder folder = (POP3Folder)entry.getValue();
            EmailFolder ef = EmailFolder.valueOf((Folder)folder);
            if (ef == null) continue;
            result.add(ef);
        }
        return result;
    }

    @Override
    public void initCreatDefaultMailFolder() throws Exception {
        Pop3ProtocolImpl protocol = null;
        boolean isUpdate = false;
        protocol = (Pop3ProtocolImpl)this.protocolFactory.getProtocol(Constants.DEFAULT_FOLDER_DRAFTS);
        isUpdate = this.createEmailFolderByName(protocol);
        protocol = (Pop3ProtocolImpl)this.protocolFactory.getProtocol(Constants.DEFAULT_FOLDER_JUNK);
        if (!isUpdate) {
            isUpdate = this.createEmailFolderByName(protocol);
        } else {
            this.createEmailFolderByName(protocol);
        }
        protocol = (Pop3ProtocolImpl)this.protocolFactory.getProtocol(Constants.DEFAULT_FOLDER_SENT);
        if (!isUpdate) {
            isUpdate = this.createEmailFolderByName(protocol);
        } else {
            this.createEmailFolderByName(protocol);
        }
        protocol = (Pop3ProtocolImpl)this.protocolFactory.getProtocol(Constants.DEFAULT_FOLDER_REMOVED);
        if (!isUpdate) {
            isUpdate = this.createEmailFolderByName(protocol);
        } else {
            this.createEmailFolderByName(protocol);
        }
        if (protocol != null && isUpdate) {
            protocol.updateFolders();
        }
    }

    @Override
    public boolean emailFolderIsCreate(String folderName, String ownerid) throws Exception {
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl)this.protocolFactory.getProtocol(folderName);
        protocol.connect(1);
        Folder folder = protocol.getFolder();
        return folder != null && folder.exists();
    }

    public static void main(String[] args) throws Exception {
    }

    @Override
    public EmailFolder getSystemEmailFolderByName(String folderName) throws Exception {
        return this.getEmailFolderByOwnerId(folderName, "0000-0000-00000000-0000-000000000000");
    }

    @Override
    public void doCreate(EmailValueObject vo) throws Exception {
        EmailFolder folder = (EmailFolder)vo;
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl)this.protocolFactory.getProtocol(folder.getName());
        protocol.connect(1);
        protocol.createFolder();
        protocol.updateFolders();
    }

    @Override
    public void doUpdate(EmailValueObject vo) throws Exception {
        EmailFolder folder = (EmailFolder)vo;
        if (StringUtil.isBlank((String)folder.getId())) {
            throw new OBPMValidateException("{*[core.email.folder.create.error]*}");
        }
        POP3Folder oldFolder = (POP3Folder)this.protocolFactory.getConnectionMetaHandler().getFolderByUID(Long.valueOf(folder.getId()));
        if (oldFolder == null) {
            throw new OBPMValidateException("{*[core.email.folder.create.error]*}");
        }
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl)this.protocolFactory.getProtocol(oldFolder.getName());
        protocol.connect(1);
        protocol.renameTo(folder.getName());
        protocol.updateFolders();
    }

    @Override
    public void doRemoveEmailFolder(EmailFolder folder, EmailUser user) throws Exception {
        if (StringUtil.isBlank((String)folder.getId())) {
            throw new OBPMValidateException("{*[core.email.folder.delete.error]*}");
        }
        POP3Folder oldFolder = (POP3Folder)this.protocolFactory.getConnectionMetaHandler().getFolderByUID(Long.valueOf(folder.getId()));
        if (oldFolder == null) {
            throw new OBPMValidateException("{*[core.email.folder.delete.error]*}");
        }
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl)this.protocolFactory.getProtocol(oldFolder.getName());
        protocol.connect(1);
        if (protocol.getTotalMessageCount() > 0) {
            throw new OBPMValidateException("{*[core.email.folder.deleted]*}");
        }
        protocol.deleteFolder(true);
    }

    @Override
    public int getPersonalEmailFolderCount(String ownerid) throws Exception {
        Map<Long, Folder> folders = this.protocolFactory.getConnectionMetaHandler().getOtherFolders();
        if (folders != null) {
            return folders.size();
        }
        return 0;
    }
}

