/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.folder.model;

import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.pop3.POP3Folder;
import com.teemlink.email.email.base.EmailValueObject;
import com.teemlink.email.util.Constants;
import java.util.Date;
import javax.mail.Folder;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="T_EMAIL_FOLDER")
public class EmailFolder
extends EmailValueObject {
    private static final long serialVersionUID = -7026205939786472851L;
    @Id
    @Column(name="ID")
    private String id;
    @Column(name="OWNERID")
    private String ownerId;
    @Column(name="NAME")
    private String name;
    @Column(name="DISPLAYNAME")
    private String displayName;
    @Column(name="CREATDATE")
    private Date createDate;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String toString() {
        return "[id=" + this.id + ", name=" + this.name + "]";
    }

    public static EmailFolder valueOf(Folder folder) {
        EmailFolder emailFolder = null;
        if (folder != null) {
            try {
                if (folder instanceof IMAPFolder) {
                    IMAPFolder _folder = (IMAPFolder)folder;
                    emailFolder = new EmailFolder();
                    emailFolder.setId(String.valueOf(_folder.getName().hashCode() * _folder.getFullName().hashCode()));
                    emailFolder.setName(_folder.getFullName());
                    emailFolder.setDisplayName(Constants.getFolderDisplay(emailFolder.getName()));
                } else if (folder instanceof POP3Folder) {
                    POP3Folder _folder = (POP3Folder)folder;
                    emailFolder = new EmailFolder();
                    long hashCode = _folder.getName().hashCode() * _folder.getFullName().hashCode();
                    emailFolder.setId(String.valueOf(hashCode));
                    emailFolder.setName(folder.getFullName());
                    emailFolder.setDisplayName(Constants.getFolderDisplay(emailFolder.getName()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return emailFolder;
    }
}

