/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.folder.action;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.email.model.WebUser;
import com.teemlink.email.folder.model.EmailFolder;
import com.teemlink.email.folder.service.EmailFolderProcess;
import com.teemlink.email.util.Constants;
import com.teemlink.email.util.EmailProcessUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailFolderHelper {
    private static final Logger LOG = LoggerFactory.getLogger(EmailFolderHelper.class);

    public static String getFolderId(String folderName, String ownerid, WebUser webUser) {
        try {
            EmailFolderProcess process = (EmailFolderProcess)EmailProcessUtil.createProcess(EmailFolderProcess.class, webUser);
            EmailFolder folder = process.getEmailFolderByOwnerId(folderName, ownerid);
            if (folder != null) {
                return folder.getId();
            }
        }
        catch (Exception e) {
            LOG.warn("{}", (Object)e.toString());
        }
        return "";
    }

    public static EmailFolder getSystemFolderByName(String folderName, WebUser webUser) {
        try {
            EmailFolderProcess process = (EmailFolderProcess)EmailProcessUtil.createProcess(EmailFolderProcess.class, webUser);
            EmailFolder folder = process.getEmailFolderByOwnerId(folderName, "0000-0000-00000000-0000-000000000000");
            return folder;
        }
        catch (Exception e) {
            LOG.warn("{}", (Object)e.toString());
            return null;
        }
    }

    public static Collection<EmailFolder> getSystemFolders(WebUser webUser) {
        ArrayList systemFolders = null;
        try {
            EmailFolderProcess process = (EmailFolderProcess)EmailProcessUtil.createProcess(EmailFolderProcess.class, webUser);
            systemFolders = process.getSystemEmailFolders();
        }
        catch (Exception e) {
            LOG.warn("{}", (Object)e.toString());
        }
        return systemFolders == null ? new ArrayList() : systemFolders;
    }

    public static Collection<EmailFolder> getPersonalEmailFolders(WebUser webUser) {
        try {
            EmailFolderProcess process = (EmailFolderProcess)EmailProcessUtil.createProcess(EmailFolderProcess.class, webUser);
            ParamsTable params = new ParamsTable();
            DataPackage<EmailFolder> dp = process.getPersonalEmailFolders(webUser.getEmailUser(), 1, Integer.MAX_VALUE);
            if (dp != null) {
                return dp.datas;
            }
        }
        catch (Exception e) {
            LOG.warn("{}", (Object)e.toString());
        }
        return null;
    }

    public static boolean havePersonalEmailFolder(WebUser webUser) {
        try {
            EmailFolderProcess process = (EmailFolderProcess)EmailProcessUtil.createProcess(EmailFolderProcess.class, webUser);
            int count = process.getPersonalEmailFolderCount(webUser.getEmailUser().getId());
            if (count > 0) {
                return true;
            }
        }
        catch (Exception e) {
            LOG.warn("{}", (Object)e.getMessage());
        }
        return false;
    }

    public static String getInboxEmailFolderId(WebUser webUser) {
        EmailFolder folder = EmailFolderHelper.getSystemFolderByName("INBOX", webUser);
        if (folder != null) {
            return folder.getId();
        }
        return "";
    }

    public static String getDraftsEmailFolderId(WebUser webUser) {
        EmailFolder folder = EmailFolderHelper.getSystemFolderByName(Constants.DEFAULT_FOLDER_DRAFTS, webUser);
        if (folder != null) {
            return folder.getId();
        }
        return "";
    }

    public static String getSentEmailFolderId(WebUser webUser) {
        EmailFolder folder = EmailFolderHelper.getSystemFolderByName(Constants.DEFAULT_FOLDER_SENT, webUser);
        if (folder != null) {
            return folder.getId();
        }
        return "";
    }

    public static String getRemovedEmailFolderId(WebUser webUser) {
        EmailFolder folder = EmailFolderHelper.getSystemFolderByName(Constants.DEFAULT_FOLDER_REMOVED, webUser);
        if (folder != null) {
            return folder.getId();
        }
        return "";
    }

    public static String getJunkEmailFolderId(WebUser webUser) {
        EmailFolder folder = EmailFolderHelper.getSystemFolderByName(Constants.DEFAULT_FOLDER_JUNK, webUser);
        if (folder != null) {
            return folder.getId();
        }
        return "";
    }

    public static Collection<EmailFolder> getMoveSystemFolders(WebUser webUser) {
        ArrayList<EmailFolder> result = new ArrayList<EmailFolder>();
        Collection<EmailFolder> systemFolders = EmailFolderHelper.getSystemFolders(webUser);
        for (EmailFolder folder : systemFolders) {
            if (!"INBOX".equals(folder.getName()) && !Constants.DEFAULT_FOLDER_SENT.equals(folder.getName()) && !Constants.DEFAULT_FOLDER_REMOVED.equals(folder.getName())) continue;
            result.add(folder);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection<EmailFolder> getRemovableFolders(String folderid, String ownerid, WebUser webUser) {
        ArrayList<EmailFolder> result = new ArrayList<EmailFolder>();
        try {
            String folderName;
            EmailFolderProcess process = (EmailFolderProcess)EmailProcessUtil.createProcess(EmailFolderProcess.class, webUser);
            EmailFolder folder = process.getEmailFolderById(folderid);
            if (folder != null && !"INBOX".equals(folderName = folder.getName()) && !Constants.DEFAULT_FOLDER_DRAFTS.equals(folderName) && !Constants.DEFAULT_FOLDER_SENT.equals(folderName) && !Constants.DEFAULT_FOLDER_REMOVED.equals(folderName) && !Constants.DEFAULT_FOLDER_JUNK.equals(folderName)) return result;
        }
        catch (Exception e) {
            LOG.warn("{}", (Throwable)e);
        }
        return result;
    }

    public static EmailFolder createEmptyEmailFolder() {
        EmailFolder folder = new EmailFolder();
        folder.setId("");
        folder.setName("");
        return folder;
    }

    public static String toPersonalFolderHtml(WebUser webUser) {
        StringBuffer html = new StringBuffer();
        Collection<EmailFolder> list = EmailFolderHelper.getPersonalEmailFolders(webUser);
        if (list != null && !list.isEmpty()) {
            for (EmailFolder folder : list) {
                html.append("<li id=\"").append(folder.getId()).append("\">");
                html.append(folder.getDisplayName()).append("</li>").append("\n");
            }
        }
        return html.toString();
    }
}

