/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.email.service;

import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.SequenceGenerator;
import cn.myapps.common.util.StringUtil;
import com.teemlink.email.email.base.EmailValueObject;
import com.teemlink.email.email.dao.EmailUserRepository;
import com.teemlink.email.email.model.EmailUser;
import com.teemlink.email.email.service.AbstractEmailServiceImpl;
import com.teemlink.email.email.service.EmailUserProcess;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;

public class EmailUserProcessBean
extends AbstractEmailServiceImpl<EmailUser>
implements EmailUserProcess {
    private static final long serialVersionUID = -8921925024606594233L;
    @Autowired
    private EmailUserRepository emailUserRepository;

    @Override
    public EmailUser getEmailUser(String account, String domainid) throws Exception {
        EmailUser user = this.emailUserRepository.findByAccountAndDomainid(account, domainid);
        return user;
    }

    @Override
    public EmailUser getEmailUserByAccount(String account) throws Exception {
        return this.emailUserRepository.findByAccount(account);
    }

    @Override
    public EmailUser getEmailUserByOwner(String ownerid, String domainid) throws Exception {
        EmailUser user = this.emailUserRepository.findByOwneridAndDomainid(ownerid, domainid);
        if (user != null && user.getPassword() != null && user.getPassword().trim().length() > 0) {
            user.setPassword(Security.decodeBASE64((String)user.getPassword()));
        }
        return user;
    }

    @Override
    public void doCreateEmailUser(EmailUser user) throws Exception {
        this.validateAccount(user);
        if (user != null && user.getPassword() != null && user.getPassword().trim().length() > 0) {
            user.setPassword(Security.encodeToBASE64((String)user.getPassword()));
        }
        super.doCreate(user);
    }

    @Override
    public void doCreate(EmailValueObject vo) throws Exception {
        EmailUser user = (EmailUser)vo;
        EmailUser emailUser = this.validateAccount(user);
        if (emailUser != null && user.getOwnerid().equals(emailUser.getOwnerid()) && user.getAccount().equals(emailUser.getAccount()) && user.getDomainid().equals(emailUser.getDomainid())) {
            return;
        }
        if (user == null || user.getPassword() == null || user.getPassword().trim().length() > 0) {
            // empty if block
        }
        user.setCreateDate(new Date());
        if (StringUtil.isBlank((String)user.getId())) {
            user.setId(SequenceGenerator.getUUID());
        }
        this.emailUserRepository.save(user);
    }

    @Override
    public void doRemoveEmailUser(String id) throws Exception {
        super.doRemove(id);
    }

    @Override
    public void doUpdateEmailUser(EmailUser user) throws Exception {
        this.validateAccount(user);
        if (user != null && user.getPassword() != null && user.getPassword().trim().length() > 0) {
            user.setPassword(Security.encodeToBASE64((String)user.getPassword()));
        }
        super.doUpdate(user);
    }

    @Override
    public void doUpdate(EmailValueObject vo) throws Exception {
        EmailUser user = (EmailUser)vo;
        try {
            this.validateAccount(user);
            EmailUser po = this.emailUserRepository.findEmailUserById(vo.getId());
            if (po != null) {
                if (user.getPassword() == null || user.getPassword().trim().length() > 0) {
                    // empty if block
                }
                po.setAccount(user.getAccount());
                po.setDefaultDepartment(user.getDefaultDepartment());
                this.emailUserRepository.save(po);
            } else {
                if (user != null && user.getPassword() != null && user.getPassword().trim().length() > 0) {
                    user.setPassword(Security.encodeToBASE64((String)user.getPassword()));
                }
                this.emailUserRepository.save(user);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public EmailUser validateAccount(EmailUser emailUser) throws Exception {
        if (StringUtil.isBlank((String)emailUser.getAccount())) {
            return emailUser;
        }
        EmailUser user = this.getEmailUser(emailUser.getAccount(), emailUser.getDomainid());
        if (user != null && !user.getOwnerid().equals(emailUser.getOwnerid())) {
            throw new OBPMValidateException(user.getAccount() + "{*[core.email.account.create.error]*} [" + user.getName() + "] {*[core.email.account.change]*}!");
        }
        return user;
    }
}

