/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.email.service;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.common.util.StringUtil;
import cn.myapps.conf.UserAPI;
import com.sun.mail.pop3.POP3Folder;
import com.teemlink.email.attachment.model.Attachment;
import com.teemlink.email.attachment.service.AttachmentProcessBean;
import com.teemlink.email.email.base.EmailValueObject;
import com.teemlink.email.email.dao.IEamilDAO;
import com.teemlink.email.email.model.Email;
import com.teemlink.email.email.model.EmailUser;
import com.teemlink.email.email.service.AbstractEmailServiceImpl;
import com.teemlink.email.email.service.EmailProcess;
import com.teemlink.email.folder.model.EmailFolder;
import com.teemlink.email.runtime.mail.Pop3ProtocolImpl;
import com.teemlink.email.runtime.mail.ProtocolFactory;
import com.teemlink.email.runtime.mail.Smtp;
import com.teemlink.email.runtime.model.EmailHeader;
import com.teemlink.email.runtime.model.EmailPart;
import com.teemlink.email.runtime.parser.MessageParser;
import com.teemlink.email.util.Constants;
import com.teemlink.email.util.EmailProcessUtil;
import com.teemlink.email.util.JacksonUtil;
import com.teemlink.email.util.Utility;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Folder;
import javax.mail.Message;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EmailProcessPop3Bean
extends AbstractEmailServiceImpl<Email>
implements EmailProcess {
    private static final long serialVersionUID = 4569714249064788780L;
    private transient ProtocolFactory protocolFactory;
    private static final Logger log = LoggerFactory.getLogger(EmailProcessPop3Bean.class);
    private final String cacheFolder = "EmailCache";
    private static ExecutorService cachedThreadPool = Executors.newCachedThreadPool();

    public EmailProcessPop3Bean(ProtocolFactory protocolFactory) throws Exception {
        this.protocolFactory = protocolFactory;
    }

    protected IEamilDAO<Email> getDAO() throws Exception {
        return null;
    }

    @Override
    public void doMoveTo(String[] ids, EmailFolder folder) throws Exception {
        throw new OBPMValidateException("{*[core.email.internal.error]*}");
    }

    @Override
    public void doMoveTo(String[] ids, EmailFolder folder, EmailFolder toFolder) throws Exception {
        String folderName = this.getFolderNameByEmailFolder(folder);
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl)this.protocolFactory.getProtocol(folderName);
        protocol.connect(2);
        protocol.moveMessagesByUID(this.parseLongs(ids), this.getFolderNameByEmailFolder(toFolder));
        protocol.disconnect();
    }

    @Override
    public void doMoveToOtherFolder(Email email, String otherFolderid) throws Exception {
        String folderName = this.getFolderNameByEmailFolder(email.getEmailFolder());
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl)this.protocolFactory.getProtocol(folderName);
        protocol.connect(2);
        Folder folder = this.protocolFactory.getConnectionMetaHandler().getFolderByUID(this.parseLong(otherFolderid));
        protocol.moveMessageByUID(this.parseLong(email.getId()), folder.getFullName());
        protocol.disconnect();
    }

    @Override
    public void doToRecy(String[] ids) throws Exception {
        throw new OBPMValidateException("{*[core.email.internal.error]*}");
    }

    @Override
    public void doToRecy(String[] ids, String folderid) throws Exception {
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl)this.protocolFactory.getProtocol(this.getFolderNameById(folderid));
        protocol.connect(2);
        protocol.moveMessagesByUID(this.parseLongs(ids), Constants.DEFAULT_FOLDER_REMOVED);
        protocol.disconnect();
    }

    @Override
    public void doUpdateMarkRead(String[] ids, boolean flag) throws Exception {
        throw new OBPMValidateException("{*[core.email.internal.error]*}");
    }

    @Override
    public void doUpdateRead(String messageId) throws Exception {
        throw new OBPMValidateException("{*[core.email.internal.error]*}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEmailsAsCache(String folderId, List<Email> emails, String userid) throws Exception {
        String uri = PropertyUtil.getPath() + "/" + "EmailCache" + "/" + userid;
        File folder = new File(uri);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File file = new File(folder.getAbsolutePath() + File.separator + folderId + "_email_list.json");
        try (FileOutputStream out = new FileOutputStream(file);){
            if (file.exists()) {
                Collections.reverse(emails);
                JacksonUtil.save(emails, file);
            } else {
                file.createNewFile();
                out.write("[]".getBytes());
                Collections.reverse(emails);
                JacksonUtil.save(emails, file);
            }
        }
    }

    private List<Email> getCacheEamils(String folderId, String userid, String unread, String smsForm, String smsSubject, String startDate, String endDate) throws Exception {
        String uri = PropertyUtil.getPath() + "/" + "EmailCache" + "/" + userid;
        File folder = new File(uri);
        File file = new File(folder.getAbsolutePath() + File.separator + folderId + "_email_list.json");
        if (file.exists()) {
            List list = JacksonUtil.get(file, List.class, Email.class);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Email email = (Email)iterator.next();
                if (!StringUtil.isBlank((String)smsForm) && !email.getEmailBody().getFrom().contains(smsForm)) {
                    iterator.remove();
                    continue;
                }
                if (!StringUtil.isBlank((String)smsSubject) && !email.getEmailBody().getSubject().contains(smsSubject)) {
                    iterator.remove();
                }
                if (StringUtil.isBlank((String)unread) || email.isRead() == Boolean.valueOf(unread).booleanValue()) continue;
                iterator.remove();
            }
            return list;
        }
        file.createNewFile();
        FileOutputStream out = new FileOutputStream(file);
        out.write("[]".getBytes());
        out.close();
        return new ArrayList<Email>();
    }

    private DataPackage<Email> getResultDataPackage(int rows, int page, int lines, List<Email> resultList) {
        DataPackage dataPackage = new DataPackage();
        dataPackage.setRowCount(resultList.size());
        dataPackage.setPageNo(page);
        dataPackage.setLinesPerPage(lines);
        try {
            dataPackage.setDatas(resultList.subList((page - 1) * lines, dataPackage.rowCount > page * lines ? page * lines : dataPackage.rowCount));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataPackage;
    }

    @Override
    public DataPackage<Email> getEmailsByFolderId(String folderid, String unread, String userid, String departmentId, String sm_subject, String sm_from, String sm_to, String startdate, String enddate, String isAjax, int page, int lines) throws Exception {
        List<Object> list;
        List<Object> cacheEmails = new ArrayList();
        if (isAjax.equals("true")) {
            cacheEmails = this.getCacheEamils(folderid, userid, unread, sm_from, sm_subject, startdate, enddate);
            return this.getResultDataPackage(cacheEmails.size(), page, lines, cacheEmails);
        }
        String folderName = this.getFolderNameById(folderid);
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl)this.protocolFactory.getProtocol(folderName);
        protocol.connect(2);
        DataPackage dataPackage = new DataPackage();
        List<EmailHeader> result = protocol.fetchHeaders(page, lines, 0);
        dataPackage.rowCount = protocol.getTotalMessageCount();
        dataPackage.pageNo = page;
        dataPackage.linesPerPage = lines;
        ArrayList<Email> temp = new ArrayList<Email>();
        if (result != null) {
            for (EmailHeader eh : result) {
                Email email = Email.valueOf(eh);
                if (email == null) continue;
                temp.add(email);
            }
        }
        if (EmailProcessUtil.userFolderMap.get(userid) == null) {
            list = new ArrayList<String>();
            list.add(folderid);
            EmailProcessUtil.userFolderMap.put(userid, list);
            this.getFolderAllEmails(folderid, userid);
        } else {
            list = EmailProcessUtil.userFolderMap.get(userid);
            if (!list.contains(folderid)) {
                this.getFolderAllEmails(folderid, userid);
            }
        }
        dataPackage.datas = temp;
        return dataPackage;
    }

    public void getFolderAllEmails(final String folderid, final String userid) {
        cachedThreadPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<Email> allCacheEmails = new ArrayList<Email>();
                Iterator<EmailHeader> iterator = null;
                String folderName = EmailProcessPop3Bean.this.getFolderNameById(folderid);
                Pop3ProtocolImpl protocol2 = (Pop3ProtocolImpl)EmailProcessPop3Bean.this.protocolFactory.getProtocol(folderName);
                try {
                    protocol2.connect(2);
                    for (EmailHeader eh : protocol2.fetchAllHeaders()) {
                        Email email = Email.valueOf(eh);
                        if (email == null) continue;
                        allCacheEmails.add(email);
                    }
                    EmailProcessPop3Bean.this.saveEmailsAsCache(folderid, allCacheEmails, userid);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        protocol2.disconnect();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    @Override
    public DataPackage<Email> getEmailsByFolderUser(String folderid, String unread, String userid, String departmentId, String sm_subject, String sm_from, String sm_to, String startdate, String enddate, String isAjax, int page, int lines) throws Exception {
        return this.getEmailsByFolderId(folderid, unread, userid, departmentId, sm_subject, sm_from, sm_to, startdate, enddate, isAjax, page, lines);
    }

    @Override
    public int getEmailCount(EmailFolder folder, EmailUser user) throws Exception {
        String folderName = this.getFolderNameByEmailFolder(folder);
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl)this.protocolFactory.getProtocol(folderName);
        protocol.connect(2);
        return protocol.getTotalMessageCount();
    }

    @Override
    public int getUnreadMessageCount(String folderid, EmailUser user) throws Exception {
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl)this.protocolFactory.getProtocol(this.getFolderNameById(folderid));
        protocol.connect(2);
        return protocol.getUnreadMessageCount();
    }

    @Override
    public boolean sendEmail(Email email, EmailUser user) throws Exception {
        return this.sendEmail(email, user, false);
    }

    @Override
    public boolean sendEmail(Email email, EmailUser user, boolean self) throws Exception {
        try {
            if (self) {
                POP3Folder pop3Folder = (POP3Folder)this.protocolFactory.getConnectionMetaHandler().getFolderByName(Constants.DEFAULT_FOLDER_SENT, "0000-0000-00000000-0000-000000000000");
                EmailFolder folder = EmailFolder.valueOf((Folder)pop3Folder);
                this.doSaveEmail(email, folder);
            }
            String dId = user.getDomainid();
            UserAPI userAPI = (UserAPI)SpringApplicationContextUtil.getBean(UserAPI.class);
            JSONObject domain = userAPI.getDomainById(dId);
            Smtp smtp = new Smtp(this.protocolFactory.getProfile(), this.protocolFactory.getAuth(), domain.getString("functionDomain"));
            smtp.sendEmail(this.valueOf(email), false, domain.getString("functionDomain"));
            this.deleteAttachment(email);
            if (!StringUtil.isBlank((String)email.getId())) {
                Pop3ProtocolImpl protocol = (Pop3ProtocolImpl)this.protocolFactory.getProtocol(Constants.DEFAULT_FOLDER_DRAFTS);
                protocol.connect(2);
                protocol.deletedMessageByUID(new long[]{Long.parseLong(email.getId())});
            }
            return true;
        }
        catch (Exception e) {
            log.warn("{}", (Throwable)e);
            throw e;
        }
    }

    public com.teemlink.email.runtime.model.Email valueOf(Email email) throws Exception {
        com.teemlink.email.runtime.model.Email result = new com.teemlink.email.runtime.model.Email();
        result.getBaseHeader().setBcc(Utility.stringToAddressArray(email.getEmailBody().getBcc()));
        result.getBaseHeader().setCc(Utility.stringToAddressArray(email.getEmailBody().getCc()));
        result.getBaseHeader().setFrom(Utility.stringToAddressArray(email.getEmailBody().getFrom()));
        result.getBaseHeader().setSubject(email.getEmailBody().getSubject());
        result.getBaseHeader().setTo(Utility.stringToAddressArray(email.getEmailBody().getTo()));
        EmailPart contentPart = new EmailPart();
        contentPart.setContent(email.getEmailBody().getContent(), "text/html;charset=utf-8");
        result.getParts().add(0, contentPart);
        if (email.getEmailBody().isMultipart()) {
            Set<Attachment> attachments = email.getEmailBody().getAttachments();
            for (Attachment attachment : attachments) {
                EmailPart bodyPart = new EmailPart();
                String filename = attachment.getRealFileName();
                FileDataSource dataSource = new FileDataSource(attachment.getFileAllPath());
                bodyPart.setDataSource((DataSource)dataSource);
                bodyPart.setFileName(filename);
                result.addPart(bodyPart);
            }
        }
        return result;
    }

    public String getFolderNameById(String id) {
        Folder folder = this.protocolFactory.getConnectionMetaHandler().getFolderByUID(this.parseLong(id));
        if (folder == null) {
            return "";
        }
        return folder.getFullName();
    }

    public String getFolderNameByEmailFolder(EmailFolder folder) {
        String folderName = folder.getName();
        if (StringUtil.isBlank((String)folderName)) {
            folderName = this.getFolderNameById(folder.getId());
        }
        return folderName;
    }

    private long parseLong(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private long[] parseLongs(String[] strs) {
        if (strs == null) {
            return new long[0];
        }
        long[] result = new long[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            result[i] = this.parseLong(strs[i]);
        }
        return result;
    }

    @Override
    public void doUpdateMarkRead(String[] ids, boolean read, EmailFolder folder) throws Exception {
        String folderName = this.getFolderNameByEmailFolder(folder);
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl)this.protocolFactory.getProtocol(folderName);
        protocol.connect(2);
        for (int i = 0; i < ids.length; ++i) {
            protocol.markAsReadByUID(this.parseLong(ids[i]), read);
        }
    }

    @Override
    public void doUpdateRead(String emailid, EmailFolder folder) throws Exception {
        String folderName = this.getFolderNameByEmailFolder(folder);
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl)this.protocolFactory.getProtocol(folderName);
        protocol.connect(2);
        protocol.markAsReadByUID(this.parseLong(emailid));
    }

    @Override
    public EmailValueObject doView(String pk) throws Exception {
        throw new OBPMValidateException("{*[core.email.internal.error]*}");
    }

    private Email getCacheEmail(String id, String name) throws Exception {
        String uri = PropertyUtil.getPath() + "/" + "EmailCache";
        File folder = new File(uri);
        File file = new File(folder.getAbsolutePath() + File.separator + id + "_" + name + "_email.json");
        if (file.exists()) {
            List emails = JacksonUtil.get(file, List.class, Email.class);
            if (emails == null || emails.isEmpty()) {
                return null;
            }
            return (Email)emails.get(0);
        }
        return null;
    }

    private void saveEmailAsCache(String id, String name, Email email) throws Exception, URISyntaxException {
        String uri = PropertyUtil.getPath() + "/" + "EmailCache";
        File folder = new File(uri);
        File file = new File(folder.getAbsolutePath() + File.separator + id + "_" + name + "_email.json");
        if (file.exists()) {
            ArrayList<Email> emails = new ArrayList<Email>();
            emails.add(email);
            JacksonUtil.save(emails, file);
        } else {
            file.createNewFile();
            FileOutputStream out = new FileOutputStream(file);
            out.write("[]".getBytes());
            out.close();
            ArrayList<Email> emails = new ArrayList<Email>();
            emails.add(email);
            JacksonUtil.save(emails, file);
        }
    }

    @Override
    public Email getEmailByID(String id, EmailFolder folder) throws Exception {
        Email cacheEmail = this.getCacheEmail(id, folder.getId());
        if (cacheEmail != null) {
            return cacheEmail;
        }
        String folderName = this.getFolderNameByEmailFolder(folder);
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl)this.protocolFactory.getProtocol(folderName);
        protocol.connect(2);
        Message message = protocol.getMessageByUID(this.parseLong(id));
        if (message != null) {
            Email email = Email.valueOf(MessageParser.parseMessage(message));
            if (email != null) {
                email.setId(id);
                email.getEmailFolder().setId(folder.getId());
                email.getEmailFolder().setName(folderName);
            }
            this.saveEmailAsCache(id, folder.getId(), email);
            return email;
        }
        protocol.disconnect();
        return null;
    }

    @Override
    public void doRemoveByFolder(String[] ids, EmailFolder folder) throws Exception {
        String folderName = this.getFolderNameByEmailFolder(folder);
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl)this.protocolFactory.getProtocol(folderName);
        protocol.connect(2);
        protocol.deletedMessageByUID(this.parseLongs(ids));
        protocol.disconnect();
    }

    @Override
    public void doCreate(EmailValueObject vo) throws Exception {
    }

    @Override
    public void doUpdate(EmailValueObject vo) throws Exception {
    }

    @Override
    public void doSaveEmail(Email email, EmailFolder folder) throws Exception {
        if (folder == null) {
            throw new OBPMValidateException("EmailFolder can't null");
        }
        String folderName = this.getFolderNameByEmailFolder(folder);
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl)this.protocolFactory.getProtocol(folderName);
        protocol.connect(2);
        com.teemlink.email.runtime.model.Email modelEmail = protocol.appendMessage(this.valueOf(email));
        if (modelEmail != null) {
            if (!StringUtil.isBlank((String)email.getId())) {
                protocol.deletedMessageByUID(new long[]{Long.parseLong(email.getId())});
            }
            email.setId(String.valueOf(modelEmail.getUid()));
            this.saveAttachment(email);
        }
    }

    private void saveAttachment(Email email) throws Exception {
        AttachmentProcessBean process = new AttachmentProcessBean();
        if (email.getEmailBody().isMultipart()) {
            for (Attachment att : email.getEmailBody().getAttachments()) {
                att.setEmailid(email.getId());
                att.setEmailBody(null);
                process.doUpdate(att);
            }
        }
    }

    private void deleteAttachment(Email email) throws Exception {
        AttachmentProcessBean process = new AttachmentProcessBean();
        if (email.getEmailBody().isMultipart()) {
            for (Attachment att : email.getEmailBody().getAttachments()) {
                att.setEmailid(email.getId());
                process.doRemove(att);
            }
        }
    }

    @Override
    public void doRemoveEmailByEmailUser(String emailUserId) throws Exception {
        throw new UnsupportedOperationException();
    }
}

