/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.email.service;

import com.teemlink.email.email.base.EmailValueObject;
import com.teemlink.email.email.dao.EmailBodyRepository;
import com.teemlink.email.email.model.EmailBody;
import com.teemlink.email.email.service.AbstractEmailServiceImpl;
import com.teemlink.email.email.service.EmailBodyProcess;
import com.teemlink.email.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;

public class EmailBodyProcessBean
extends AbstractEmailServiceImpl<EmailBody>
implements EmailBodyProcess {
    private static final long serialVersionUID = -6863199658668569708L;
    @Autowired
    EmailBodyRepository emailBodyRepository;

    @Override
    public void doCreate(EmailValueObject vo) throws Exception {
        EmailBody body = (EmailBody)vo;
        this.checkAddress(body);
        this.emailBodyRepository.save(body);
    }

    private void checkAddress(EmailBody emailBody) {
        if (emailBody == null) {
            return;
        }
        emailBody.setFrom(Constants.emailAddress2Account(emailBody.getFrom()));
        emailBody.setBcc(this.changeAddress(emailBody.getBcc()));
        emailBody.setCc(this.changeAddress(emailBody.getCc()));
        emailBody.setTo(this.changeAddress(emailBody.getTo()));
    }

    private String changeAddress(String address) {
        if (address == null) {
            return null;
        }
        String[] addresss = address.split(";");
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < addresss.length; ++i) {
            if (buffer.length() > 1) {
                buffer.append(";").append(Constants.emailAddress2Account(addresss[i]));
                continue;
            }
            buffer.append(Constants.emailAddress2Account(addresss[i]));
        }
        return buffer.toString();
    }

    @Override
    public void doUpdate(EmailValueObject vo) throws Exception {
        EmailBody body = (EmailBody)vo;
        this.checkAddress(body);
        this.emailBodyRepository.save(body);
    }
}

