/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.email.model;

import cn.myapps.common.util.StringUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.teemlink.email.attachment.model.Attachment;
import com.teemlink.email.email.base.EmailValueObject;
import com.teemlink.email.util.FileUtil;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="T_EMAIL_BODY")
public class EmailBody
extends EmailValueObject {
    private static final long serialVersionUID = 357203441557251315L;
    @Id
    @Column(name="ID")
    private String id;
    @Column(name="SUBJECT")
    private String subject;
    @Column(name="CONTENT")
    private String content;
    @Column(name="E_FROM")
    private String from;
    @Column(name="RE_TO")
    private String to;
    @Column(name="RE_CC")
    private String cc;
    @Column(name="RE_BCC")
    private String bcc;
    @Column(name="SENDDATE")
    private Date sendDate;
    @OneToMany(targetEntity=Attachment.class, mappedBy="emailBody")
    private Set<Attachment> attachments;
    private boolean multipart;
    @Column(name="E_FROMDEP")
    private String fromdep;

    public String getFromdep() {
        return this.fromdep;
    }

    public void setFromdep(String fromdep) {
        this.fromdep = fromdep;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getCc() {
        return this.cc;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public String getBcc() {
        return this.bcc;
    }

    public void setBcc(String bcc) {
        this.bcc = bcc;
    }

    public Date getSendDate() {
        return this.sendDate;
    }

    public void setSendDate(Date sendDate) {
        this.sendDate = sendDate;
    }

    public Set<Attachment> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new HashSet<Attachment>();
        }
        return this.attachments;
    }

    public void addAttachment(Attachment attachment) {
        if (attachment != null) {
            attachment.setEmailBody(this);
            this.getAttachments().add(attachment);
        }
    }

    public void setAttachments(Set<Attachment> attachments) {
        this.attachments = attachments;
    }

    public boolean isMultipart() {
        if (this.multipart) {
            return this.multipart;
        }
        this.multipart = this.attachments != null && !this.attachments.isEmpty();
        return this.multipart;
    }

    public void setMultipart(boolean multipart) {
        this.multipart = multipart;
    }

    @JsonIgnore
    public boolean isSentBcc() {
        return !StringUtil.isBlank((String)this.bcc);
    }

    @JsonIgnore
    public boolean isSentCc() {
        return !StringUtil.isBlank((String)this.cc);
    }

    @JsonIgnore
    public String getAttachmentsTotalSize() {
        long fileSize = 0L;
        for (Attachment at : this.getAttachments()) {
            fileSize += at.getSize();
        }
        if (fileSize == 0L) {
            return "";
        }
        return FileUtil.FormetFileSize(fileSize);
    }
}

