/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.email.model;

import cn.myapps.common.util.StringUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.teemlink.email.attachment.model.Attachment;
import com.teemlink.email.email.base.EmailValueObject;
import com.teemlink.email.email.model.EmailBody;
import com.teemlink.email.email.model.EmailUser;
import com.teemlink.email.folder.model.EmailFolder;
import com.teemlink.email.runtime.model.EmailHeader;
import com.teemlink.email.runtime.model.EmailPart;
import com.teemlink.email.runtime.parser.HTMLMessageParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="T_EMAIL")
public class Email
extends EmailValueObject {
    private static final long serialVersionUID = 5747224167350343414L;
    public static final int MSGLEVEL_NORMAL = 0;
    public static final int MSGLEVEL_IMPORTANT = 1;
    public static final int MSGLEVEL_URGENCY = 2;
    @Id
    @Column(name="ID")
    private String id;
    @ManyToOne(targetEntity=EmailBody.class)
    @JoinColumn(name="EMAILBODY_ID", referencedColumnName="ID")
    private EmailBody emailBody;
    @Column(name="ISREAD")
    private boolean read;
    @ManyToOne(targetEntity=EmailFolder.class)
    @JoinColumn(name="EMAILFOLDERID", referencedColumnName="ID")
    private EmailFolder emailFolder;
    @Column(name="READDATE")
    private Date readDate;
    @Column(name="EMAILID")
    private long emailId;
    @Column(name="ISREPLY")
    private boolean reply;
    @Column(name="ISFORWARD")
    private boolean forward;
    @ManyToOne(targetEntity=EmailUser.class)
    @JoinColumn(name="EMAINL_USER_ID", referencedColumnName="ID")
    private EmailUser emailUser;
    @Column(name="MSGLEVEL")
    private int msgLevel = 0;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public EmailBody getEmailBody() {
        if (this.emailBody == null) {
            this.emailBody = new EmailBody();
        }
        return this.emailBody;
    }

    public void setEmailBody(EmailBody emailBody) {
        this.emailBody = emailBody;
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public EmailFolder getEmailFolder() {
        if (this.emailFolder == null) {
            this.emailFolder = new EmailFolder();
        }
        return this.emailFolder;
    }

    public void setEmailFolder(EmailFolder emailFolder) {
        this.emailFolder = emailFolder;
    }

    public Date getReadDate() {
        return this.readDate;
    }

    public void setReadDate(Date readDate) {
        this.readDate = readDate;
    }

    public long getEmailId() {
        return this.emailId;
    }

    public void setEmailId(long emailId) {
        this.emailId = emailId;
    }

    public boolean isReply() {
        return this.reply;
    }

    public void setReply(boolean reply) {
        this.reply = reply;
    }

    public boolean isForward() {
        return this.forward;
    }

    public void setForward(boolean forward) {
        this.forward = forward;
    }

    public EmailUser getEmailUser() {
        return this.emailUser;
    }

    public void setEmailUser(EmailUser emailUser) {
        this.emailUser = emailUser;
    }

    public int getMsgLevel() {
        return this.msgLevel;
    }

    public void setMsgLevel(int msgLevel) {
        this.msgLevel = msgLevel;
    }

    @JsonIgnore
    public Collection<String> getReceiver() {
        ArrayList<String> result = new ArrayList<String>();
        if (!StringUtil.isBlank((String)this.emailBody.getTo())) {
            this.addReceiver(result, this.emailBody.getTo());
        }
        if (!StringUtil.isBlank((String)this.emailBody.getCc())) {
            this.addReceiver(result, this.emailBody.getCc());
        }
        if (!StringUtil.isBlank((String)this.emailBody.getBcc())) {
            this.addReceiver(result, this.emailBody.getBcc());
        }
        return result;
    }

    @JsonIgnore
    private void addReceiver(Collection<String> coll, String receiver) {
        String[] receivers = receiver.split(";");
        if (receivers == null || receivers.length == 1) {
            receivers = receiver.split(",");
        }
        for (int i = 0; i < receivers.length; ++i) {
            String temp = receivers[i];
            if (StringUtil.isBlank((String)temp)) continue;
            coll.add(temp);
        }
    }

    @JsonIgnore
    public static Email valueOf(EmailHeader header) {
        Email email = null;
        if (header != null) {
            email = new Email();
            email.setId(String.valueOf(header.getEmailUID()));
            email.setRead(header.getUnread() == false);
            email.getEmailBody().setMultipart(header.isMultipart());
            email.getEmailBody().setCc(header.getCcString());
            email.getEmailBody().setSendDate(header.getDate());
            email.getEmailBody().setFrom(header.getFromString());
            email.getEmailBody().setTo(header.getToString());
            email.getEmailBody().setSubject(header.getSubject());
            email.getEmailFolder().setId(String.valueOf(header.getFolderid()));
        }
        return email;
    }

    @JsonIgnore
    public static Email valueOf(com.teemlink.email.runtime.model.Email email) {
        Email result = null;
        if (email != null) {
            result = new Email();
            result.setRead(email.getBaseHeader().getUnread() == false);
            result.getEmailBody().setCc(email.getCc());
            result.getEmailBody().setSendDate(email.getDate());
            result.getEmailBody().setFrom(email.getFrom());
            result.getEmailBody().setTo(email.getTo());
            result.getEmailBody().setSubject(email.getSubject());
            if (email.getParts() != null && !email.getParts().isEmpty()) {
                EmailPart part = email.getParts().get(0);
                result.getEmailBody().setContent(HTMLMessageParser.toContent(part.getContent().toString()));
                for (int i = 1; i < email.getParts().size(); ++i) {
                    part = email.getParts().get(i);
                    if (!part.isHTMLText() && !part.isPlainText()) {
                        Attachment attachment = new Attachment();
                        attachment.setRealFileName(part.getFileName());
                        attachment.setFileName(part.getFileName());
                        attachment.setSize(part.getSize());
                        result.getEmailBody().addAttachment(attachment);
                        continue;
                    }
                    if (!part.isHTMLText()) continue;
                    result.getEmailBody().setContent(part.getContent().toString());
                }
            }
        }
        return result;
    }

    @JsonIgnore
    public boolean isMultipart() {
        return this.getEmailBody().isMultipart();
    }
}

