/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.email.action;

import cn.myapps.auth.model.Domain;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.email.model.WebUser;
import com.teemlink.email.email.model.EmailUser;
import com.teemlink.email.email.service.EmailUserProcessBean;
import com.teemlink.email.runtime.mail.AuthProfile;
import com.teemlink.email.runtime.mail.ConnectionMetaHandler;
import com.teemlink.email.runtime.mail.ConnectionProfile;
import com.teemlink.email.runtime.mail.Protocol;
import com.teemlink.email.runtime.mail.ProtocolFactory;
import com.teemlink.email.util.Constants;
import com.teemlink.email.util.Domain2ProfileUtil;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailUserHelper {
    private static final Logger LOG = LoggerFactory.getLogger(EmailUserHelper.class);

    public static void loginEmailSystem(WebUser webUser) throws Exception, SecurityException {
        try {
            EmailUserProcessBean emailUserProcess = new EmailUserProcessBean();
            EmailUser emailUser = emailUserProcess.getEmailUserByOwner(webUser.getId(), webUser.getDomainid());
            if (emailUser == null) {
                emailUser = new EmailUser();
                emailUser.setAccount(webUser.getLoginno());
                emailUser.setName(webUser.getName());
                emailUser.setCreateDate(new Date());
                emailUser.setDomainid(webUser.getDomainid());
                emailUser.setOwnerid(webUser.getId());
                emailUserProcess.doCreate(emailUser);
            }
            EmailUserHelper.loginEmailSystem(webUser, emailUser);
        }
        catch (Exception e) {
            LOG.error("#########\u90ae\u4ef6\u7cfb\u7edf\u767b\u5f55\u5931\u8d25\uff01<Login failed mail system!>#########");
            if (webUser != null) {
                webUser.setEmailUser(null);
            }
            throw new OBPMValidateException("Login failed mail system");
        }
    }

    public static void loginEmailSystem(WebUser webUser, EmailUser emailUser) throws Exception, SecurityException {
        try {
            if (webUser == null) {
                throw new SecurityException("{*[page.timeout]*}");
            }
            webUser.setEmailUser(emailUser);
        }
        catch (Exception e) {
            LOG.error("#########\u90ae\u4ef6\u7cfb\u7edf\u767b\u5f55\u5931\u8d25\uff01<Login failed mail system!>#########");
            if (webUser != null) {
                webUser.setEmailUser(null);
            }
            throw new OBPMValidateException("Login failed mail system");
        }
    }

    public static void initConnectionHandler(WebUser webUser, HttpServletRequest request) throws Exception {
        if (webUser == null || webUser.getEmailUser() == null) {
            throw new SecurityException("{*[page.timeout]*}");
        }
        AuthProfile authProfile = new AuthProfile();
        authProfile.setUserName(webUser.getEmailUser().getAccount());
        authProfile.setPassword(webUser.getEmailUser().getPassword());
        ConnectionMetaHandler handler = new ConnectionMetaHandler();
        Domain emailConfig = webUser.getDomain();
        ConnectionProfile profile = Domain2ProfileUtil.toProfile(emailConfig);
        ProtocolFactory factory = new ProtocolFactory(profile, authProfile, handler, emailConfig.getFunctionDomain());
        if (emailConfig.getTrash() != null && !"".equals(emailConfig.getTrash())) {
            Constants.DEFAULT_FOLDER_JUNK = emailConfig.getTrash();
        }
        if (emailConfig.getSender() != null && !"".equals(emailConfig.getSender())) {
            Constants.DEFAULT_FOLDER_SENT = emailConfig.getSender();
        }
        if (emailConfig.getRemoved() != null && !"".equals(emailConfig.getRemoved())) {
            Constants.DEFAULT_FOLDER_REMOVED = emailConfig.getRemoved();
        }
        if (emailConfig.getDraft() != null && !"".equals(emailConfig.getDraft())) {
            Constants.DEFAULT_FOLDER_DRAFTS = emailConfig.getDraft();
        }
        Protocol protocol = factory.getProtocol("INBOX");
        handler = protocol.connect(2);
        webUser.setConnectionMetaHandler(handler);
    }
}

