/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.attachment.service;

import cn.myapps.common.util.StringUtil;
import com.teemlink.email.attachment.model.Attachment;
import com.teemlink.email.attachment.service.AttachmentProcess;
import com.teemlink.email.email.dao.IEamilDAO;
import com.teemlink.email.email.model.Email;
import com.teemlink.email.email.service.AbstractEmailServiceImpl;
import com.teemlink.email.folder.model.EmailFolder;
import com.teemlink.email.runtime.mail.ImapProtocolImpl;
import com.teemlink.email.runtime.mail.ProtocolFactory;
import com.teemlink.email.runtime.model.EmailPart;
import com.teemlink.email.runtime.parser.MessageParser;
import java.util.Collection;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Part;

public class AttachmentProcessImapBean
extends AbstractEmailServiceImpl<Attachment>
implements AttachmentProcess {
    private static final long serialVersionUID = -3358596562359189962L;
    private transient ProtocolFactory protocolFactory;

    public AttachmentProcessImapBean(ProtocolFactory protocolFactory) throws Exception {
        this.protocolFactory = protocolFactory;
    }

    protected IEamilDAO<Attachment> getDAO() throws Exception {
        return null;
    }

    @Override
    public Attachment getAttachment(String emailid, EmailFolder folder, String fileName) throws Exception {
        String folderName = this.getFolderNameByEmailFolder(folder);
        ImapProtocolImpl protocol = (ImapProtocolImpl)this.protocolFactory.getProtocol(folderName);
        if (protocol != null) {
            EmailPart part;
            protocol.connect(1);
            Message message = protocol.getMessageByUID(Long.parseLong(emailid));
            if (message != null && (part = MessageParser.parseMessagePart((Part)message, fileName)) != null) {
                return Attachment.valueOf(part);
            }
        }
        return null;
    }

    public String getFolderNameByEmailFolder(EmailFolder folder) {
        String folderName = folder.getName();
        if (StringUtil.isBlank((String)folderName)) {
            folderName = this.getFolderNameById(folder.getId());
        }
        return folderName;
    }

    public String getFolderNameById(String id) {
        Folder folder = this.protocolFactory.getConnectionMetaHandler().getFolderByUID(Long.parseLong(id));
        return folder.getFullName();
    }

    public Collection<Attachment> getAttachmentsByEmail(Email email) throws Exception {
        return null;
    }
}

