/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.attachment.service;

import com.teemlink.email.attachment.dao.AttachmentDAO;
import com.teemlink.email.attachment.dao.AttachmentRepository;
import com.teemlink.email.attachment.model.Attachment;
import com.teemlink.email.attachment.service.AttachmentProcess;
import com.teemlink.email.email.base.EmailValueObject;
import com.teemlink.email.email.dao.IEamilDAO;
import com.teemlink.email.email.model.Email;
import com.teemlink.email.email.service.AbstractEmailServiceImpl;
import com.teemlink.email.email.service.EmailProcessImapBean;
import com.teemlink.email.folder.model.EmailFolder;
import com.teemlink.email.util.AttachmentUtil;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;

public class AttachmentProcessBean
extends AbstractEmailServiceImpl<Attachment>
implements AttachmentProcess {
    private static final long serialVersionUID = 1933447807515757290L;
    @Autowired
    AttachmentRepository attachmentRepository;

    protected IEamilDAO<Attachment> getDAO() throws Exception {
        return null;
    }

    @Override
    public Attachment getAttachment(String emailid, EmailFolder folder, String fileName) throws Exception {
        EmailProcessImapBean process = new EmailProcessImapBean(null);
        Email email = (Email)process.doView(emailid);
        if (email != null && email.getEmailBody().isMultipart()) {
            for (Attachment attachment : email.getEmailBody().getAttachments()) {
                if (!attachment.getRealFileName().equals(fileName)) continue;
                return attachment;
            }
        }
        return null;
    }

    @Override
    public void doCreate(EmailValueObject vo) throws Exception {
        ((Attachment)vo).setCreateDate(new Date());
        this.attachmentRepository.save((Attachment)vo);
    }

    @Override
    public void doRemove(String pk) throws Exception {
        Attachment attachment = (Attachment)this.doView(pk);
        if (attachment != null) {
            this.doRemove(attachment);
        }
    }

    @Override
    public void doRemove(EmailValueObject obj) throws Exception {
        this.attachmentRepository.delete((Attachment)obj);
        AttachmentUtil.removeAttachmentFile(((Attachment)obj).getFileName());
    }

    public Collection<Attachment> getAttachmentsByEmail(Email email) throws Exception {
        return ((AttachmentDAO)this.getDAO()).queryAttachmentByEmails(email);
    }
}

