/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.email.attachment.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.teemlink.email.email.base.EmailValueObject;
import com.teemlink.email.email.model.EmailBody;
import com.teemlink.email.runtime.model.EmailPart;
import com.teemlink.email.util.AttachmentUtil;
import com.teemlink.email.util.Utility;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="T_EMAIL_ATTACHMENT")
public class Attachment
extends EmailValueObject {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="ID")
    private String id;
    @JsonBackReference
    @ManyToOne(targetEntity=EmailBody.class)
    @JoinColumn(name="EMAILBODY_ID", referencedColumnName="ID")
    private EmailBody emailBody;
    @Column(name="FILENAME")
    private String fileName;
    @Column(name="REALFILENAME")
    private String realFileName;
    @Column(name="FILETEXT")
    private byte[] fileText;
    @Column(name="PATH")
    private String path;
    @Column(name="CREATDATE")
    private Date createDate;
    @Column(name="FILESIZE")
    private long size;
    @Transient
    private Object content;
    @Column(name="EMAILID")
    private String emailid;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public EmailBody getEmailBody() {
        return this.emailBody;
    }

    public void setEmailBody(EmailBody emailBody) {
        this.emailBody = emailBody;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getRealFileName() {
        return this.realFileName;
    }

    public void setRealFileName(String realFileName) {
        this.realFileName = realFileName;
    }

    public byte[] getFileText() {
        return this.fileText;
    }

    public void setFileText(byte[] fileText) {
        this.fileText = fileText;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @JsonIgnore
    public String getFileAllPath() {
        try {
            return AttachmentUtil.getAttachmentDir() + "/" + this.getFileName();
        }
        catch (Exception e) {
            return "";
        }
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    @JsonIgnore
    public String getSizeString() {
        return Utility.sizeToHumanReadable(this.size);
    }

    public Object getContent() {
        return this.content;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public static Attachment valueOf(EmailPart part) {
        if (part != null) {
            Attachment attachment = new Attachment();
            attachment.setContent(part.getContent());
            attachment.setRealFileName(part.getFileName());
            attachment.setFileName(part.getFileName());
            attachment.setSize(part.getSize());
            return attachment;
        }
        return null;
    }

    public String getEmailid() {
        return this.emailid;
    }

    public void setEmailid(String emailid) {
        this.emailid = emailid;
    }
}

