/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.email.controller;

import cn.myapps.auth.model.Domain;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.email.controller.AbstractEmailController;
import cn.myapps.email.model.WebUser;
import com.teemlink.email.attachment.model.Attachment;
import com.teemlink.email.attachment.service.AttachmentProcess;
import com.teemlink.email.attachment.service.AttachmentProcessBean;
import com.teemlink.email.email.model.Email;
import com.teemlink.email.email.model.EmailBody;
import com.teemlink.email.email.model.EmailUser;
import com.teemlink.email.email.service.EmailProcess;
import com.teemlink.email.email.service.EmailUserProcess;
import com.teemlink.email.folder.action.EmailFolderHelper;
import com.teemlink.email.folder.model.EmailFolder;
import com.teemlink.email.folder.service.EmailFolderProcess;
import com.teemlink.email.util.AttachmentUtil;
import com.teemlink.email.util.Constants;
import com.teemlink.email.util.EmailConfig;
import com.teemlink.email.util.EmailProcessUtil;
import com.teemlink.email.util.Environment;
import com.teemlink.email.util.Utility;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u90ae\u4ef6\u6267\u884c\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/email"}, produces={"application/json;charset=UTF-8"})
public class EmailController
extends AbstractEmailController {
    @Autowired
    private EmailUserProcess emailUserProcess;
    @Autowired
    protected HttpServletResponse response;

    @PostMapping(value={"/userLogin"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u90ae\u7bb1\u7528\u6237\u767b\u5f55", notes="\u90ae\u7bb1\u7528\u6237\u767b\u5f55")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource emailLogin(@RequestBody String content) {
        try {
            JSONObject jsonObject = JSONObject.fromObject((Object)content);
            EmailUser emailUser = (EmailUser)this.json2obj(jsonObject, EmailUser.class);
            WebUser webUser = this.getUser();
            if (webUser == null) {
                return this.error(500, "\u524d\u53f0\u7528\u6237\u672a\u767b\u5f55", null);
            }
            emailUser.setDomainid(webUser.getDomainid());
            if (StringUtils.isBlank((String)emailUser.getId())) {
                this.emailUserProcess.doCreate(emailUser);
            } else {
                this.emailUserProcess.doUpdate(emailUser);
            }
            webUser.setEmailUser(emailUser);
            EmailProcessUtil.userFolderMap.put(emailUser.getAccount(), null);
            if (webUser.getConnectionMetaHandler(this.request) == null) {
                throw new Exception();
            }
            this.setUser(webUser);
            return this.success("ok", "\u767b\u5f55\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef", null);
        }
    }

    @GetMapping(value={"/getEmailSuffix"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u90ae\u7bb1\u540e\u7f00", notes="\u83b7\u53d6\u90ae\u7bb1\u540e\u7f00")
    public Resource getEmailSuffix() {
        String data = "";
        try {
            Domain domainVO = this.getUser().getDomain();
            data = domainVO.getFunctionDomain();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.success("ok", data);
    }

    @GetMapping(value={"/getFolderList"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u90ae\u7bb1\u6587\u4ef6\u5939\u5217\u8868", notes="\u83b7\u53d6\u90ae\u7bb1\u6587\u4ef6\u5939\u5217\u8868")
    public Resource getFolderList() {
        Collection<Object> systemFolders = new ArrayList();
        try {
            WebUser webUser = this.getUser();
            systemFolders = EmailFolderHelper.getSystemFolders(webUser);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.success("ok", systemFolders);
    }

    @GetMapping(value={"/getFolderEmails"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u90ae\u7bb1\u6587\u4ef6\u5939\u4e2d\u90ae\u4ef6\u5217\u8868", notes="\u83b7\u53d6\u90ae\u7bb1\u6587\u4ef6\u5939\u4e2d\u90ae\u4ef6\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="folderId", value="\u6587\u4ef6\u5939id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="unread", value="\u5df2\u8bfb\u3001\u672a\u8bfb", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="departmentId", value="\u53d1\u4ef6\u4eba\u6240\u5728\u90e8\u95e8id", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="smSubject", value="\u4e3b\u9898", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="smFrom", value="\u53d1\u4ef6\u4eba", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="startDate", value="\u5f00\u59cb\u65e5\u671f", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="endDate", value="\u7ed3\u675f\u65e5\u671f", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="linesPerPage", value="\u6bcf\u9875\u663e\u793a\u6570\u636e\u6570", required=false, paramType="query", dataType="string")})
    public Resource getEmailsByFolder(@RequestParam String folderId, String unread, String departmentId, String smSubject, String smFrom, String startDate, String endDate, String pageNo, String linesPerPage) {
        try {
            EmailProcess emailProcess = (EmailProcess)EmailProcessUtil.createProcess(EmailProcess.class, this.request, this.getUser());
            EmailUser user = this.getUser().getEmailUser();
            EmailFolder folder = null;
            EmailFolderProcess folderProcess = (EmailFolderProcess)EmailProcessUtil.createProcess(EmailFolderProcess.class, this.request, this.getUser());
            if (Utility.isBlank(folderId)) {
                folder = folderProcess.getEmailFolderByOwnerId("INBOX", "0000-0000-00000000-0000-000000000000");
                folderId = folder.getId();
            } else {
                folder = folderProcess.getEmailFolderById(folderId);
            }
            if (folder == null) {
                throw new OBPMValidateException("\u6587\u4ef6\u5939\u4e0d\u5b58\u5728");
            }
            smFrom = Constants.emailAddress2Account(smFrom);
            String isAjax = "false";
            if (!(StringUtils.isBlank((String)unread) && StringUtils.isBlank((String)smSubject) && StringUtils.isBlank((String)smFrom) && StringUtils.isBlank((String)startDate) && StringUtils.isBlank((String)endDate))) {
                isAjax = "true";
            }
            int page = pageNo != null && pageNo.length() > 0 ? Integer.parseInt(pageNo) : 1;
            int lines = linesPerPage != null && linesPerPage.length() > 0 ? Integer.parseInt(linesPerPage) : 10;
            DataPackage<Email> emails = emailProcess.getEmailsByFolderUser(folderId, unread, user.getAccount(), departmentId, smSubject, smFrom, "", startDate, endDate, isAjax, page, lines);
            return this.success("ok", emails);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(value={"/getEmail"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u90ae\u4ef6\u8be6\u60c5", notes="\u83b7\u53d6\u90ae\u4ef6\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="emailId", value="\u90ae\u4ef6id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="folderId", value="\u6587\u4ef6\u5939id", required=true, paramType="query", dataType="string")})
    public Resource doGetEamil(@RequestParam String emailId, @RequestParam String folderId) {
        try {
            EmailProcess emailProcess = (EmailProcess)EmailProcessUtil.createProcess(EmailProcess.class, this.request, this.getUser());
            EmailFolderProcess folderProcess = (EmailFolderProcess)EmailProcessUtil.createProcess(EmailFolderProcess.class, this.request, this.getUser());
            EmailFolder folder = folderProcess.getEmailFolderById(folderId);
            Environment env = Environment.getInstance();
            env.setContextPath(this.request.getContextPath());
            Email email = emailProcess.getEmailByID(emailId, folder);
            if (email != null) {
                if (Constants.DEFAULT_FOLDER_DRAFTS.equals(email.getEmailFolder().getName()) && !email.isRead()) {
                    email.setRead(true);
                    email.setReadDate(new Date());
                    emailProcess.doUpdate(email);
                }
                if (!email.isRead()) {
                    email.setRead(true);
                    email.setReadDate(new Date());
                    emailProcess.doUpdate(email);
                }
            }
            return this.success("ok", email);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(value={"/removeEmail"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u90ae\u4ef6", notes="\u5220\u9664\u90ae\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u90ae\u4ef6id", required=true, paramType="body", dataType="string"), @ApiImplicitParam(name="folderId", value="\u6587\u4ef6\u5939id", required=true, paramType="query", dataType="string")})
    public Resource doDeleteEmail(@RequestParam String folderId, @RequestBody String[] ids) {
        try {
            EmailProcess emailProcess = (EmailProcess)EmailProcessUtil.createProcess(EmailProcess.class, this.request, this.getUser());
            emailProcess.doToRecy(ids, folderId);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(value={"/deleteEmail"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5f7b\u5e95\u5220\u9664\u90ae\u4ef6", notes="\u5f7b\u5e95\u5220\u9664\u90ae\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u90ae\u4ef6id", required=true, paramType="body", dataType="string"), @ApiImplicitParam(name="folderId", value="\u6587\u4ef6\u5939id", required=true, paramType="query", dataType="string")})
    public Resource completelyDeleteEmail(@RequestParam String folderId, @RequestBody String[] ids) {
        try {
            EmailProcess emailProcess = (EmailProcess)EmailProcessUtil.createProcess(EmailProcess.class, this.request, this.getUser());
            EmailFolderProcess folderProcess = (EmailFolderProcess)EmailProcessUtil.createProcess(EmailFolderProcess.class, this.request, this.getUser());
            EmailFolder folder = folderProcess.getEmailFolderById(folderId);
            emailProcess.doRemoveByFolder(ids, folder);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(value={"/sendEmail"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u53d1\u9001\u90ae\u4ef6", notes="\u53d1\u9001\u90ae\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string"), @ApiImplicitParam(name="folderId", value="\u6587\u4ef6\u5939id", required=true, paramType="query", dataType="string")})
    public Resource sendEmail(@RequestBody String content, String folderId) {
        try {
            EmailProcess emailProcess = (EmailProcess)EmailProcessUtil.createProcess(EmailProcess.class, this.request, this.getUser());
            JSONObject jsonObject = JSONObject.fromObject((Object)content);
            EmailBody emailBody = (EmailBody)this.json2obj(jsonObject, EmailBody.class);
            JSONArray ids = jsonObject.getJSONArray("attids");
            String[] attids = null;
            if (ids != null && ids.size() > 0) {
                attids = (String[])Arrays.copyOf(ids.toArray(), ids.toArray().length, String[].class);
            }
            EmailFolderProcess emailFolderProcess = (EmailFolderProcess)EmailProcessUtil.createProcess(EmailFolderProcess.class, this.request, this.getUser());
            EmailFolder folder = emailFolderProcess.getEmailFolderById(folderId);
            Email email = new Email();
            email.setEmailBody(emailBody);
            email.setEmailFolder(folder);
            EmailUser user = this.getUser().getEmailUser();
            if (folder == null) {
                folder = EmailFolderHelper.createEmptyEmailFolder();
            }
            if (email.getEmailBody() == null) {
                throw new OBPMValidateException();
            }
            this.addAttachmentsByIds(email, attids);
            boolean sentBox = false;
            if (folder.getName().equals(Constants.DEFAULT_FOLDER_DRAFTS)) {
                email.setEmailFolder(folder);
                email.setEmailUser(user);
                emailProcess.doSaveEmail(email, folder);
            } else if (folder.getName().equals(Constants.DEFAULT_FOLDER_SENT)) {
                sentBox = true;
                if (!this.checkEmailAddress(email)) {
                    throw new OBPMValidateException("Email address error");
                }
                email.setEmailFolder(folder);
                emailProcess.sendEmail(email, user, sentBox);
            }
            return this.success("ok", email);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(value={"/markEmail"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6807\u8bb0\u90ae\u4ef6", notes="\u6807\u8bb0\u90ae\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="mark", value="\u6807\u8bb0", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="folderId", value="\u6587\u4ef6\u5939id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="ids", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doMarkEmail(@RequestParam String mark, @RequestParam String folderId, @RequestBody String[] ids) {
        try {
            EmailProcess emailProcess = (EmailProcess)EmailProcessUtil.createProcess(EmailProcess.class, this.request, this.getUser());
            EmailFolder folder = new EmailFolder();
            folder.setId(folderId);
            switch (mark) {
                case "0": {
                    emailProcess.doUpdateMarkRead(ids, false, folder);
                    break;
                }
                case "1": {
                    emailProcess.doUpdateMarkRead(ids, true, folder);
                }
            }
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/uploadAttachment"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u90ae\u4ef6\u9644\u4ef6\u4e0a\u4f20", notes="\u90ae\u4ef6\u9644\u4ef6\u4e0a\u4f20")
    @ApiImplicitParams(value={@ApiImplicitParam(name="multipartFiles", value="\u591a\u4e2a\u6587\u4ef6", required=true, paramType="query", dataType="string")})
    public Resource uploadAttachment(@RequestParam(value="file") MultipartFile[] multipartFiles) {
        try {
            long ATTACHMENT_MAX_SIZE = EmailConfig.getInteger("attachment.max.size", 51200000);
            long ATTACHMENT_MAX_COUNT = EmailConfig.getInteger("attachment.max.count", 3);
            Attachment attachment = new Attachment();
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setSizeThreshold(10240000);
            File tempFile = AttachmentUtil.createAttachmentTempFile();
            factory.setRepository(tempFile);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setFileSizeMax(ATTACHMENT_MAX_SIZE);
            upload.setSizeMax(ATTACHMENT_MAX_SIZE);
            JSONObject json = new JSONObject();
            if (multipartFiles.length > 0) {
                for (int i = 0; i < multipartFiles.length; ++i) {
                    MultipartFile multipartFile = multipartFiles[i];
                    String fileName = multipartFile.getName();
                    fileName = fileName.replace(" ", "");
                    attachment.setRealFileName(fileName);
                    File file = AttachmentUtil.createAttachmentFile(fileName);
                    attachment.setFileName(file.getName());
                    attachment.setSize(multipartFile.getSize());
                    attachment.setPath(file.getPath());
                    multipartFile.transferTo(file);
                    AttachmentProcessBean process = new AttachmentProcessBean();
                    process.doCreate(attachment);
                    String dealPath = this.dealPath(attachment.getPath());
                    json.put((Object)"id", (Object)attachment.getId());
                    json.put((Object)"fileName", (Object)attachment.getRealFileName());
                    json.put((Object)"path", (Object)dealPath);
                }
            }
            Resource resource = this.success("ok", json);
            return resource;
        }
        catch (Exception e) {
            e.printStackTrace();
            Resource resource = this.error(500, e.getMessage(), null);
            return resource;
        }
    }

    @PutMapping(value={"/moveToFolder"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u79fb\u52a8\u90ae\u4ef6\u5230\u53e6\u4e00\u4e2a\u6587\u4ef6\u5939", notes="\u79fb\u52a8\u90ae\u4ef6\u5230\u53e6\u4e00\u4e2a\u6587\u4ef6\u5939")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u90ae\u4ef6id", required=true, paramType="body", dataType="string"), @ApiImplicitParam(name="currentFolderId", value="\u5f53\u524d\u6587\u4ef6\u5939id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="toFolderId", value="\u76ee\u6807\u6587\u4ef6\u5939id", required=true, paramType="query", dataType="string")})
    public Resource moveToFolder(@RequestBody String[] ids, @RequestParam String currentFolderId, @RequestParam String toFolderId) {
        try {
            EmailFolderProcess folderProcess = (EmailFolderProcess)EmailProcessUtil.createProcess(EmailFolderProcess.class, this.request, this.getUser());
            EmailFolder toFolder = folderProcess.getEmailFolderById(toFolderId);
            EmailFolder currentFolder = folderProcess.getEmailFolderById(currentFolderId);
            EmailProcess emailProcess = (EmailProcess)EmailProcessUtil.createProcess(EmailProcess.class, this.request, this.getUser());
            if (toFolder == null || currentFolder == null) {
                return this.error(500, "{*[core.email.move.error]*}", null);
            }
            emailProcess.doMoveTo(ids, currentFolder, toFolder);
        }
        catch (OBPMValidateException e) {
            e.printStackTrace();
            return this.error(500, e.getValidateMessage(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
        return this.success("ok", null);
    }

    @DeleteMapping(value={"/removeAttachment"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u90ae\u4ef6\u9644\u4ef6", notes="\u5220\u9664\u90ae\u4ef6\u9644\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u90ae\u4ef6\u9644\u4ef6id", required=true, paramType="query", dataType="string")})
    public Resource removeAttachment(@RequestParam String id) {
        try {
            AttachmentProcessBean aProcess = new AttachmentProcessBean();
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(value={"/downloadAttachment"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u4e0b\u8f7d\u90ae\u4ef6\u9644\u4ef6", notes="\u4e0b\u8f7d\u90ae\u4ef6\u9644\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="folderId", value="\u6587\u4ef6\u5939id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="emailId", value="\u90ae\u4ef6id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="fileName", value="\u6587\u4ef6\u540d\u79f0", required=true, paramType="query", dataType="string")})
    public void doDownload(@RequestParam String folderId, @RequestParam String emailId, @RequestParam String fileName) {
        block4: {
            try {
                Attachment attachment;
                AttachmentProcess aProcess = (AttachmentProcess)EmailProcessUtil.createProcess(AttachmentProcess.class, this.request, this.getUser());
                EmailFolderProcess emailFolderProcess = (EmailFolderProcess)EmailProcessUtil.createProcess(EmailFolderProcess.class, this.request, this.getUser());
                EmailFolder folder = emailFolderProcess.getEmailFolderById(folderId);
                if (folder == null || StringUtils.isBlank((String)emailId) || StringUtils.isBlank((String)fileName) || (attachment = aProcess.getAttachment(emailId, folder, fileName)) == null) break block4;
                String encoding = EmailConfig.getString("charset", "UTF-8");
                this.response.setContentType("application/octet-stream; charset=" + encoding);
                this.response.setHeader("Content-Disposition", "attachment;filename=\"" + URLEncoder.encode(fileName, encoding) + "\"");
                if (attachment.getContent() instanceof ByteArrayOutputStream) {
                    ByteArrayOutputStream bos = (ByteArrayOutputStream)attachment.getContent();
                    bos.writeTo((OutputStream)this.response.getOutputStream());
                    break block4;
                }
                File file = new File(attachment.getFileAllPath());
                if (file.exists()) {
                    this.setDownloadFile(this.response, file);
                    break block4;
                }
                throw new OBPMValidateException("\u627e\u4e0d\u5230\u90ae\u4ef6");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDownloadFile(HttpServletResponse response, File file) throws Exception {
        ServletOutputStream os = null;
        BufferedInputStream reader = null;
        try {
            String encoding = Environment.getInstance().getEncoding();
            response.setContentType("application/x-download; charset=" + encoding + "");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(file.getName(), encoding));
            os = response.getOutputStream();
            reader = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[4096];
            int i = -1;
            while ((i = reader.read(buffer)) != -1) {
                os.write(buffer, 0, i);
            }
            os.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                reader.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    public String dealPath(String path) {
        String attachmentDir = EmailConfig.getString("attachment.dir", PropertyUtil.getPath() + "/email/attachment");
        String[] strings = path.split("\\\\");
        String string2 = "";
        for (int i = 0; i < strings.length; ++i) {
            string2 = i == strings.length - 1 ? string2 + strings[i] : string2 + strings[i] + "/";
        }
        String string3 = string2.substring(string2.indexOf(attachmentDir));
        return string3;
    }

    private boolean checkEmailAddress(Email email) {
        if (email.getEmailBody().getTo() == null) {
            return false;
        }
        String[] strings = email.getEmailBody().getTo().split(";");
        if (strings.length > 1) {
            for (int i = 0; i < strings.length; ++i) {
                String address = Constants.emailShowAddressToAddress(strings[i]);
                if (Utility.checkEmailAddress(address)) continue;
                return false;
            }
        } else {
            strings = email.getEmailBody().getTo().split(",");
            for (int i = 0; i < strings.length; ++i) {
                String address = Constants.emailShowAddressToAddress(strings[i]);
                if (Utility.checkEmailAddress(address)) continue;
                return false;
            }
        }
        return true;
    }

    private void addAttachmentsByIds(Email email, String[] attids) {
        try {
            AttachmentProcessBean process = new AttachmentProcessBean();
            if (attids != null) {
                for (int i = 0; i < attids.length; ++i) {
                    Attachment temp = (Attachment)process.doView(attids[i]);
                    if (temp == null) continue;
                    email.getEmailBody().addAttachment(temp);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

