/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.email.controller;

import cn.myapps.auth.model.Domain;
import cn.myapps.common.controller.ErrorMessage;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.controller.ResourceNotFoundException;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.common.util.StringUtil;
import cn.myapps.conf.FeignConfig;
import cn.myapps.conf.UserAPI;
import cn.myapps.email.model.WebUser;
import com.jayway.jsonpath.PathNotFoundException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@RestController
public abstract class AbstractEmailController {
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    protected HttpSession session;
    private String domain;
    WebUser frontUser;
    private Resource resourceValue;

    protected WebUser getUser() throws Exception {
        if (this.frontUser == null) {
            WebUser user = new WebUser();
            String userId = Security.getUserIdFromToken((HttpServletRequest)this.request);
            FeignConfig.ACCESS_TOKEN = Security.getToken((String)userId);
            UserAPI userAPI = (UserAPI)SpringApplicationContextUtil.getBean(UserAPI.class);
            Map userMap = new LinkedHashMap();
            userMap = (Map)userAPI.getLoginUser().getData();
            user.setId(userId);
            user.setName((String)userMap.get("name"));
            user.setDomainid((String)userMap.get("domainId"));
            user.setDefaultDepartment((String)userMap.get("deptId"));
            JSONObject domain = userAPI.getDomainById(user.getDomainid());
            Domain domainVo = (Domain)this.json2obj(domain, Domain.class);
            user.setDomain(domainVo);
            this.frontUser = user;
        }
        return this.frontUser;
    }

    protected void setUser(WebUser user) throws Exception {
        this.frontUser = user;
    }

    protected String getUserId() throws Exception {
        String userId = null;
        try {
            userId = Security.getUserIdFromToken((HttpServletRequest)this.request);
            if (userId == null) {
                userId = Security.getDebugUserIdFromToken((HttpServletRequest)this.request);
            }
        }
        catch (Exception e) {
            return null;
        }
        return userId;
    }

    public ParamsTable getParams() {
        String isRelate;
        String parentid;
        String parentId;
        ParamsTable pm = ParamsTable.convertHTTP((HttpServletRequest)this.request);
        if (pm.getParameter("_pagelines") == null) {
            pm.setParameter("_pagelines", (Object)10);
        }
        if (!StringUtil.isBlank((String)(parentId = pm.getParameterAsString("parentId")))) {
            pm.setParameter("relateid", (Object)parentId);
            pm.setParameter("parentid", (Object)parentId);
        }
        if (!StringUtil.isBlank((String)(parentid = pm.getParameterAsString("parentid")))) {
            pm.setParameter("relateid", (Object)parentid);
            pm.setParameter("parentId", (Object)parentid);
        }
        if (StringUtil.isBlank((String)(isRelate = pm.getParameterAsString("isRelate"))) || !"true".equals(isRelate)) {
            pm.removeParameter("parentId");
            pm.removeParameter("parentid");
        }
        return pm;
    }

    protected Resource success(String errmsg, Object data) {
        return new Resource(0, errmsg, data, null);
    }

    protected Resource error(int errcode, String errmsg, Collection<ErrorMessage> errors) {
        return new Resource(errcode, errmsg, null, errors);
    }

    public Resource getResourceValue() {
        return this.resourceValue;
    }

    public void setResourceValue(Resource resourceValue) {
        this.resourceValue = resourceValue;
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public Resource resourceNotFound(ResourceNotFoundException e) {
        return this.error(404, "Not Found", null);
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Resource error(RuntimeException e) {
        e.printStackTrace();
        return this.error(500, "Server Error", null);
    }

    @ExceptionHandler(value={OBPMValidateException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Resource serverError(OBPMValidateException e) {
        e.printStackTrace();
        return this.error(500, "Server Error", null);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public Resource resourceNotFound(MethodArgumentTypeMismatchException e) {
        return this.error(40035, "\u4e0d\u5408\u6cd5\u7684\u53c2\u6570", null);
    }

    @ExceptionHandler(value={PathNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public Resource requestbodyError(PathNotFoundException e) {
        e.printStackTrace();
        return this.error(406, "\u8bf7\u6c42\u5305\u4f53\u53c2\u6570\u51fa\u9519", null);
    }

    public Object json2obj(JSONObject json, Class c) throws Exception {
        Object o = c.newInstance();
        Map<String, Class<?>> fieldsMap = AbstractEmailController.getObjectToMap(o);
        for (Map.Entry<String, Class<?>> next : fieldsMap.entrySet()) {
            Object value = json.get(next.getKey());
            boolean flag = false;
            if (value instanceof Integer) {
                flag = true;
                value = (int)((Integer)value);
            } else if (value instanceof String) {
                flag = !StringUtil.isBlank((String)((String)value));
                value = (String)value;
            } else if (value instanceof Boolean) {
                flag = true;
                value = (Boolean)value;
            }
            if (next.getValue().toString().equals("class java.util.Date") && value != null && !StringUtil.isBlank((String)value.toString())) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                value = format.parse(value.toString());
            }
            if (!flag) continue;
            Method method = c.getMethod("set" + next.getKey().substring(0, 1).toUpperCase() + next.getKey().substring(1), next.getValue());
            method.invoke(o, value);
        }
        return o;
    }

    public static Map<String, Class<?>> getObjectToMap(Object t) throws IllegalAccessException {
        HashMap param = new HashMap();
        for (Class<?> className = t.getClass(); className != Object.class; className = className.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = className.getDeclaredFields()) {
                field.setAccessible(true);
                Class<?> type = field.getType();
                param.put(field.getName(), type);
            }
        }
        return param;
    }
}

