/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.conf;

import cn.myapps.common.DataSourceFactory;
import cn.myapps.common.util.DbUtil;
import com.bcxin.saas.core.components.JsonProvider;
import java.util.HashMap;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

@Configuration
@ComponentScan(basePackages={"com.bcxin.web.commons.components"})
public class DataSourceConfig
implements TransactionManagementConfigurer {
    @Value(value="${spring.datasource.url}")
    private String dbUrl;
    @Value(value="${spring.datasource.username}")
    private String username;
    @Value(value="${spring.datasource.password}")
    private String password;
    @Value(value="${spring.datasource.driver-class-name}")
    private String driverClassName;
    @Value(value="${spring.datasource.validationQuery}")
    private String validationQuery;

    @Bean
    public DataSource druidDataSource() {
        DataSource ds = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("driverClassName", this.driverClassName);
        properties.put("url", this.dbUrl);
        properties.put("username", this.username);
        properties.put("password", this.password);
        this.validationQuery = DbUtil.getValidationQuery((String)this.driverClassName);
        properties.put("validationQuery", this.validationQuery);
        try {
            ds = DataSourceFactory.create(properties);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ds;
    }

    @Bean
    public JdbcTemplate jdbcTemplate(DataSource kmDataSource) {
        return new JdbcTemplate(kmDataSource);
    }

    public PlatformTransactionManager annotationDrivenTransactionManager() {
        return new DataSourceTransactionManager(this.druidDataSource());
    }

    @Bean
    public JsonProvider jsonProvider() {
        return new JsonProvider.JsonProviderImpl();
    }
}

