/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.workflow.definition.controller;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.module.Module;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.module.service.ModuleDesignTimeService;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.FormField;
import cn.myapps.runtime.workflow.element.Element;
import cn.myapps.runtime.workflow.element.ManualNode;
import cn.myapps.runtime.workflow.element.Node;
import cn.myapps.util.sequence.Sequence;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u6d41\u7a0b\u8bbe\u8ba1\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime/applications"}, produces={"application/json;charset=UTF-8"})
public class BillDefiController
extends AbstractDesignTimeController {
    private BillDefiDesignTimeService billDefiDesignTimeService = DesignTimeServiceManager.billDefiDesignTimeService();
    private FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();

    @PostMapping(path={"/{applicationId}/modules/{moduleId}/workflows"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u65b0\u5efa\u6d41\u7a0b", notes="\u65b0\u5efa\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="moduleId", value="\u6a21\u5757id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doNew(@PathVariable String applicationId, @PathVariable String moduleId, @RequestBody String content) {
        BillDefiVO bl = new BillDefiVO();
        JSONObject json = JSONObject.fromObject((Object)content);
        try {
            bl = (BillDefiVO)this.json2obj(json, BillDefiVO.class);
            Date lastmodify = new Date();
            bl.setLastmodify(lastmodify);
            bl.setId(Sequence.getDesignTimeSequence());
            bl.setParentId(moduleId);
            bl.setCheckout(true);
            bl.setCheckoutHandler(this.getUser().getId());
            this.doSaveValidate(bl);
            bl.setApplicationid(applicationId);
            this.billDefiDesignTimeService.doCreate(bl);
            JSONObject blJson = new JSONObject();
            blJson.put((Object)"id", (Object)bl.getId());
            return this.success("ok", blJson);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/modules/{moduleId}/workflows"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5217\u8868", notes="\u83b7\u53d6\u6d41\u7a0b\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="moduleId", value="\u6a21\u5757id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="linesPerPage", value="\u9875\u6761\u6570", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="name", value="\u6d41\u7a0b\u540d\u79f0", required=true, paramType="path", dataType="string")})
    public Resource getFlows(@PathVariable String moduleId) {
        ParamsTable params = this.getParams();
        String pageNo = params.getParameterAsString("pageNo");
        String linesPerPage = params.getParameterAsString("linesPerPage");
        String name = params.getParameterAsString("name");
        int page = pageNo != null && pageNo.length() > 0 ? Integer.parseInt(pageNo) : 1;
        int line = linesPerPage != null && linesPerPage.length() > 0 ? Integer.parseInt(linesPerPage) : 10;
        try {
            DataPackage query = this.billDefiDesignTimeService.query(moduleId, name, page, line);
            JSONObject result = new JSONObject();
            JSONArray array = new JSONArray();
            for (BillDefiVO bl : query.getDatas()) {
                JSONObject blJson = new JSONObject();
                blJson.put((Object)"id", (Object)bl.getId());
                blJson.put((Object)"name", (Object)bl.getName());
                array.add((Object)blJson);
            }
            result.put((Object)"pageNo", (Object)query.pageNo);
            result.put((Object)"linesPerPage", (Object)query.linesPerPage);
            result.put((Object)"rowCount", (Object)query.rowCount);
            result.put((Object)"data", (Object)array);
            return this.success("ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/modules/workflows/{flowId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u8be6\u60c5", notes="\u83b7\u53d6\u6d41\u7a0b\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="moduleId", value="\u6a21\u5757id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="flowId", value="\u6d41\u7a0bid", required=true, paramType="path", dataType="string")})
    public Resource getFlow(@PathVariable String flowId) {
        try {
            BillDefiVO bl = (BillDefiVO)this.billDefiDesignTimeService.findById(flowId);
            JSONObject result = new JSONObject();
            result.put((Object)"id", (Object)bl.getId());
            result.put((Object)"name", (Object)bl.getName());
            result.put((Object)"authorname", (Object)bl.getAuthorname());
            result.put((Object)"lastmodify", (Object)bl.getLastmodify());
            result.put((Object)"subject", (Object)bl.getSubject());
            result.put((Object)"flow", (Object)bl.getFlow());
            result.put((Object)"uri", (Object)bl.getUri());
            return this.success("ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/modules/workflows/copy"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u590d\u5236\u6d41\u7a0b", notes="\u590d\u5236\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource copyFlow(@RequestBody String[] ids) {
        try {
            this.billDefiDesignTimeService.doCopyFlow(ids);
            return this.success("ok", "\u590d\u5236\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/modules/workflows/{flowId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u6d41\u7a0b", notes="\u66f4\u65b0\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="flowId", value="\u6d41\u7a0bid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdate(@PathVariable String flowId, @RequestBody String content) {
        JSONObject json = JSONObject.fromObject((Object)content);
        try {
            BillDefiVO bl = (BillDefiVO)this.json2obj(json, BillDefiVO.class);
            Date lastmodify = new Date();
            bl.setId(flowId);
            bl.setLastmodify(lastmodify);
            bl.setCheckout(true);
            bl.setCheckoutHandler(this.getUser().getId());
            bl.setApplicationid((String)json.get("applicationId"));
            this.doSaveValidate(bl);
            this.billDefiDesignTimeService.doUpdate(bl);
            JSONObject blJson = new JSONObject();
            blJson.put((Object)"id", (Object)bl.getId());
            return this.success("ok", blJson);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/modules/workflows"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b", notes="\u5220\u9664\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource delete(@RequestBody String[] ids) {
        try {
            this.billDefiDesignTimeService.delete(ids);
            return this.success("ok", "\u5220\u9664\u6d41\u7a0b");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/modules/workflows/{flowId}/node/{nodeId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6839\u636e\u5f53\u524d\u8282\u70b9\u83b7\u53d6\u5176\u4ed6\u8282\u70b9", notes="\u6839\u636e\u5f53\u524d\u8282\u70b9\u83b7\u53d6\u5176\u4ed6\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="flowId", value="\u6d41\u7a0bid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="nodeId", value="\u8282\u70b9id", required=true, paramType="path", dataType="string")})
    public Resource getNodes(@PathVariable String flowId, @PathVariable String nodeId) {
        ParamsTable params = this.getParams();
        String type = params.getParameterAsString("type");
        try {
            BillDefiVO bl = (BillDefiVO)this.billDefiDesignTimeService.findById(flowId);
            Node node = bl.toFlowDiagram().getNodeByID(nodeId);
            Vector list = new Vector();
            if ("0".equals(type)) {
                list = bl.toFlowDiagram().getAllBeforeNode(node, true);
            }
            JSONArray array = new JSONArray();
            for (Element element : list) {
                ManualNode n = (ManualNode)element;
                JSONObject blJson = new JSONObject();
                blJson.put((Object)"id", (Object)n.id);
                blJson.put((Object)"name", (Object)n.name);
                array.add((Object)blJson);
            }
            return this.success("ok", array);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @GetMapping(path={"/{applicationId}/modules/workflows/flexGetForms"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6d41\u7a0b\u7f16\u8f91\u5668\u5b50\u6d41\u7a0b\u83b7\u53d6\u7236\u6d41\u7a0b\u8868\u5355", notes="\u6d41\u7a0b\u7f16\u8f91\u5668\u5b50\u6d41\u7a0b\u83b7\u53d6\u7236\u6d41\u7a0b\u8868\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="formName", value="\u540d\u79f0", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="moduleName", value="\u6a21\u5757\u540d\u79f0", required=false, paramType="query", dataType="string")})
    public Resource flexGetFormsByParams(@PathVariable String applicationId, String pageNo, String formName, String moduleName) {
        int page = pageNo != null && pageNo.length() > 0 ? Integer.parseInt(pageNo) : 1;
        JSONArray formArray = new JSONArray();
        JSONObject result = new JSONObject();
        try {
            DataPackage forms = this.formService.queryByApplicationIdAndModuleNameAndSubjectName(applicationId, moduleName, formName, page, 10);
            for (Form form : forms.datas) {
                JSONObject formJson = new JSONObject();
                formJson.put((Object)"id", (Object)form.getId());
                formJson.put((Object)"formName", (Object)form.getName());
                formJson.put((Object)"moduleName", (Object)form.getModule().getName());
                if (form.getAllFields().size() == 0) {
                    form.inited();
                }
                ArrayList formFields = new ArrayList();
                HashMap<String, String> nField = new HashMap<String, String>();
                nField.put("name", "--select--");
                nField.put("valuetype", "");
                formFields.add(nField);
                for (FormField field : form.getAllFields()) {
                    HashMap<String, String> formField = new HashMap<String, String>();
                    formField.put("name", field.getName());
                    formField.put("valuetype", field.getFieldtype() == null ? "" : field.getFieldtype());
                    formFields.add(formField);
                }
                formJson.put((Object)"formFields", formFields);
                formArray.add((Object)formJson);
            }
            result.put((Object)"linesPerPage", (Object)forms.getLinesPerPage());
            result.put((Object)"pageCount", (Object)forms.getPageCount());
            result.put((Object)"pageNo", (Object)forms.getPageNo());
            result.put((Object)"rowCount", (Object)forms.getRowCount());
            result.put((Object)"data", (Object)formArray);
            return this.success("ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/{applicationId}/modules/workflows/flexGetBillDefiVOs"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6d41\u7a0b\u7f16\u8f91\u5668\u83b7\u53d6\u6240\u6709\u6d41\u7a0b", notes="\u6d41\u7a0b\u7f16\u8f91\u5668\u83b7\u53d6\u6240\u6709\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="flowName", value="\u540d\u79f0", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="moduleName", value="\u6a21\u5757\u540d\u79f0", required=false, paramType="query", dataType="string")})
    public Resource flexGetBillDefiVOs(@PathVariable String applicationId, String pageNo, String flowName, String moduleName) {
        int page = pageNo != null && pageNo.length() > 0 ? Integer.parseInt(pageNo) : 1;
        JSONArray array = new JSONArray();
        JSONObject result = new JSONObject();
        try {
            DataPackage billDefiVOs = this.billDefiDesignTimeService.queryByApplicationIdAndModuleNameAndSubjectName(applicationId, moduleName, flowName, page, 10);
            for (BillDefiVO billDefiVO : billDefiVOs.datas) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put((Object)"id", (Object)billDefiVO.getId());
                jsonObject.put((Object)"flowName", (Object)billDefiVO.getName());
                jsonObject.put((Object)"moduleName", (Object)billDefiVO.getParent().getName());
                array.add((Object)jsonObject);
            }
            ModuleDesignTimeService moduleService = DesignTimeServiceManager.moduleDesignTimeService();
            List moduleDatas = moduleService.list(applicationId, null);
            ArrayList<String> modulearray = new ArrayList<String>();
            modulearray.add("");
            if (moduleDatas.size() > 0) {
                for (Module module : moduleDatas) {
                    modulearray.add(module.getName());
                }
            }
            result.put((Object)"linesPerPage", (Object)billDefiVOs.getLinesPerPage());
            result.put((Object)"pageCount", (Object)billDefiVOs.getPageCount());
            result.put((Object)"pageNo", (Object)billDefiVOs.getPageNo());
            result.put((Object)"rowCount", (Object)billDefiVOs.getRowCount());
            result.put((Object)"data", (Object)array);
            result.put((Object)"modulearray", modulearray);
            return this.success("ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    public void doSaveValidate(BillDefiVO bl) throws Exception {
        String subject = bl.getSubject();
        if (StringUtil.isBlank((String)subject)) {
            throw new OBPMValidateException("{*[workflow.subject.notempty]*}");
        }
        String invalidChars = this.getInvalidChars(subject);
        if (!StringUtil.isBlank((String)invalidChars)) {
            throw new OBPMValidateException("{*[workflow.subject.exist.invalidchar]*}: " + invalidChars);
        }
        this.validate(bl);
    }

    private String getInvalidChars(String name) {
        String[] p = new String[]{"\ufe49", "\uff03", "\uff20", "\uff06", "\uff0a", "\u203b", "\u00a7", "\u3003", "\u2116", "\u3013", "\u25cb", "\u25cf", "\u25b3", "\u25b2", "\u25ce", "\u2606", "\u2605", "\u25c7", "\u25c6", "\u25a0", "\u25a1", "\u25bc", "\u25bd", "\u32a3", "\u2105", "\u02c9", "\uffe3", "\uff3f", "\ufe4d", "\ufe4a", "\ufe4e", "\ufe4b", "\ufe4c", "\ufe5f", "\ufe60", "\ufe61", "\u2640", "\u2642", "?", "\u2299", "\u2191", "\u2193", "\u2190", "\u2192", "\u2196", "\u2197", "\u2199", "\u2198", "\u2504", "\u2014", "\ufe34", "\ufe4f", "\uff08", "\uff09", "\ufe35", "\ufe36", "\uff5b", "\uff5d", "\ufe37", "\ufe38", "\u3014", "\u3015", "\ufe39", "\ufe3a", "\u3010", "\u3011", "\ufe3b", "\ufe3c", "\u300a", "\u300b", "\ufe3d", "\ufe3e", "\u3008", "\u3009", "\ufe3f", "\ufe40", "\u300c", "\u300d", "\ufe41", "\ufe42", "\u300e", "\u300f", "\ufe43", "\ufe44", "\ufe59", "\ufe5a", "\ufe5b", "\ufe5c", "\ufe5d", "\ufe5e", "\"", "\u301d", "\u301e", "\u02cb", "\u02ca", "\u2248", "\u2261", "\u2260", "\uff1d", "\u2264", "\u2265", "\uff1c", "\uff1e", "\u226e", "\u226f", "\u2237", "\u00b1", "\uff0b", "\uff0d", "\u00d7", "\u00f7", "\uff0f", "\u222b", "\u222e", "\u221d", "\u2227", "\u2228", "\u221e", "\u2211", "\u220f", "\u222a", "\u2229", "\u2208", "\u2235", "\u2234", "\u22a5", "\u2225", "\u2220", "\u2312", "\u2299", "\u224c", "\u223d", "\u221a", "\u2266", "\u2267", "\u2252", "\u2261", "\ufe62", "\ufe63", "\ufe64", "\ufe65", "\ufe66", "\uff5e", "\u221f", "\u22bf", "\u2225", "\u33d2", "\u33d1", "\u2223", "\uff5c", "\ufe31", "\ufe33", "|", "\uff0f", "\uff3c", "\u2215", "\ufe68", "\u00a5", "\u20ac", "\uffe5", "\u00a3", "\u00ae", "\u2122", "\u00a9", "\uff0c", "\u3001", "\u3002", "\uff0e", "\uff1b", "\uff1a", "\uff1f", "\uff01", "\ufe30", "\u2026", "\u2025", "\u2032", "\u2035", "\u3005", "\uff5e", "\u2016", "\u02c7", "\u02c9", "\ufe50", "\ufe51", "\ufe52", "\u00b7", "\ufe54", "\ufe55", "\ufe56", "\ufe57", "-", "&", "*", "#", "`", "~", "+", "=", "(", ")", "^", "%", "$", "@", ";", ",", ":", "'", "\\", "/", ".", ">", "<", "?", "!", "[", "]", "{", "}"};
        for (int i = 0; i < p.length; ++i) {
            if (name == null || !name.contains(p[i])) continue;
            return p[i];
        }
        return "";
    }

    public void validate(BillDefiVO bl) throws Exception {
        List list = this.billDefiDesignTimeService.list(bl.getParentId(), bl.getName());
        if (StringUtils.isBlank((String)bl.getId())) {
            for (BillDefiVO billDefiVO : list) {
                if (!billDefiVO.getName().equals(bl.getName())) continue;
                throw new OBPMValidateException("{*[workflow.subject.exist]*}");
            }
        } else {
            for (BillDefiVO billDefiVO : list) {
                if (billDefiVO.getId().equals(bl.getId()) || !billDefiVO.getName().equals(bl.getName())) continue;
                throw new OBPMValidateException("{*[workflow.subject.exist]*}");
            }
        }
        for (BillDefiVO billDefiVO : list) {
            if (!billDefiVO.getName().equals(bl.getName()) || billDefiVO.getId().equals(bl.getId())) continue;
            throw new OBPMValidateException("{*[workflow.subject.exist]*}");
        }
    }
}

