/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.wizard.util;

import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.wizard.service.WizardVO;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.util.DbTypeUtil;
import cn.myapps.util.json.JsonTmpUtil;
import cn.myapps.util.sequence.Sequence;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.ezmorph.bean.MorphDynaBean;
import net.sf.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardUtil {
    public final String TEMPLATE_DIRECTORY = "/wizard/template";
    private static final Logger log = LoggerFactory.getLogger(WizardUtil.class);

    public String getF_TemplateContext(String f_fieldsDescription, String f_style, String contextBasePath) {
        Configuration configuration = new Configuration();
        ArrayList list = new ArrayList();
        HashMap<String, Object> content = new HashMap<String, Object>();
        try {
            configuration.setDirectoryForTemplateLoading(new File(this.getTemplateDirectory(contextBasePath)));
            Template template = configuration.getTemplate("step2_form_style.ftl");
            JSONArray obj = JsonTmpUtil.fromObject((Object)f_fieldsDescription);
            Collection collection = JSONArray.toCollection((JSONArray)obj);
            for (MorphDynaBean oj : collection) {
                HashMap<String, Object> f_templatecontext = new HashMap<String, Object>();
                f_templatecontext.put("fieldname", oj.get("fieldname"));
                f_templatecontext.put("fieldtype", oj.get("fieldtype"));
                f_templatecontext.put("fieldlength", oj.get("fieldlength"));
                f_templatecontext.put("fieldoption", oj.get("fieldoption"));
                f_templatecontext.put("fieldformat", oj.get("fieldformat"));
                f_templatecontext.put("fieldid", oj.get("fieldid"));
                Object fieldtype = oj.get("fieldtype");
                if ("06".equals(fieldtype)) {
                    f_templatecontext.put("numberpattern", oj.get("fieldformat"));
                } else if ("01".equals(fieldtype)) {
                    f_templatecontext.put("datepattern", oj.get("fieldformat"));
                }
                list.add(f_templatecontext);
                content.put("f_templatecontext", list);
            }
            content.put("f_style", f_style);
            StringWriter writer = new StringWriter();
            template.process(content, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getV_filter(String contextBasePath, WizardVO wizardVO, String formName) {
        Configuration configuration = new Configuration();
        ArrayList list = new ArrayList();
        HashMap<String, Object> content = new HashMap<String, Object>();
        try {
            configuration.setDirectoryForTemplateLoading(new File(this.getTemplateDirectory(contextBasePath)));
            Template template = configuration.getTemplate("step5_view_filter.ftl");
            JSONArray array = JsonTmpUtil.fromObject((Object)wizardVO.getV_filter());
            JSONArray arr = array.getJSONArray(0);
            String formId = array.getString(1);
            Collection collection = JSONArray.toCollection((JSONArray)arr);
            for (MorphDynaBean bean : collection) {
                HashMap<String, Object> v_filterCode = new HashMap<String, Object>();
                v_filterCode.put("fieldtype", bean.get("fieldtype"));
                v_filterCode.put("fieldname", bean.get("fieldname"));
                list.add(v_filterCode);
                content.put("fields", list);
            }
            content.put("formid", formId);
            content.put("filterpendding", wizardVO.isPending());
            content.put("formname", formName);
            StringWriter writer = new StringWriter();
            template.process(content, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getW_content(String contextBasePath, String w_content) {
        Configuration configuration = new Configuration();
        ArrayList list = new ArrayList();
        HashMap content = new HashMap();
        try {
            JSONArray array = JsonTmpUtil.fromObject((Object)w_content);
            String names = array.getString(0);
            String roles = array.getString(1);
            String type = array.getString(2);
            String nodeIds = array.getString(3);
            configuration.setDirectoryForTemplateLoading(new File(this.getTemplateDirectory(contextBasePath)));
            Template template = configuration.getTemplate(this.getWorkflowTemplate(type));
            String[] name = names.split(";");
            String[] role = roles.split(" ");
            String[] nodeId = null;
            if (nodeIds.length() > 0) {
                nodeId = nodeIds.split(";");
            }
            for (int i = 0; i < name.length; ++i) {
                HashMap<String, String> nodeInfo = new HashMap<String, String>();
                nodeInfo.put("nodeName", name[i]);
                nodeInfo.put("nodeRole", role[i]);
                if (nodeIds.length() > 0) {
                    nodeInfo.put("nodeId", nodeId[i]);
                }
                list.add(nodeInfo);
                content.put("nodeInfo", list);
            }
            StringWriter writer = new StringWriter();
            template.process(content, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getV_searchForm(String v_searchForm, String contextBasePath) {
        Configuration configuration = new Configuration();
        ArrayList list = new ArrayList();
        HashMap content = new HashMap();
        try {
            configuration.setDirectoryForTemplateLoading(new File(this.getTemplateDirectory(contextBasePath)));
            Template template = configuration.getTemplate("step5_view_searchform.ftl");
            JSONArray array = JsonTmpUtil.fromObject((Object)v_searchForm);
            Collection collection = JSONArray.toCollection((JSONArray)array);
            for (MorphDynaBean bean : collection) {
                HashMap<String, Object> v_filter = new HashMap<String, Object>();
                v_filter.put("fieldtype", bean.get("fieldtype"));
                v_filter.put("fieldid", bean.get("fieldid"));
                v_filter.put("fieldname", bean.get("fieldname"));
                list.add(v_filter);
                content.put("v_searchForm", list);
            }
            StringWriter writer = new StringWriter();
            template.process(content, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getWorkflowTemplate(String workflowType) {
        StringBuffer templatePath = new StringBuffer();
        templatePath.append("step3_workflow_").append(workflowType).append(".ftl");
        return templatePath.toString();
    }

    public String getTemplateDirectory(String contextBasePath) {
        return contextBasePath.concat("/wizard/template");
    }

    public String getUpdatedTemplateContext(WizardVO vo, String contextBasePath) {
        Configuration configuration = new Configuration();
        try {
            configuration.setDirectoryForTemplateLoading(new File(this.getTemplateDirectory(contextBasePath)));
            Template template = configuration.getTemplate("step2_form_style_md.ftl");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("viewid", vo.getF_subForm_viewid());
            map.put("moduleid", vo.getModuleid());
            map.put("includefieldid", Sequence.getDesignTimeSequence());
            map.put("subName", vo.getF_name_sub());
            StringWriter writer = new StringWriter();
            template.process(map, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String validateForm(String formName, String mainFormName, String application) throws Exception {
        FormDesignTimeService process = DesignTimeServiceManager.formDesignTimeService();
        Form form = process.doViewByFormName(formName, application);
        String regex = "^[a-zA-Z]{1}\\w*$";
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(formName);
        String dbType = DbTypeUtil.getDBType((String)application);
        if (dbType != null && dbType.equals("DB2") && !matcher.find()) {
            return "db2";
        }
        if (form == null) {
            if (mainFormName != null && formName.equals(mainFormName)) {
                return "yes";
            }
            return "no";
        }
        return "yes";
    }

    public static void main(String[] args) {
        String w_content = "['1;2;3','(R01b87b98-68d1-9620-9054-15b2ccd1308d|\u5458\u5de5;) (R01b87b98-a31e-3540-9bdd-1ec2928ffec0|\u7ecf\u7406;) (R01b87b98-cc31-0a20-b5ce-8a120f1a2245|\u8001\u603b;)','01','1249293724500;1249293724515;1249293724531;']";
        String basePath = "E:\\workspace3.4\\obpm\\src\\main\\webapp\\";
        WizardUtil util = new WizardUtil();
        log.debug("{}", (Object)util.getW_content(basePath, w_content));
    }
}

