/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.validate.controller;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.validaterepository.ValidateRepositoryVO;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.validate.repository.service.ValidateRepositoryDesignTimeService;
import cn.myapps.util.StringUtil;
import cn.myapps.util.sequence.Sequence;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u68c0\u9a8c\u5e93\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime/applications"}, produces={"application/json;charset=UTF-8"})
public class ValidatesController
extends AbstractDesignTimeController {
    private ValidateRepositoryDesignTimeService validateRepositoryDesignTimeService = DesignTimeServiceManager.validateRepositoryDesignTimeService();

    @GetMapping(path={"/{applicationId}/validates"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u68c0\u9a8c\u5e93\u5217\u8868", notes="\u83b7\u53d6\u68c0\u9a8c\u5e93\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="linesPerPage", value="\u9875\u6761\u6570", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="name", value="\u68c0\u9a8c\u5e93\u540d\u79f0", required=true, paramType="path", dataType="string")})
    public Resource getValidatesList(@PathVariable String applicationId, String name, String pageNo, String linesPerPage) {
        int page = pageNo != null && pageNo.length() > 0 ? Integer.parseInt(pageNo) : 1;
        int line = linesPerPage != null && linesPerPage.length() > 0 ? Integer.parseInt(linesPerPage) : 10;
        try {
            DataPackage data = this.validateRepositoryDesignTimeService.query(applicationId, name, page, line);
            return this.success("ok", data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/{applicationId}/validates/{validId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6837\u5f0f\u5e93\u8be6\u60c5", notes="\u83b7\u53d6\u6837\u5f0f\u5e93\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="validId", value="\u68c0\u9a8c\u5e93id", required=true, paramType="path", dataType="string")})
    public Resource doGetValidate(@PathVariable String applicationId, @PathVariable String validId) throws Exception {
        try {
            ValidateRepositoryVO validate = (ValidateRepositoryVO)this.validateRepositoryDesignTimeService.findById(validId);
            return this.success("ok", validate);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/validates"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u65b0\u5efa\u68c0\u9a8c\u5e93", notes="\u65b0\u5efa\u68c0\u9a8c\u5e93")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateValidates(@PathVariable String applicationId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            ValidateRepositoryVO rv = (ValidateRepositoryVO)this.json2obj(json, ValidateRepositoryVO.class);
            rv.setApplicationid(applicationId);
            rv.setParentId(applicationId);
            if (StringUtil.isBlank((String)rv.getId())) {
                rv.setId(Sequence.getDesignTimeSequence());
            }
            this.doSaveValidate(rv);
            this.validateRepositoryDesignTimeService.save((Object)rv);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"id", (Object)rv.getId());
            return this.success("ok", jsonObject);
        }
        catch (OBPMValidateException ex) {
            ex.printStackTrace();
            return this.error(40001, ex.getValidateMessage(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/{applicationId}/validates/{validId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u68c0\u9a8c\u5e93", notes="\u66f4\u65b0\u68c0\u9a8c\u5e93")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="validId", value="\u68c0\u9a8c\u5e93id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdateValidates(@PathVariable String applicationId, @PathVariable String validId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            ValidateRepositoryVO rv = (ValidateRepositoryVO)this.json2obj(json, ValidateRepositoryVO.class);
            ValidateRepositoryVO oldValidate = (ValidateRepositoryVO)this.validateRepositoryDesignTimeService.findById(validId);
            ValidateRepositoryVO validate = (ValidateRepositoryVO)BeanUtils.cloneBean((Object)oldValidate);
            validate.setApplicationid(applicationId);
            validate.setContent(rv.getContent());
            validate.setName(rv.getName());
            validate.setDescription(rv.getDescription());
            this.doSaveValidate(validate);
            this.validateRepositoryDesignTimeService.saveOrUpdate((Object)validate);
            return this.success("ok", null);
        }
        catch (OBPMValidateException ex) {
            ex.printStackTrace();
            return this.error(40001, ex.getValidateMessage(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/{applicationId}/validates"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u68c0\u9a8c\u5e93", notes="\u5220\u9664\u68c0\u9a8c\u5e93\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doDeleteValidates(@RequestBody String[] ids) throws Exception {
        try {
            this.validateRepositoryDesignTimeService.delete(ids);
            return this.success("ok", "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    private void doSaveValidate(ValidateRepositoryVO repositoryVO) throws Exception {
        boolean exist = this.validateRepositoryDesignTimeService.isValidateNameExist(repositoryVO.getId(), repositoryVO.getName(), repositoryVO.getApplicationid());
        if (exist) {
            throw new OBPMValidateException(" \u5e93\u540d\u79f0\u91cd\u590d ,\u8bf7\u91cd\u65b0\u547d\u540d\u518d\u4fdd\u5b58\uff01 ");
        }
    }
}

