/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.task.controller;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.ValueObject;
import cn.myapps.common.model.task.Task;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.task.service.TaskDesignTimeService;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.scheduler.ejb.TriggerProcess;
import cn.myapps.runtime.scheduler.ejb.TriggerVO;
import cn.myapps.runtime.scheduler.engine.job.IscriptTaskJob;
import cn.myapps.runtime.scheduler.engine.job.Job;
import cn.myapps.util.StringUtil;
import cn.myapps.util.sequence.Sequence;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u4efb\u52a1\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime/applications"}, produces={"application/json;charset=UTF-8"})
public class TaskController
extends AbstractDesignTimeController {
    private TaskDesignTimeService taskDesignTimeService = DesignTimeServiceManager.taskDesignTimeService();

    @GetMapping(path={"/{applicationId}/tasks"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u5217\u8868", notes="\u83b7\u53d6\u4efb\u52a1\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="linesPerPage", value="\u9875\u6761\u6570", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="searchword", value="\u540d\u5b57", required=true, paramType="query", dataType="string")})
    public Resource getTasksList(@PathVariable String applicationId, String searchword) {
        ParamsTable params = this.getParams();
        String pageNo = params.getParameterAsString("pageNo");
        String linesPerPage = params.getParameterAsString("linesPerPage");
        int page = pageNo != null && pageNo.length() > 0 ? Integer.parseInt(pageNo) : 1;
        int line = linesPerPage != null && linesPerPage.length() > 0 ? Integer.parseInt(linesPerPage) : 10;
        try {
            DataPackage data = this.taskDesignTimeService.queryByNameOrDescript(applicationId, searchword, page, line);
            return this.success("ok", data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/tasks/{taskId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u8be6\u60c5", notes="\u83b7\u53d6\u4efb\u52a1\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="path", dataType="string")})
    public Resource doGetTask(@PathVariable String taskId) throws Exception {
        try {
            Task task = (Task)this.taskDesignTimeService.findById(taskId);
            return this.success("ok", task);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/tasks"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u65b0\u5efa\u4efb\u52a1", notes="\u65b0\u5efa\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="rTime", value="\u8fd0\u884c\u65f6\u95f4", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="rDate", value="\u8fd0\u884c\u65e5\u671f", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateTasks(@PathVariable String applicationId, @RequestBody String content, @RequestParam(required=false, defaultValue="0") int runState, @RequestParam String rTime, @RequestParam String rDate) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            Task task = (Task)this.json2obj(json, Task.class);
            task.setrTime(rTime);
            task.setrDate(rDate);
            this.setDate(task, rTime, rDate);
            task.setApplicationid(applicationId);
            task.setParentId(applicationId);
            JSONArray array = (JSONArray)json.get("daysOfWeek");
            ArrayList<Integer> dayOfWeek = new ArrayList<Integer>();
            if (!array.isEmpty()) {
                for (int i = 0; i < array.size(); ++i) {
                    dayOfWeek.add(array.getInt(i));
                }
            }
            task.setDaysOfWeek(dayOfWeek);
            task.setDayOfMonth(1);
            if (StringUtil.isBlank((String)task.getId())) {
                task.setId(Sequence.getDesignTimeSequence());
            }
            if (task.getName().equals("")) {
                throw new OBPMValidateException("{*[page.name.notexist]*}");
            }
            String regEx = "[ \\~\\!\\/\\@\\#\\$\\%\\^\\&\\*\\(\\)\\-\\=\\+\\\\\\|\\[\\{\\}\\]\\;\\:\\'\\\"\\,\\<\\.\\>\\/\\?]";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(task.getName());
            if (m.find()) {
                throw new OBPMValidateException("{*[Name]*}{*[can.not.exist.invalidchar]*}");
            }
            task.setModifyTime(new Date());
            if (this.exist(task).booleanValue()) {
                throw new OBPMValidateException("\u4efb\u52a1\u540d\u79f0\u5df2\u5b58\u5728!");
            }
            this.taskDesignTimeService.save((Object)task);
            this.insertOrUpdate(task);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"id", (Object)task.getId());
            jsonObject.put((Object)"runState", (Object)runState);
            return this.success("ok", jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/tasks"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u4efb\u52a1", notes="\u66f4\u65b0\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdateTasks(@RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            String applicationId = (String)json.get("appId");
            Task task = (Task)this.json2obj(json, Task.class);
            JSONArray array = (JSONArray)json.get("daysOfWeek");
            ArrayList<Integer> dayOfWeek = new ArrayList<Integer>();
            if (!array.isEmpty()) {
                for (int i = 0; i < array.size(); ++i) {
                    dayOfWeek.add(array.getInt(i));
                }
            }
            String rTime = json.getString("rTime");
            String rDate = json.getString("rDate");
            if ("null".equalsIgnoreCase(rDate)) {
                rDate = null;
            }
            if ("null".equalsIgnoreCase(rTime)) {
                rTime = null;
            }
            task.setrTime(rTime);
            task.setrDate(rDate);
            this.setDate(task, rTime, rDate);
            task.setApplicationid(applicationId);
            task.setParentId(applicationId);
            task.setDaysOfWeek(dayOfWeek);
            this.taskDesignTimeService.saveOrUpdate((Object)task);
            this.insertOrUpdate(task);
            return this.success("ok", task);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/{applicationId}/tasks"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u4efb\u52a1", notes="\u5220\u9664\u4efb\u52a1\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doDeleteTasks(@PathVariable String applicationId, @RequestBody String[] ids) throws Exception {
        try {
            TriggerProcess triggerProcess = RunTimeServiceManager.triggerProcess((String)applicationId);
            for (String id : ids) {
                String token = TriggerVO.generateIscriptTaskJobToken((String)id);
                triggerProcess.removeByToken(token);
            }
            this.taskDesignTimeService.delete(ids);
            return this.success("ok", "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    public int doStart(String id, String rTime, String rDate) {
        try {
            Task task = (Task)this.taskDesignTimeService.findById(id);
            task.setState(1);
            this.setDate(task, rTime, rDate);
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @PutMapping(value={"/task/start"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u8fd0\u884c\u4efb\u52a1", notes="\u8fd0\u884c\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u4efb\u52a1id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="rTime", value="\u8fd0\u884c\u65f6\u95f4", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="rDate", value="\u8fd0\u884c\u65e5\u671f", required=true, paramType="query", dataType="string")})
    public Resource startTask(String id, String rTime, String rDate) throws Exception {
        try {
            this.doStart(id, rTime, rDate);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"runState", (Object)1);
            jsonObject.put((Object)"msg", (Object)"\u5b9a\u65f6\u4efb\u52a1\u5df2\u7ecf\u542f\u52a8");
            return this.success("ok", jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(value={"/task/stop"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u505c\u6b62\u4efb\u52a1", notes="\u505c\u6b62\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u4efb\u52a1id", required=true, paramType="query", dataType="string")})
    public Resource stopToTask(String id) throws Exception {
        try {
            Task task = (Task)this.taskDesignTimeService.findById(id);
            this.stopTask(task);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"runState", (Object)0);
            jsonObject.put((Object)"msg", (Object)"\u4efb\u52a1\u5df2\u7ecf\u505c\u6b62");
            return this.success("ok", jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    private Boolean exist(Task task) throws Exception {
        String id = task.getId();
        List tasks = this.taskDesignTimeService.list(task.getApplicationid(), null);
        if (StringUtils.isBlank((String)id)) {
            for (Task t : tasks) {
                if (!t.getName().equals(task.getName())) continue;
                return true;
            }
        } else {
            for (Task t : tasks) {
                if (task.getId().equals(t.getId()) || !t.getName().equals(task.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private int stopTask(Task task) {
        int runState = 0;
        try {
            String token = TriggerVO.generateIscriptTaskJobToken((String)task.getId());
            task.setState(runState);
            this.taskDesignTimeService.doCumulativeTask(task);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return runState;
    }

    private void setDate(Task task, String rTime, String rDate) throws Exception {
        Date date = new Date();
        try {
            int period = task.getPeriod();
            if (period == 2 || period == 32 || period == 512) {
                SimpleDateFormat formater = new SimpleDateFormat();
                formater.applyPattern("HH:mm:ss");
                if ("".equals(rTime)) {
                    throw new OBPMValidateException("{*[core.task.choosetime]*}");
                }
                String dateStr = rTime;
                date = formater.parse(dateStr);
                Calendar c = Calendar.getInstance();
                c.set(11, date.getHours());
                c.set(12, date.getMinutes());
                c.set(13, date.getSeconds());
                date = c.getTime();
            } else if (period == 0) {
                if (rDate.equals("")) {
                    throw new OBPMValidateException("{*[cn.myapps.core.task.select_running_time]*}");
                }
                if (rTime.equals("")) {
                    throw new OBPMValidateException("{*[core.task.choosetime]*}");
                }
                String dateStr = rDate + " " + rTime;
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                date = formatter.parse(dateStr);
            } else if (period == 34 || period == 546) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                date = formatter.parse(formatter.format(date));
            } else {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                date = formatter.parse(formatter.format(date));
            }
        }
        catch (OBPMValidateException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        task.setRunningTime(date);
    }

    private void insertOrUpdate(Task task) throws Exception {
        TriggerProcess triggerProcess = RunTimeServiceManager.triggerProcess((String)task.getApplicationid());
        TriggerVO trigger = (TriggerVO)triggerProcess.selectByToken(TriggerVO.generateIscriptTaskJobToken((String)task.getId()));
        if (task.getStartupType() != 2 && trigger != null) {
            Calendar calendar = Calendar.getInstance();
            IscriptTaskJob job = new IscriptTaskJob(task.getId(), !cn.myapps.common.util.StringUtil.isBlank((String)task.getApplicationid()) ? task.getApplicationid() : trigger.getApplicationId());
            if (task.getPeriod() == 0 || task.getPeriod() == 0 || task.getPeriod() == 8192) {
                job.setLoop(false);
            } else {
                job.setLoop(true);
            }
            TriggerVO newTrigger = new TriggerVO((Job)job, calendar.getTimeInMillis());
            trigger.setJobData(newTrigger.getJobData());
            trigger.setDeadline(trigger.getDeadline());
            trigger.setLastModifyDate(task.getModifyTime());
            trigger.setState("waiting");
            triggerProcess.doUpdate((ValueObject)trigger);
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(task.getRunningTime());
            IscriptTaskJob job = new IscriptTaskJob(task.getId(), task.getApplicationid());
            if (task.getPeriod() == 0 || task.getPeriod() == 0 || task.getPeriod() == 8192) {
                job.setLoop(false);
            } else {
                job.setLoop(true);
            }
            trigger = new TriggerVO((Job)job, calendar.getTimeInMillis());
            trigger.setId(Sequence.getSequence());
            trigger.setApplicationId(task.getApplicationid());
            trigger.setLastModifyDate(task.getModifyTime());
            trigger.setRunTimes(0);
            trigger.setTaskId(task.getId());
            if (task.getStartupType() != 1) {
                trigger.setState("stop");
            }
            triggerProcess.doCreate((ValueObject)trigger);
        }
    }
}

