/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.superuser.controller;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.Environment;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.util.Security;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import com.bcxin.saas.core.exceptions.SaasUnAuthorizeException;
import com.jayway.jsonpath.JsonPath;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u5f00\u53d1\u8005\u8bbe\u8ba1\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime/applications"}, produces={"application/json;charset=UTF-8"})
public class SuperUserController
extends AbstractDesignTimeController {
    SuperUserDesignTimeService superUserProcess = DesignTimeServiceManager.superUserDesignTimeService();
    ApplicationDesignTimeService appService = DesignTimeServiceManager.applicationDesignTimeService();

    @GetMapping(path={"/{applicationId}/superusers/join"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u5df2\u52a0\u5165\u8f6f\u4ef6\u7684\u5f00\u53d1\u8005\u5217\u8868", notes="\u83b7\u53d6\u5df2\u52a0\u5165\u8f6f\u4ef6\u7684\u5f00\u53d1\u8005\u5217\u8868\uff08\u53ef\u6839\u636e\u540d\u5b57\u6216\u8005\u8d26\u53f7\u67e5\u8be2\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="name", value="\u67e5\u8be2\u540d\u79f0", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="loginno", value="\u67e5\u8be2\u8d26\u53f7", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u5f53\u524d\u9875\u6570", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="linesPerPage", value="\u6bcf\u9875\u884c\u6570", required=false, paramType="query", dataType="string")})
    public Resource doGetJoinDeveloperList(@PathVariable String applicationId, @RequestParam(required=false) String name, @RequestParam(required=false) String loginno, @RequestParam(required=false) String pageNo, @RequestParam(required=false) String linesPerPage) throws Exception {
        int page = pageNo != null && pageNo.length() > 0 ? Integer.parseInt(pageNo) : 1;
        int line = linesPerPage != null && linesPerPage.length() > 0 ? Integer.parseInt(linesPerPage) : 10;
        try {
            ParamsTable params = this.getParams();
            params.setParameter("id", (Object)applicationId);
            params.setParameter("sm_name", (Object)name);
            params.setParameter("sm_loginno", (Object)loginno);
            params.setParameter("_currpage", (Object)page);
            params.setParameter("_pagelines", (Object)line);
            DataPackage superUsers = this.superUserProcess.getJoinedDeveloperList(params);
            return this.success("ok", superUsers);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/{applicationId}/superusers/unjoin"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u672a\u52a0\u5165\u8f6f\u4ef6\u7684\u5f00\u53d1\u8005\u5217\u8868", notes="\u83b7\u53d6\u672a\u52a0\u5165\u8f6f\u4ef6\u7684\u5f00\u53d1\u8005\u5217\u8868\uff08\u53ef\u6839\u636e\u540d\u5b57\u6216\u8005\u8d26\u53f7\u67e5\u8be2\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="name", value="\u67e5\u8be2\u540d\u79f0", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="loginno", value="\u67e5\u8be2\u8d26\u53f7", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u5f53\u524d\u9875\u6570", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="linesPerPage", value="\u6bcf\u9875\u884c\u6570", required=false, paramType="query", dataType="string")})
    public Resource doGetUnjoinDeveloperList(@PathVariable String applicationId, @RequestParam(required=false) String name, @RequestParam(required=false) String loginno, @RequestParam(required=false) String pageNo, @RequestParam(required=false) String linesPerPage) throws Exception {
        int page = pageNo != null && pageNo.length() > 0 ? Integer.parseInt(pageNo) : 1;
        int line = linesPerPage != null && linesPerPage.length() > 0 ? Integer.parseInt(linesPerPage) : 10;
        try {
            ParamsTable params = this.getParams();
            params.setParameter("id", (Object)applicationId);
            params.setParameter("sm_name", (Object)name);
            params.setParameter("sm_loginno", (Object)loginno);
            params.setParameter("_currpage", (Object)page);
            params.setParameter("_pagelines", (Object)line);
            DataPackage superUsers = this.superUserProcess.getUnjoinedDeveloperList(params);
            return this.success("ok", superUsers);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/superusers"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u6dfb\u52a0\u5f00\u53d1\u8005", notes="\u6dfb\u52a0\u5f00\u53d1\u8005\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doAddDeveloper(@PathVariable String applicationId, @RequestBody String content) throws Exception {
        try {
            List ids = (List)JsonPath.parse((String)content).json();
            String[] idArray = new String[]{};
            idArray = ids.toArray(idArray);
            if (idArray != null && idArray.length > 0) {
                for (int i = 0; i < idArray.length; ++i) {
                    SuperUserVO su = this.superUserProcess.doView(idArray[i]);
                    if (su == null) continue;
                    ArrayList<String> apps = su.getApplications();
                    if (apps == null) {
                        apps = new ArrayList<String>();
                    }
                    apps.add(applicationId);
                    su.setApplications(apps);
                    this.superUserProcess.doUpdate(su);
                }
            }
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/{applicationId}/superusers"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u79fb\u9664\u5f00\u53d1\u8005", notes="\u79fb\u9664\u5f00\u53d1\u8005\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doRemoveDeveloper(@PathVariable String applicationId, @RequestBody String content) throws Exception {
        try {
            List ids = (List)JsonPath.parse((String)content).json();
            String[] idArray = new String[]{};
            idArray = ids.toArray(idArray);
            if (idArray != null && idArray.length > 0) {
                for (int i = 0; i < idArray.length; ++i) {
                    SuperUserVO su = this.superUserProcess.doView(idArray[i]);
                    if (su == null) continue;
                    Collection apps = su.getApplications();
                    Iterator it = apps.iterator();
                    while (it.hasNext()) {
                        if (!applicationId.equals(it.next())) continue;
                        it.remove();
                    }
                    this.superUserProcess.doUpdate(su);
                }
            }
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/getSuperuser"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u7279\u6743\u7528\u6237\u4fe1\u606f", notes="\u83b7\u53d6\u7279\u6743\u7528\u6237\u4fe1\u606f")
    public Resource getSuperUser() {
        SuperUserDesignTimeService sprocess = DesignTimeServiceManager.superUserDesignTimeService();
        String userId = Security.getDesignerIdFromToken((HttpServletRequest)this.request);
        JSONObject user = new JSONObject();
        try {
            WebUser webUser = sprocess.getWebUserInstance(userId);
            if (webUser == null) {
                throw new SaasUnAuthorizeException(String.format("\u7528\u6237\u4fe1\u606f\u65e0\u6548(userId=%s;)", userId));
            }
            user.put((Object)"id", (Object)webUser.getId());
            user.put((Object)"name", (Object)webUser.getName());
            user.put((Object)"loginno", (Object)webUser.getLoginno());
            user.put((Object)"loginpwd", (Object)webUser.getLoginpwd());
            user.put((Object)"email", (Object)webUser.getEmail());
            user.put((Object)"license", (Object)Environment.licenseType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.success("ok", user);
    }

    @PutMapping(path={"/superuser/{userId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u4fee\u6539\u7279\u6743\u7528\u6237\u4fe1\u606f", notes="\u4fee\u6539\u7279\u6743\u7528\u6237\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource updateSuperUser(@RequestBody String content, @PathVariable String userId) {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            SuperUserVO superUserVO = this.superUserProcess.doView(userId);
            superUserVO.setName((String)json.get("name"));
            superUserVO.setEmail((String)json.get("email"));
            superUserVO.setLoginno((String)json.get("loginno"));
            String loginPw = (String)json.get("loginpwd");
            if (!loginPw.equals("888888qqqq")) {
                superUserVO.setLoginpwd(Security.encryptPassword((String)loginPw));
            }
            this.superUserProcess.doPersonalUpdate(superUserVO);
            return this.success("ok", superUserVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }
}

