/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.summary.controller;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.summary.SummaryCfgVO;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.summary.service.SummaryCfgDesignTimeService;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.util.StringUtil;
import cn.myapps.util.sequence.Sequence;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u8868\u5355\u6458\u8981\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime/applications"}, produces={"application/json;charset=UTF-8"})
public class SummaryController
extends AbstractDesignTimeController {
    private SummaryCfgDesignTimeService summaryCfgVODesignTimeService = DesignTimeServiceManager.summaryCfgDesignTimeService();
    private FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();

    @GetMapping(path={"/{applicationId}/summarys"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u6458\u8981\u5217\u8868", notes="\u83b7\u53d6\u8868\u5355\u6458\u8981\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="scope", value="\u6458\u8981\u7c7b\u578b", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="linesPerPage", value="\u9875\u6761\u6570", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="formId", value="\u8868\u5355id", required=true, paramType="query", dataType="string")})
    public Resource getSummarysList(@PathVariable String applicationId, String scope, String formId, String pageNo, String linesPerPage) {
        int page = pageNo != null && pageNo.length() > 0 ? Integer.parseInt(pageNo) : 1;
        int line = linesPerPage != null && linesPerPage.length() > 0 ? Integer.parseInt(linesPerPage) : 10;
        try {
            DataPackage data = null;
            if (!StringUtil.isBlank((String)formId)) {
                data = this.summaryCfgVODesignTimeService.query(formId, null, page, line);
            } else {
                data = new DataPackage();
                data.setDatas(this.summaryCfgVODesignTimeService.doQueryByApplication(applicationId));
                data.setRowCount(data.getDatas().size());
                data.setPageNo(page);
                data.setLinesPerPage(line);
            }
            JSONObject result = new JSONObject();
            JSONArray array = new JSONArray();
            for (SummaryCfgVO summaryCfgVO : data.getDatas()) {
                Form form;
                if (!StringUtil.isBlank((String)scope) && summaryCfgVO.getScope() != Integer.valueOf(scope).intValue()) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put((Object)"id", (Object)summaryCfgVO.getId());
                jsonObject.put((Object)"name", (Object)summaryCfgVO.getTitle());
                jsonObject.put((Object)"type", (Object)summaryCfgVO.getType());
                jsonObject.put((Object)"title", (Object)summaryCfgVO.getTitle());
                jsonObject.put((Object)"uri", (Object)summaryCfgVO.getUri());
                jsonObject.put((Object)"fieldNames", (Object)summaryCfgVO.getFieldNames());
                jsonObject.put((Object)"summaryScript", (Object)summaryCfgVO.getSummaryScript());
                jsonObject.put((Object)"scope", (Object)summaryCfgVO.getScope());
                jsonObject.put((Object)"formId", (Object)summaryCfgVO.getFormId());
                jsonObject.put((Object)"isShowTags", (Object)summaryCfgVO.getIsShowTags());
                if (summaryCfgVO.getFormId() != null && (form = this.formService.doView(summaryCfgVO.getFormId())) != null) {
                    jsonObject.put((Object)"formName", (Object)form.getName());
                }
                array.add((Object)jsonObject);
            }
            result.put((Object)"linesPerPage", (Object)data.getLinesPerPage());
            result.put((Object)"pageCount", (Object)data.getPageCount());
            result.put((Object)"pageNo", (Object)data.getPageNo());
            result.put((Object)"rowCount", (Object)data.getRowCount());
            result.put((Object)"data", (Object)array);
            return this.success("ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/summarys/{summaryId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u6458\u8981\u8be6\u60c5", notes="\u83b7\u53d6\u8868\u5355\u6458\u8981\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="summaryId", value="\u8868\u5355\u6458\u8981id", required=true, paramType="path", dataType="string")})
    public Resource doGetSummary(@PathVariable String summaryId) {
        try {
            SummaryCfgVO summaryCfgVO = (SummaryCfgVO)this.summaryCfgVODesignTimeService.findById(summaryId);
            return this.success("ok", summaryCfgVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/summarys"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u65b0\u5efa\u8868\u5355\u6458\u8981", notes="\u65b0\u5efa\u8868\u5355\u6458\u8981")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateSummarys(@PathVariable String applicationId, @RequestBody String content) {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            SummaryCfgVO summaryCfgVO = (SummaryCfgVO)this.json2obj(json, SummaryCfgVO.class);
            summaryCfgVO.setApplicationid(applicationId);
            summaryCfgVO.setName(summaryCfgVO.getTitle());
            if (StringUtil.isBlank((String)summaryCfgVO.getId())) {
                summaryCfgVO.setId(Sequence.getDesignTimeSequence());
            }
            if (summaryCfgVO.getName() == null || summaryCfgVO.getName().equals("")) {
                throw new OBPMValidateException("{*[page.name.notexist]*}");
            }
            String regEx = "[ \\~\\!\\/\\@\\#\\$\\%\\^\\&\\*\\(\\)\\-\\=\\+\\\\\\|\\[\\{\\}\\]\\;\\:\\'\\\"\\,\\<\\.\\>\\/\\?]";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(summaryCfgVO.getName());
            if (m.find()) {
                throw new OBPMValidateException("{*[Name]*}{*[can.not.exist.invalidchar]*}");
            }
            this.doSaveValidate(summaryCfgVO);
            this.summaryCfgVODesignTimeService.save((Object)summaryCfgVO);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"id", (Object)summaryCfgVO.getId());
            return this.success("ok", jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/summarys"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u8868\u5355\u6458\u8981", notes="\u66f4\u65b0\u8868\u5355\u6458\u8981")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdateSummarys(@RequestBody String content) {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            SummaryCfgVO summaryCfgVO = (SummaryCfgVO)this.json2obj(json, SummaryCfgVO.class);
            this.doSaveValidate(summaryCfgVO);
            this.summaryCfgVODesignTimeService.saveOrUpdate((Object)summaryCfgVO);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/summarys"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u8868\u5355\u6458\u8981", notes="\u5220\u9664\u8868\u5355\u6458\u8981\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doDeleteSummarys(@RequestBody String[] ids) {
        try {
            this.summaryCfgVODesignTimeService.delete(ids);
            return this.success("ok", "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    private void doSaveValidate(SummaryCfgVO summaryCfgVO) throws Exception {
        List list = this.summaryCfgVODesignTimeService.list(summaryCfgVO.getParentId(), summaryCfgVO.getName());
        if (StringUtils.isBlank((String)summaryCfgVO.getId())) {
            for (SummaryCfgVO r : list) {
                if (!r.getName().equals(summaryCfgVO.getName())) continue;
                throw new OBPMValidateException("\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff01");
            }
        } else {
            for (SummaryCfgVO r : list) {
                if (r.getId().equals(summaryCfgVO.getId()) || !r.getName().equals(summaryCfgVO.getName())) continue;
                throw new OBPMValidateException("\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff01");
            }
        }
        List summaryCfgVOList = this.summaryCfgVODesignTimeService.list(summaryCfgVO.getParentId(), null);
        if (summaryCfgVO.getScope() == 0) {
            for (SummaryCfgVO summary : summaryCfgVOList) {
                if (summary.getScope() != 0 || summary.getId().equals(summaryCfgVO.getId())) continue;
                throw new OBPMValidateException("\u5f85\u529e\u6458\u8981\u5df2\u7ecf\u5b58\u5728\uff01");
            }
        }
    }
}

