/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.role.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.model.role.Role;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.role.service.RoleDesignTimeService;
import cn.myapps.util.sequence.Sequence;
import com.jayway.jsonpath.JsonPath;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import net.sf.json.JSONObject;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@RequestMapping(value={"/api/designtime"})
@Scope(value="prototype")
public class RoleDesignTimeController
extends AbstractDesignTimeController {
    private RoleDesignTimeService roleService = AuthTimeServiceManager.roleRuntimeService();

    @GetMapping(value={"/applications/{applicationId}/roles"})
    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5217\u8868\uff08\u53ef\u6839\u636e\u540d\u5b57\u67e5\u8be2\uff09", notes="\u83b7\u53d6\u89d2\u8272\u5217\u8868\uff08\u53ef\u6839\u636e\u540d\u5b57\u67e5\u8be2\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="name", value="\u67e5\u8be2\u540d\u79f0", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u7b2c\u51e0\u9875", required=false, paramType="query", dataType="Integer"), @ApiImplicitParam(name="linesPerPage", value="\u6bcf\u9875\u663e\u793a\u6761\u6570", required=false, paramType="query", dataType="Integer")})
    public Resource getRoles(@PathVariable String applicationId, @RequestParam(required=false) String name, @RequestParam(required=false, defaultValue="1") Integer pageNo, @RequestParam(required=false, defaultValue="10") Integer linesPerPage) {
        try {
            DataPackage roles = this.roleService.query(applicationId, name, pageNo.intValue(), linesPerPage.intValue());
            return this.success("ok", roles);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(value={"/getRoleByName"})
    public Resource getRoleByName(String applicationId, String name) {
        try {
            Role roleData = this.roleService.getRoleByName(name, applicationId);
            return this.success("ok", roleData);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(value={"/applications/roles/{roleId}"})
    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u8be6\u60c5", notes="\u83b7\u53d6\u89d2\u8272\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleId", value="\u89d2\u8272id", required=true, paramType="path", dataType="string")})
    public Resource getRole(@PathVariable String roleId) {
        try {
            Role role = (Role)this.roleService.findById(roleId);
            return this.success("ok", role);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(value={"/applications/{applicationId}/roles"})
    @ApiOperation(value="\u65b0\u5efa\u89d2\u8272", notes="\u65b0\u5efa\u89d2\u8272")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6Id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u89d2\u8272\u6570\u636e\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource createRole(@PathVariable String applicationId, @RequestBody String content) {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            Role role = (Role)this.json2obj(json, Role.class);
            role.setParentId(applicationId);
            role.setApplicationid(applicationId);
            role.setSortId(Sequence.getTimeSequence());
            String validateMessage = this.validate(role);
            if (!StringUtil.isBlank((String)validateMessage)) {
                return this.error(40001, validateMessage, null);
            }
            role.setId(Sequence.getDesignTimeSequence());
            this.roleService.save((Object)role);
            JSONObject result = new JSONObject();
            result.put((Object)"id", (Object)role.getId());
            return this.success("ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(value={"/applications/roles/{roleId}"})
    @ApiOperation(value="\u66f4\u65b0\u89d2\u8272", notes="\u66f4\u65b0\u89d2\u8272")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleId", value="\u89d2\u8272Id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u89d2\u8272\u6570\u636e\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource updateRole(@PathVariable String roleId, @RequestBody String content) {
        try {
            Role r = (Role)this.roleService.findById(roleId);
            Role role = Role.clone((Role)r);
            JSONObject json = JSONObject.fromObject((Object)content);
            String name = json.getString("name");
            String roleNo = json.getString("roleNo");
            int status = json.getInt("status");
            boolean defaultRole = json.getBoolean("defaultRole");
            role.setName(name);
            role.setRoleNo(roleNo);
            role.setStatus(Integer.valueOf(status));
            role.setDefaultRole(Boolean.valueOf(defaultRole));
            String validateMessage = this.validate(role);
            if (!StringUtil.isBlank((String)validateMessage)) {
                return this.error(40001, validateMessage, null);
            }
            this.roleService.update((Object)role);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(value={"/applications/roles"})
    @ApiOperation(value="\u5220\u9664\u89d2\u8272", notes="\u5220\u9664\u89d2\u8272")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u89d2\u8272Id\u96c6\u5408", required=true, paramType="body", dataType="string")})
    public Resource deleteModule(@RequestBody String content) {
        try {
            List ids = (List)JsonPath.parse((String)content).json();
            String[] idArray = new String[]{};
            idArray = ids.toArray(idArray);
            this.roleService.delete(idArray);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    private String validate(Role role) throws Exception {
        if (StringUtil.isBlank((String)role.getName())) {
            return "\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)role.getRoleNo())) {
            return "\u89d2\u8272\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        Collection roleList = this.roleService.getRolesByApplication(role.getApplicationid());
        if (!roleList.isEmpty()) {
            for (Role tempRole : roleList) {
                if (StringUtil.isBlank((String)role.getId())) {
                    if (role.getName().equals(tempRole.getName())) {
                        return "\u8be5\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728";
                    }
                    if (!tempRole.getRoleNo().equals(role.getRoleNo())) continue;
                    return "\u8be5\u89d2\u8272\u7f16\u53f7\u5df2\u5b58\u5728!";
                }
                if (!tempRole.getId().equals(role.getId()) && role.getName().equals(tempRole.getName())) {
                    return "\u8be5\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728";
                }
                if (tempRole.getId().equals(role.getId()) || !tempRole.getRoleNo().equals(role.getRoleNo())) continue;
                return "\u8be5\u89d2\u8272\u7f16\u53f7\u5df2\u5b58\u5728!";
            }
        }
        return null;
    }
}

