/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.report.controller;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.Environment;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.report.QueryColumnInfo;
import cn.myapps.common.model.report.Report;
import cn.myapps.conf.FeignConfig;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.util.fs.VirtualFileSystemUtils;
import cn.myapps.designtime.report.feignservice.RuntimeFeignService;
import cn.myapps.designtime.report.service.ReportDesignTimeService;
import cn.myapps.util.StringUtil;
import cn.myapps.util.file.FileOperate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.Cookie;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u62a5\u8868\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime/applications"}, produces={"application/json;charset=UTF-8"})
public class ReportsController
extends AbstractDesignTimeController {
    @Autowired
    private ReportDesignTimeService reportDesignTimeService;
    @Autowired
    private RuntimeFeignService runtimeFeignService;

    @GetMapping(path={"/modules/{moduleId}/reports"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u62a5\u8868\u5217\u8868", notes="\u83b7\u53d6\u62a5\u8868\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="moduleId", value="\u6a21\u5757id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="linesPerPage", value="\u9875\u6761\u6570", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="searchword", value="\u540d\u5b57", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="isPrint", value="\u83b7\u53d6\u6253\u5370\u6a21\u677f\u5217\u8868", required=true, paramType="query", dataType="string")})
    public Resource getReportsList(@PathVariable String moduleId, String isPrint, String searchword, String pageNo, String linesPerPage) {
        int page = pageNo != null && pageNo.length() > 0 ? Integer.parseInt(pageNo) : 1;
        int line = linesPerPage != null && linesPerPage.length() > 0 ? Integer.parseInt(linesPerPage) : 10;
        try {
            DataPackage data = this.reportDesignTimeService.queryByNameOrDescript(moduleId, searchword, page, line);
            if (!StringUtil.isBlank((String)isPrint) && isPrint.equals("1")) {
                Collection datas = data.getDatas();
                Iterator iter = datas.iterator();
                while (iter.hasNext()) {
                    Report report = (Report)iter.next();
                    if (report.getIsPrint() == Integer.valueOf(isPrint).intValue()) continue;
                    iter.remove();
                }
                data.setDatas(datas);
            }
            return this.success("ok", data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/reports/{reportId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u62a5\u8868\u8be6\u60c5", notes="\u83b7\u53d6\u62a5\u8868\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="reportId", value="\u62a5\u8868id", required=true, paramType="path", dataType="string")})
    public Resource doGetReport(@PathVariable String reportId) throws Exception {
        try {
            Report report = (Report)this.reportDesignTimeService.findById(reportId);
            return this.success("ok", report);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/modules/{moduleId}/reports"})
    @ApiOperation(value="\u65b0\u5efa\u62a5\u8868", notes="\u65b0\u5efa\u62a5\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="moduleId", value="\u6a21\u5757id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateReports(@PathVariable String applicationId, @PathVariable String moduleId, @RequestBody String content) throws Exception {
        JSONObject json = JSONObject.fromObject((Object)content);
        Report report = (Report)this.json2obj(json, Report.class);
        try {
            report.setApplicationid(applicationId);
            report.setParentId(moduleId);
            this.validate(report);
            String reportUri = report.getUri();
            reportUri = reportUri.substring(0, reportUri.lastIndexOf("/"));
            String jrxmlFilePath = "/workspace" + reportUri + "/" + report.getName() + ".jrxml";
            report.setJrxmlFilePath(jrxmlFilePath);
            this.reportDesignTimeService.save((Object)report);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"id", (Object)report.getId());
            jsonObject.put((Object)"jrxmlFilePath", (Object)report.getJrxmlFilePath());
            return this.success("ok", jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/reports"})
    @ApiOperation(value="\u66f4\u65b0\u62a5\u8868", notes="\u66f4\u65b0\u62a5\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdateReports(@RequestBody String content) throws Exception {
        String jrxmlFileRealPath = "";
        String jasperFileRealPath = "";
        JSONObject json = JSONObject.fromObject((Object)content);
        Report report = (Report)this.json2obj(json, Report.class);
        try {
            File file;
            if (!StringUtil.isBlank((String)((String)json.get("appId")))) {
                report.setApplicationid((String)json.get("appId"));
            }
            Environment env = Environment.getInstance();
            String reportUri = report.getUri();
            reportUri = reportUri.substring(0, reportUri.lastIndexOf("/"));
            String jrxmlFilePath = "/workspace" + reportUri + "/" + report.getName() + ".jrxml";
            jrxmlFileRealPath = env.getRealPath(jrxmlFilePath);
            if (!StringUtils.isBlank((String)report.getId()) && (file = new File(jrxmlFileRealPath)).exists()) {
                VirtualFileSystemUtils.delete((String)env.getRealPath(jrxmlFileRealPath));
            }
            report.setJrxmlFilePath(jrxmlFilePath);
            if (StringUtil.isBlank((String)report.getJrxmlString())) {
                report.setIsDefaultStyle("1");
                this.reportDesignTimeService.saveOrUpdate((Object)report);
            } else {
                FileOperate.writeFileUTF((String)jrxmlFileRealPath, (String)report.getJrxmlString(), (boolean)true);
            }
            this.reportDesignTimeService.saveOrUpdate((Object)report);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/reports"})
    @ApiOperation(value="\u5220\u9664\u62a5\u8868", notes="\u5220\u9664\u62a5\u8868\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doDeleteReports(@RequestBody String[] ids) throws Exception {
        try {
            this.reportDesignTimeService.delete(ids);
            return this.success("ok", "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/reports/getQueryColumnInfos"})
    @ApiOperation(value="\u901a\u8fc7\u6570\u636e\u6e90\u83b7\u53d6\u8fd4\u56de\u7ed3\u679c\u96c6\u7684\u5217\u4fe1\u606f", notes="\u901a\u8fc7\u6570\u636e\u6e90\u83b7\u53d6\u8fd4\u56de\u7ed3\u679c\u96c6\u7684\u5217\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="dataSourceName", value="\u6570\u636e\u6e90\u540d\u79f0", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="viewId", value="\u89c6\u56feid", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="isForm", value="\u662f\u5426\u4e3a\u8868\u5355", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="reportId", value="\u62a5\u8868id", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="type", value="\u6570\u636e\u6e90\u7c7b\u578b", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource getQueryColumnInfos(@PathVariable String applicationId, @RequestBody String content, String dataSourceName, String viewId, String isForm, String reportId, @RequestParam String type) {
        try {
            JSONObject jsonObject = JSONObject.fromObject((Object)content);
            String scriptString = (String)jsonObject.get("scriptString");
            Report report = new Report();
            if (!StringUtil.isBlank((String)reportId)) {
                report = (Report)this.reportDesignTimeService.findById(reportId);
            }
            WebUser user = this.getUser();
            ParamsTable params = this.getParams();
            List<Object> queryColumnInfos = new ArrayList();
            if (type.equals("DATASOURCE_TYPE_VIEW")) {
                boolean flag = Boolean.parseBoolean(isForm);
                queryColumnInfos = flag ? this.reportDesignTimeService.getFormColumnsInfos(viewId) : this.reportDesignTimeService.getViewColumnsInfos(viewId);
            } else if (type.equals("DATASOURCE_TYPE_SQL")) {
                queryColumnInfos = this.reportDesignTimeService.getQueryColumnInfos(scriptString, dataSourceName, applicationId, (IUser)user, report, params);
            } else if (type.equals("DATASOURCE_TYPE_PROCEDURE")) {
                queryColumnInfos = this.reportDesignTimeService.getProcedureColumnsInfos(scriptString, dataSourceName, applicationId, (IUser)user, report, params);
            } else if (type.equals("DATASOURCE_TYPE_CUSTOM")) {
                queryColumnInfos = this.runtimeFeignService.getCustomColumnsInfos(scriptString, applicationId);
            }
            ArrayList<String> columnNmaes = new ArrayList<String>();
            for (QueryColumnInfo queryColumnInfo : queryColumnInfos) {
                String columnName = queryColumnInfo.getColumnName();
                for (int i = 0; i < columnNmaes.size(); ++i) {
                    if (!columnNmaes.contains(columnName)) continue;
                    columnName = columnName + '1';
                }
                queryColumnInfo.setColumnName(columnName);
                columnNmaes.add(columnName);
            }
            return this.success("ok", queryColumnInfos);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/reports/getJrxmlString"})
    @ApiOperation(value="\u83b7\u53d6jrxml\u5b57\u7b26\u4e32", notes="\u83b7\u53d6jrxml\u5b57\u7b26\u4e32")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u62a5\u8868id", required=true, paramType="query", dataType="string")})
    public Resource getJrxmlString(String id) {
        try {
            Environment env = Environment.getInstance();
            Report report = this.reportDesignTimeService.doView(id);
            String jrxmlPath = report.getJrxmlFilePath();
            String jrxmlRealPath = env.getRealPath(jrxmlPath);
            String jrxmlString = FileOperate.getFileContentAsStringUTF((String)jrxmlRealPath);
            return this.success("ok", jrxmlString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/reports/getExampleIscriptString"})
    @ApiOperation(value="\u83b7\u53d6ReportExamples\u7684iscript\u811a\u672c", notes="\u83b7\u53d6ReportExamples\u7684iscript\u811a\u672c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="exampleName", value="\u793a\u4f8b\u540d\u79f0", required=true, paramType="query", dataType="string")})
    public Resource getExampleIscriptString(@RequestParam String exampleName) {
        try {
            String result = this.reportDesignTimeService.getExampleIscriptStringByName(exampleName);
            return this.success("ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/reports/uploadImageFile"})
    @ApiOperation(value="\u63a5\u6536\u4e0a\u4f20\u56fe\u7247\u63a5\u53e3", notes="\u63a5\u6536\u4e0a\u4f20\u56fe\u7247\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u6587\u4ef6\u4e8c\u8fdb\u5236\u6d41", required=true, paramType="body", dataType="string")})
    public Resource uploadImageFile(MultipartFile file) {
        try {
            Environment env = Environment.getInstance();
            String path = "/uploads/reports/images/" + file.getOriginalFilename();
            String realPath = env.getRealPath(path);
            FileOperate.writeFile((String)realPath, (InputStream)file.getInputStream());
            return this.success("ok", realPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/reports/getReportJasperPath"})
    @ApiOperation(value="\u8fd4\u56de\u62a5\u8868\u7684jasper\u6587\u4ef6\u8def\u5f84", notes="\u8fd4\u56de\u62a5\u8868\u7684jasper\u6587\u4ef6\u8def\u5f84")
    @ApiImplicitParams(value={@ApiImplicitParam(name="reportId", value="\u62a5\u8868id", required=true, paramType="query", dataType="string")})
    public Resource getReportJasperPath(@RequestParam String reportId) {
        try {
            Environment env = Environment.getInstance();
            Report report = this.reportDesignTimeService.doView(reportId);
            String realPath = env.getRealPath(report.getJrxmlFilePath()).replace(".jrxml", ".jasper");
            return this.success("ok", realPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GetMapping(path={"/reports/showjrxml/{id}"})
    @ApiOperation(value="\u62a5\u8868\u9884\u89c8\u8fd4\u56dehtml\u8def\u5f84", notes="\u62a5\u8868\u9884\u89c8\u8fd4\u56dehtml\u8def\u5f84")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u62a5\u8868id", required=true, paramType="path", dataType="string")})
    public Resource showJrxmlReport(@PathVariable String id, @RequestParam(required=false) String domainId) {
        if (StringUtil.isBlank((String)id)) return this.error(500, "\u8bf7\u6307\u5b9a\u62a5\u8868!", null);
        WebUser user = this.getUser();
        String htmlPath = "";
        Report report = this.reportDesignTimeService.doView(id);
        JSONObject requestBody = new JSONObject();
        requestBody.put((Object)"appId", (Object)report.getApplicationid());
        requestBody.put((Object)"reportId", (Object)report.getId());
        requestBody.put((Object)"domainId", (Object)domainId);
        try {
            htmlPath = this.runtimeFeignService.showJrxmlReport(id, requestBody.toString(), null);
            if (StringUtil.isBlank((String)htmlPath) || !htmlPath.contains("\u7cfb\u7edf\u5f02\u5e38")) return this.success("ok", htmlPath);
            return this.error(500, htmlPath, null);
        }
        catch (Exception e) {
            try {
                return this.error(500, "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", null);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return this.error(500, e2.getMessage(), null);
            }
        }
    }

    @GetMapping(path={"/reports/getDomainList"})
    @ApiOperation(value="\u8fd4\u56de\u4f01\u4e1a\u57df\u5217\u8868", notes="\u8fd4\u56de\u4f01\u4e1a\u57df\u5217\u8868")
    public Resource getDomainList() {
        try {
            Cookie[] cookies;
            String accessToken = "";
            for (Cookie cookie : cookies = this.request.getCookies()) {
                String name = cookie.getName();
                if (!"designerToken".equals(name)) continue;
                accessToken = cookie.getValue();
            }
            FeignConfig.ADMIN_TOKEN = accessToken;
            JSONObject requestDomainList = new JSONObject();
            JSONObject result = new JSONObject();
            try {
                result = (JSONObject)JSONObject.fromObject((Object)this.runtimeFeignService.getDomainList(requestDomainList.toString())).get("data");
            }
            catch (RuntimeException re) {
                re.printStackTrace();
                return this.error(500, "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", null);
            }
            JSONArray resultDomainList = (JSONArray)result.get("datas");
            return this.success("ok", resultDomainList);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    public void validate(Report report) throws Exception {
        List list = this.reportDesignTimeService.list(report.getParentId(), report.getName());
        if (StringUtils.isBlank((String)report.getId())) {
            for (Report r : list) {
                if (!r.getName().equals(report.getName())) continue;
                throw new OBPMValidateException("{*[report.name.exist]*}");
            }
        } else {
            for (Report r : list) {
                if (r.getId().equals(report.getId()) || !r.getName().equals(report.getName())) continue;
                throw new OBPMValidateException("{*[report.name.exist]*}");
            }
        }
        for (Report r : list) {
            if (!r.getName().equals(report.getName()) || r.getId().equals(report.getId())) continue;
            throw new OBPMValidateException("{*[report.name.exist]*}");
        }
    }
}

