/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.overview;

import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.overview.IOverview;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import com.lowagie.text.Cell;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ViewOverview
implements IOverview {
    @Override
    public Table buildOverview(String applicationId) throws Exception {
        Table table = new Table(1);
        table.setPadding(2.0f);
        table.setSpacing(0.0f);
        table.setBorderWidth(1.0f);
        table.setWidth(100.0f);
        if (!StringUtil.isBlank((String)applicationId)) {
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontChinese = new Font(bfChinese, 10.0f, 0, Color.BLACK);
            Cell vc = new Cell();
            vc.setBackgroundColor(Color.gray);
            vc.addElement((Element)new Paragraph("\u89c6\u56fe\uff1a", fontChinese));
            table.addCell(vc);
            ViewDesignTimeService vp = DesignTimeServiceManager.viewDesignTimeService();
            Collection views = vp.getViewsByApplication(applicationId);
            if (views != null) {
                vc = new Cell();
                Iterator it = views.iterator();
                Table vTable = new Table(1);
                vTable.setWidth(99.0f);
                vTable.setPadding(0.0f);
                vTable.setSpacing(0.0f);
                vTable.setBorderWidth(1.0f);
                Cell v_cell = null;
                while (it.hasNext()) {
                    AbstractView view = (AbstractView)it.next();
                    if (view == null) continue;
                    v_cell = new Cell();
                    Table vt = new Table(1);
                    vt.setWidth(99.0f);
                    vt.setPadding(0.0f);
                    vt.setSpacing(0.0f);
                    vt.setBorderWidth(1.0f);
                    Cell cell = new Cell();
                    cell.setBorderWidth(0.0f);
                    String vName = view.getName();
                    cell.addElement((Element)new Paragraph("\u89c6\u56fe\u540d\u79f0\uff1a" + (vName != null ? vName : ""), fontChinese));
                    String createTime = "";
                    cell.addElement((Element)new Paragraph("\u521b\u5efa\u65f6\u95f4\uff1a" + (createTime != null ? createTime : ""), fontChinese));
                    String description = "";
                    cell.addElement((Element)new Paragraph("\u63cf\u8ff0\uff1a" + (description != null ? description : ""), fontChinese));
                    vt.addCell(cell);
                    cell = new Cell();
                    cell.addElement((Element)new Paragraph("\u67e5\u8be2\u5b9a\u4e49\uff1a", fontChinese));
                    Table qt = this.createQueryDefi(view);
                    if (qt != null) {
                        cell.addElement((Element)qt);
                    }
                    vt.addCell(cell);
                    cell = new Cell();
                    cell.addElement((Element)new Paragraph("\u64cd\u4f5c\u4fe1\u606f\uff1a", fontChinese));
                    Table ot = this.createViewOpr(view);
                    if (ot != null) {
                        cell.addElement((Element)ot);
                    }
                    vt.addCell(cell);
                    v_cell.addElement((Element)vt);
                    vTable.addCell(v_cell);
                }
                vc.addElement((Element)vTable);
                table.addCell(vc);
            }
        }
        return table;
    }

    private Table createQueryDefi(AbstractView view) throws Exception {
        if (view != null) {
            String procedureFilterScript;
            String sqlFilterScript;
            String filterScript;
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontChinese = new Font(bfChinese, 10.0f, 0, Color.BLACK);
            Table query_info = new Table(3);
            query_info.setWidth(99.0f);
            query_info.setPadding(0.0f);
            query_info.setSpacing(0.0f);
            query_info.setBorderWidth(1.0f);
            Cell cell = new Cell();
            cell.setBackgroundColor(Color.gray);
            cell.addElement((Element)new Paragraph("\u6a21\u5f0f", fontChinese));
            query_info.addCell(cell);
            cell = new Cell();
            cell.setBackgroundColor(Color.gray);
            cell.addElement((Element)new Paragraph("\u5bf9\u5e94\u8868\u5355", fontChinese));
            query_info.addCell(cell);
            cell = new Cell();
            cell.setBackgroundColor(Color.gray);
            cell.addElement((Element)new Paragraph("\u63cf\u8ff0", fontChinese));
            query_info.addCell(cell);
            cell = new Cell();
            HashMap<String, String> mode_map = new HashMap<String, String>();
            mode_map.put("00", "\u8bbe\u8ba1\u6a21\u5f0f");
            mode_map.put("01", "DQL\u6a21\u5f0f");
            mode_map.put("02", "SQL\u6a21\u5f0f");
            mode_map.put("03", "\u5b58\u50a8\u8fc7\u7a0b\u6a21\u5f0f");
            String model = (String)mode_map.get(view.getEditMode());
            cell.addElement((Element)new Paragraph(model != null ? model : "", fontChinese));
            query_info.addCell(cell);
            cell = new Cell();
            String relatedForm = view.getRelatedForm();
            FormDesignTimeService fp = DesignTimeServiceManager.formDesignTimeService();
            Form form = fp.doView(relatedForm);
            String relationFormName = "";
            if (form != null) {
                relationFormName = form.getName();
            }
            cell.addElement((Element)new Paragraph(relationFormName != null ? relationFormName : "", fontChinese));
            query_info.addCell(cell);
            cell = new Cell();
            String description = view.getDescription();
            cell.addElement((Element)new Paragraph(description != null ? description : "", fontChinese));
            query_info.addCell(cell);
            String codition = view.getFilterCondition();
            if (!StringUtil.isBlank((String)codition)) {
                cell = new Cell();
                cell.setColspan(3);
                cell.addElement((Element)new Paragraph("\u6761\u4ef6\u63cf\u8ff0\uff08\u8bbe\u8ba1\u6a21\u5f0f\uff09\uff1a\n" + codition, fontChinese));
                query_info.addCell(cell);
            }
            if (!StringUtil.isBlank((String)(filterScript = view.getFilterScript()))) {
                cell = new Cell();
                cell.setColspan(3);
                cell.addElement((Element)new Paragraph("\u6761\u4ef6\u811a\u672c\uff08DQL\u6a21\u5f0f\uff09\uff1a\n" + StringUtil.dencodeHTML((String)filterScript), fontChinese));
                query_info.addCell(cell);
            }
            if (!StringUtil.isBlank((String)(sqlFilterScript = view.getSqlFilterScript()))) {
                cell = new Cell();
                cell.setColspan(3);
                cell.addElement((Element)new Paragraph("\u6761\u4ef6\u811a\u672c\uff08SQL\u6a21\u5f0f\uff09\uff1a\n" + StringUtil.dencodeHTML((String)sqlFilterScript), fontChinese));
                query_info.addCell(cell);
            }
            if (!StringUtil.isBlank((String)(procedureFilterScript = view.getProcedureFilterScript()))) {
                cell = new Cell();
                cell.setColspan(3);
                cell.addElement((Element)new Paragraph("\u6761\u4ef6\u811a\u672c\uff08\u5b58\u50a8\u8fc7\u7a0b\u6a21\u5f0f\uff09\uff1a\n" + StringUtil.dencodeHTML((String)procedureFilterScript), fontChinese));
                query_info.addCell(cell);
            }
            return query_info;
        }
        return null;
    }

    private Table createViewOpr(AbstractView view) throws Exception {
        if (view != null) {
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontChinese = new Font(bfChinese, 10.0f, 0, Color.BLACK);
            Table opr_table = new Table(3);
            opr_table.setWidth(99.0f);
            opr_table.setPadding(0.0f);
            opr_table.setSpacing(0.0f);
            opr_table.setBorderWidth(1.0f);
            if (view.getActivities() != null) {
                List acts = view.getActivities();
                Iterator it = acts.iterator();
                Cell ct = new Cell();
                ct.setBackgroundColor(Color.gray);
                ct.addElement((Element)new Paragraph("\u64cd\u4f5c\uff08\u6309\u94ae\uff09\uff1a", fontChinese));
                opr_table.addCell(ct);
                ct = new Cell();
                ct.setBackgroundColor(Color.gray);
                ct.addElement((Element)new Paragraph("\u7c7b\u578b", fontChinese));
                opr_table.addCell(ct);
                ct = new Cell();
                ct.setBackgroundColor(Color.gray);
                ct.addElement((Element)new Paragraph("\u63cf\u8ff0", fontChinese));
                opr_table.addCell(ct);
                while (it.hasNext()) {
                    Activity act = (Activity)it.next();
                    ct = new Cell();
                    String aName = act.getName();
                    ct.addElement((Element)new Paragraph(aName != null ? aName : "", fontChinese));
                    opr_table.addCell(ct);
                    ct = new Cell();
                    int actType = act.getType();
                    String actTypeName = this.getOperationType(actType);
                    ct.addElement((Element)new Paragraph(actTypeName != null ? actTypeName : "", fontChinese));
                    opr_table.addCell(ct);
                    ct = new Cell();
                    String desc = "";
                    ct.addElement((Element)new Paragraph(desc != null ? desc : "", fontChinese));
                    opr_table.addCell(ct);
                    ct = new Cell();
                    ct.setColspan(3);
                    String actBeScript = act.getBeforeActionScript();
                    String actAfScript = act.getAfterActionScript();
                    String actReadOnlyScript = act.getReadonlyScript();
                    String actHiddenScript = act.getHiddenScript();
                    if (StringUtil.isBlank((String)actBeScript) && StringUtil.isBlank((String)actAfScript) && StringUtil.isBlank((String)actReadOnlyScript) && StringUtil.isBlank((String)actHiddenScript)) continue;
                    if (!StringUtil.isBlank((String)actBeScript)) {
                        ct.addElement((Element)new Paragraph("\u6267\u884c\u524d\u811a\u672c\uff1a\n" + StringUtil.dencodeHTML((String)actBeScript), fontChinese));
                    }
                    if (!StringUtil.isBlank((String)actAfScript)) {
                        ct.addElement((Element)new Paragraph("\u6267\u884c\u540e\u811a\u672c\uff1a\n" + StringUtil.dencodeHTML((String)actAfScript), fontChinese));
                    }
                    if (!StringUtil.isBlank((String)actReadOnlyScript)) {
                        ct.addElement((Element)new Paragraph("\u53ea\u8bfb\u811a\u672c\uff1a\n" + StringUtil.dencodeHTML((String)actReadOnlyScript), fontChinese));
                    }
                    if (!StringUtil.isBlank((String)actHiddenScript)) {
                        ct.addElement((Element)new Paragraph("\u9690\u85cf\u811a\u672c\uff1a\n" + StringUtil.dencodeHTML((String)actHiddenScript), fontChinese));
                    }
                    opr_table.addCell(ct);
                }
            }
            return opr_table;
        }
        return null;
    }

    private String getOperationType(int keyType) {
        return ViewActivityType.activity_map.get(keyType);
    }

    public static class ViewActivityType {
        public static final Map<Integer, String> activity_map = new HashMap<Integer, String>();

        static {
            activity_map.put(1, "\u67e5\u8be2");
            activity_map.put(2, "\u521b\u5efa");
            activity_map.put(3, "\u5220\u9664");
            activity_map.put(20, "\u6279\u91cf\u63d0\u4ea4");
            activity_map.put(16, "\u5bfc\u51faExcel");
            activity_map.put(18, "\u6e05\u7a7a\u6240\u6709\u6570\u636e");
            activity_map.put(27, "\u5bfc\u5165Excel");
            activity_map.put(26, "\u6587\u4ef6\u4e0b\u8f7d");
            activity_map.put(29, "\u6279\u91cf\u7b7e\u7ae0");
        }
    }
}

