/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.overview;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.common.model.role.Role;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.overview.IOverview;
import cn.myapps.designtime.role.service.RoleDesignTimeService;
import com.lowagie.text.Cell;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.util.Collection;

public class RoleOverview
implements IOverview {
    @Override
    public Table buildOverview(String applicationId) throws Exception {
        Table table = new Table(1);
        table.setPadding(2.0f);
        table.setSpacing(0.0f);
        table.setBorderWidth(1.0f);
        table.setWidth(100.0f);
        if (!StringUtil.isBlank((String)applicationId)) {
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontChinese = new Font(bfChinese, 10.0f, 0, Color.BLACK);
            Cell rc = new Cell();
            rc.setBackgroundColor(Color.gray);
            rc.addElement((Element)new Paragraph("\u89d2\u8272\uff1a", fontChinese));
            table.addCell(rc);
            RoleDesignTimeService roleService = AuthTimeServiceManager.roleRuntimeService();
            Collection rs = roleService.getRolesByApplication(applicationId);
            if (rs != null) {
                rc = new Cell();
                Table rTable = new Table(1);
                rTable.setWidth(96.0f);
                rTable.setPadding(0.0f);
                rTable.setSpacing(0.0f);
                rTable.setBorderWidth(0.0f);
                for (Role role : rs) {
                    if (role == null) continue;
                    String rName = role.getName();
                    Cell cell = new Cell();
                    cell.addElement((Element)new Paragraph("\u540d\u79f0\uff1a" + (rName != null ? rName : ""), fontChinese));
                    rTable.addCell(cell);
                }
                rc.addElement((Element)rTable);
                table.addCell(rc);
            }
        }
        return table;
    }
}

