/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.overview;

import cn.myapps.common.model.crossreport.CrossReportVO;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.crossreport.definition.service.CrossReportDesignTimeService;
import cn.myapps.designtime.overview.IOverview;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import com.lowagie.text.Cell;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReportOverview
implements IOverview {
    @Override
    public Table buildOverview(String applicationId) throws Exception {
        Table table = new Table(1);
        table.setPadding(2.0f);
        table.setSpacing(0.0f);
        table.setBorderWidth(1.0f);
        table.setWidth(100.0f);
        if (!StringUtil.isBlank((String)applicationId)) {
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontChinese = new Font(bfChinese, 10.0f, 0, Color.BLACK);
            Cell rc = new Cell();
            rc.setBackgroundColor(Color.gray);
            rc.addElement((Element)new Paragraph("\u62a5\u8868\uff1a", fontChinese));
            table.addCell(rc);
            rc = new Cell();
            CrossReportDesignTimeService rp = DesignTimeServiceManager.crossReportDesignTimeService();
            List rs = rp.list(applicationId, null);
            if (rs != null && rs.size() > 0) {
                Table rTable = new Table(5);
                rTable.setPadding(0.0f);
                rTable.setSpacing(0.0f);
                rTable.setBorderWidth(1.0f);
                rTable.setWidth(96.0f);
                Cell cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u540d\u79f0", fontChinese));
                rTable.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u6807\u9898", fontChinese));
                rTable.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u7c7b\u578b", fontChinese));
                rTable.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u5173\u8054\u89c6\u56fe", fontChinese));
                rTable.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u63cf\u8ff0", fontChinese));
                rTable.addCell(cell);
                for (CrossReportVO report : rs) {
                    String type;
                    cell = new Cell();
                    String name = report.getName();
                    cell.addElement((Element)new Paragraph(name != null ? name : "", fontChinese));
                    rTable.addCell(cell);
                    cell = new Cell();
                    String title = report.getReportTitle();
                    cell.addElement((Element)new Paragraph(title != null ? title : "", fontChinese));
                    rTable.addCell(cell);
                    cell = new Cell();
                    String t = report.getType();
                    if (StringUtil.isBlank((String)t)) {
                        t = "CrossReport";
                    }
                    cell.addElement((Element)new Paragraph((type = ReportType.type_map.get(report.getType())) != null ? type : "", fontChinese));
                    rTable.addCell(cell);
                    cell = new Cell();
                    String viewId = report.getView();
                    AbstractView view = null;
                    if (viewId != null) {
                        ViewDesignTimeService vp = DesignTimeServiceManager.viewDesignTimeService();
                        view = vp.doView(viewId);
                    }
                    cell.addElement((Element)new Paragraph(view != null ? view.getName() : "", fontChinese));
                    rTable.addCell(cell);
                    cell = new Cell();
                    String note = report.getNote();
                    cell.addElement((Element)new Paragraph(note != null ? note : "", fontChinese));
                    rTable.addCell(cell);
                }
                rc.addElement((Element)rTable);
                table.addCell(rc);
            }
        }
        return table;
    }

    public static class ReportType {
        public static final Map<String, String> type_map = new HashMap<String, String>();

        static {
            type_map.put("CrossReport", "\u4ea4\u53c9\u62a5\u8868");
            type_map.put("CustomizeReport", "\u81ea\u5b9a\u4e49\u62a5\u8868");
        }
    }
}

