/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.overview;

import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.resource.ResourceVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.overview.IOverview;
import cn.myapps.designtime.resource.service.ResourceDesignTimeService;
import com.lowagie.text.Cell;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;

public class MobileMenuOverview
implements IOverview {
    @Override
    public Table buildOverview(String applicationId) throws Exception {
        Table table = new Table(1);
        table.setPadding(2.0f);
        table.setSpacing(0.0f);
        table.setBorderWidth(1.0f);
        table.setWidth(100.0f);
        if (!StringUtil.isBlank((String)applicationId)) {
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontChinese = new Font(bfChinese, 10.0f, 0, Color.BLACK);
            Cell mc = new Cell();
            mc.setBackgroundColor(Color.gray);
            mc.addElement((Element)new Paragraph("mobile\u83dc\u5355\uff1a", fontChinese));
            table.addCell(mc);
            ResourceDesignTimeService rp = DesignTimeServiceManager.resourceDesignTimeService();
            Collection rs = rp.doSimpleQuery(new ParamsTable(), applicationId, "mobilemenu", "mobilemenu");
            if (rs != null) {
                mc = new Cell();
                Table rTable = new Table(5);
                rTable.setWidth(96.0f);
                rTable.setPadding(0.0f);
                rTable.setSpacing(0.0f);
                rTable.setBorderWidth(0.0f);
                Cell cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u540d\u79f0", fontChinese));
                rTable.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u5e8f\u5217\u53f7", fontChinese));
                rTable.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u4e0a\u7ea7", fontChinese));
                rTable.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u8d44\u6e90\u63cf\u8ff0", fontChinese));
                rTable.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u94fe\u63a5\u7c7b\u578b", fontChinese));
                rTable.addCell(cell);
                for (ResourceVO resource : rs) {
                    String sName;
                    if (resource == null) continue;
                    cell = new Cell();
                    String rName = resource.getName();
                    if (!StringUtil.isBlank((String)rName)) {
                        cell.addElement((Element)new Paragraph(rName, fontChinese));
                    }
                    rTable.addCell(cell);
                    cell = new Cell();
                    String orderno = String.valueOf(resource.getOrderno());
                    if (!StringUtil.isBlank((String)orderno)) {
                        cell.addElement((Element)new Paragraph(orderno, fontChinese));
                    }
                    rTable.addCell(cell);
                    ResourceVO superior = (ResourceVO)rp.findById(resource.getSuperior());
                    cell = new Cell();
                    if (superior != null && !StringUtil.isBlank((String)(sName = superior.getName()))) {
                        cell.addElement((Element)new Paragraph(sName, fontChinese));
                    }
                    rTable.addCell(cell);
                    cell = new Cell();
                    String description = resource.getDescription();
                    cell.addElement((Element)new Paragraph(description, fontChinese));
                    rTable.addCell(cell);
                    cell = new Cell();
                    String linkType = resource.getLinkType();
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("00", "\u8868\u5355");
                    map.put("01", "\u89c6\u56fe");
                    map.put("02", "\u62a5\u8868");
                    map.put("03", "Excel\u5bfc\u5165");
                    map.put("05", "\u81ea\u5b9a\u4e49\u5185\u90e8\u94fe\u63a5");
                    map.put("06", "\u81ea\u5b9a\u4e49\u5916\u90e8\u94fe\u63a5");
                    map.put("07", "\u811a\u672c\u94fe\u63a5");
                    map.put("08", "\u90ae\u4ef6\u94fe\u63a5");
                    map.put("09", "\u81ea\u5b9a\u4e49\u62a5\u8868");
                    map.put("10", "\u8bba\u575b\u94fe\u63a5");
                    if (!StringUtil.isBlank((String)linkType)) {
                        cell.addElement((Element)new Paragraph((String)map.get(linkType), fontChinese));
                    }
                    rTable.addCell(cell);
                    String queryString = resource.getQueryString();
                    if (StringUtil.isBlank((String)queryString)) continue;
                    cell = new Cell();
                    cell.setColspan(5);
                    cell.addElement((Element)new Paragraph("\u53c2\u6570\uff1a\n" + queryString, fontChinese));
                    rTable.addCell(cell);
                }
                mc.addElement((Element)rTable);
                table.addCell(mc);
            }
        }
        return table;
    }
}

