/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.overview;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.overview.IOverview;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.form.ejb.CheckboxField;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.FormField;
import cn.myapps.runtime.dynaform.form.ejb.IncludeField;
import cn.myapps.runtime.dynaform.form.ejb.RadioField;
import cn.myapps.runtime.dynaform.form.ejb.SelectAboutField;
import cn.myapps.runtime.dynaform.form.ejb.SelectField;
import cn.myapps.runtime.dynaform.form.ejb.SuggestField;
import cn.myapps.runtime.dynaform.form.ejb.mapping.TableMapping;
import cn.myapps.runtime.macro.runner.IRunner;
import cn.myapps.runtime.macro.runner.JavaScriptFactory;
import com.lowagie.text.Cell;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FormOverview
implements IOverview {
    @Override
    public Table buildOverview(String applicationId) throws Exception {
        Table table = new Table(1);
        table.setPadding(2.0f);
        table.setSpacing(0.0f);
        table.setBorderWidth(0.0f);
        table.setWidth(100.0f);
        if (!StringUtil.isBlank((String)applicationId)) {
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontChinese = new Font(bfChinese, 10.0f, 0, Color.BLACK);
            Cell fc = new Cell();
            fc.setBackgroundColor(Color.gray);
            fc.addElement((Element)new Paragraph("\u8868\u5355\uff1a", fontChinese));
            table.addCell(fc);
            fc = new Cell();
            fc.setColspan(3);
            FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
            Collection forms = formService.getFormsByApplication(applicationId);
            if (forms != null) {
                Table fTable = new Table(1);
                fTable.setPadding(0.0f);
                fTable.setSpacing(0.0f);
                fTable.setBorderWidth(1.0f);
                fTable.setWidth(99.0f);
                Cell f_cell = null;
                for (Form form : forms) {
                    if (form == null) continue;
                    f_cell = new Cell();
                    f_cell.setBorderWidth(1.0f);
                    Table formTable = new Table(1);
                    formTable.setWidth(99.0f);
                    formTable.setPadding(0.0f);
                    formTable.setSpacing(0.0f);
                    formTable.setBorderWidth(1.0f);
                    TableMapping tableMapping = new TableMapping(form);
                    Cell cell = new Cell();
                    cell.setBorderWidth(0.0f);
                    String fName = form.getName();
                    String description = form.getDescription();
                    cell.addElement((Element)new Paragraph("\u8868\u5355\u540d\u79f0\uff1a" + (fName != null ? fName : ""), fontChinese));
                    cell.addElement((Element)new Paragraph("\u521b\u5efa\u65f6\u95f4\uff1a", fontChinese));
                    cell.addElement((Element)new Paragraph("\u5bf9\u5e94\u5143\u6570\u636e\uff1a" + (fName != null ? tableMapping.getTableName() : ""), fontChinese));
                    cell.addElement((Element)new Paragraph("\u63cf\u8ff0\uff1a" + (description != null ? description : ""), fontChinese));
                    formTable.addCell(cell);
                    cell = new Cell();
                    cell.setBorderWidth(0.0f);
                    cell.addElement((Element)new Paragraph("\u64cd\u4f5c\u4fe1\u606f\uff1a", fontChinese));
                    Table oprTable = this.createFormOpr(form.getActivities());
                    if (oprTable != null) {
                        cell.addElement((Element)oprTable);
                    }
                    formTable.addCell(cell);
                    cell = new Cell();
                    cell.setBorderWidth(0.0f);
                    cell.addElement((Element)new Paragraph("\u5b57\u6bb5\u4fe1\u606f\uff1a", fontChinese));
                    Table fieldTable = this.createFormField(form.getFields(), tableMapping);
                    if (fieldTable != null) {
                        cell.addElement((Element)fieldTable);
                    }
                    formTable.addCell(cell);
                    f_cell.addElement((Element)formTable);
                    fTable.addCell(f_cell);
                }
                fc.addElement((Element)fTable);
                table.addCell(fc);
            }
        }
        return table;
    }

    private Table createFormOpr(Collection<Activity> acts) throws Exception {
        if (acts != null) {
            Iterator<Activity> it_act = acts.iterator();
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontChinese = new Font(bfChinese, 10.0f, 0, Color.BLACK);
            Table opr_info = new Table(3);
            opr_info.setPadding(5.0f);
            opr_info.setSpacing(0.0f);
            opr_info.setBorderWidth(1.0f);
            opr_info.setWidth(98.0f);
            if (it_act.hasNext()) {
                Cell oprCell = new Cell();
                oprCell.setBackgroundColor(Color.gray);
                oprCell.addElement((Element)new Paragraph("\u64cd\u4f5c\uff08\u6309\u94ae\uff09", fontChinese));
                opr_info.addCell(oprCell);
                oprCell = new Cell();
                oprCell.setBackgroundColor(Color.gray);
                oprCell.addElement((Element)new Paragraph("\u7c7b\u578b", fontChinese));
                opr_info.addCell(oprCell);
                oprCell = new Cell();
                oprCell.setBackgroundColor(Color.gray);
                oprCell.addElement((Element)new Paragraph("\u63cf\u8ff0", fontChinese));
                opr_info.addCell(oprCell);
                while (it_act.hasNext()) {
                    Activity act = it_act.next();
                    String desc = "";
                    oprCell = new Cell();
                    String actName = act.getName();
                    oprCell.addElement((Element)new Paragraph(actName != null ? actName : "", fontChinese));
                    opr_info.addCell(oprCell);
                    oprCell = new Cell();
                    int actType = act.getType();
                    String actTypeName = this.getOperationType(actType);
                    oprCell.addElement((Element)new Paragraph(actTypeName != null ? actTypeName : "", fontChinese));
                    opr_info.addCell(oprCell);
                    oprCell = new Cell();
                    oprCell.addElement((Element)new Paragraph(desc != null ? desc : "", fontChinese));
                    opr_info.addCell(oprCell);
                    oprCell = new Cell();
                    oprCell.setColspan(3);
                    String actBeScript = act.getBeforeActionScript();
                    String actAfScript = act.getAfterActionScript();
                    String actReadOnlyScript = act.getReadonlyScript();
                    String actHiddenScript = act.getHiddenScript();
                    if (StringUtil.isBlank((String)actBeScript) && StringUtil.isBlank((String)actAfScript) && StringUtil.isBlank((String)actReadOnlyScript) && StringUtil.isBlank((String)actHiddenScript)) continue;
                    if (!StringUtil.isBlank((String)actBeScript)) {
                        oprCell.addElement((Element)new Paragraph("\u6267\u884c\u524d\u811a\u672c\uff1a\n" + StringUtil.dencodeHTML((String)actBeScript), fontChinese));
                    }
                    if (!StringUtil.isBlank((String)actAfScript)) {
                        oprCell.addElement((Element)new Paragraph("\u6267\u884c\u540e\u811a\u672c\uff1a\n" + StringUtil.dencodeHTML((String)actAfScript), fontChinese));
                    }
                    if (!StringUtil.isBlank((String)actReadOnlyScript)) {
                        oprCell.addElement((Element)new Paragraph("\u53ea\u8bfb\u811a\u672c\uff1a\n" + StringUtil.dencodeHTML((String)actReadOnlyScript), fontChinese));
                    }
                    if (!StringUtil.isBlank((String)actHiddenScript)) {
                        oprCell.addElement((Element)new Paragraph("\u9690\u85cf\u811a\u672c\uff1a\n" + StringUtil.dencodeHTML((String)actHiddenScript), fontChinese));
                    }
                    opr_info.addCell(oprCell);
                }
            }
            return opr_info;
        }
        return null;
    }

    private Table createFormField(Collection<FormField> fields, TableMapping tableMapping) throws Exception {
        if (fields != null) {
            Iterator<FormField> it_field = fields.iterator();
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontChinese = new Font(bfChinese, 10.0f, 0, Color.BLACK);
            Table field_info = new Table(4);
            field_info.setPadding(5.0f);
            field_info.setSpacing(0.0f);
            field_info.setBorderWidth(0.0f);
            field_info.setWidth(98.0f);
            if (it_field.hasNext()) {
                Cell fieldCell = new Cell();
                fieldCell.setBackgroundColor(Color.gray);
                fieldCell.addElement((Element)new Paragraph("\u5b57\u6bb5\u540d\u79f0", fontChinese));
                field_info.addCell(fieldCell);
                fieldCell = new Cell();
                fieldCell.setBackgroundColor(Color.gray);
                fieldCell.addElement((Element)new Paragraph("\u5bf9\u5e94\u5143\u6570\u636e\u5b57\u6bb5", fontChinese));
                field_info.addCell(fieldCell);
                fieldCell = new Cell();
                fieldCell.setBackgroundColor(Color.gray);
                fieldCell.addElement((Element)new Paragraph("\u7c7b\u578b", fontChinese));
                field_info.addCell(fieldCell);
                fieldCell = new Cell();
                fieldCell.setBackgroundColor(Color.gray);
                fieldCell.addElement((Element)new Paragraph("\u63cf\u8ff0", fontChinese));
                field_info.addCell(fieldCell);
                IRunner runner = JavaScriptFactory.getInstance((String)"", (String)"");
                runner.initBSFManager((IDocument)new Document(), new ParamsTable(), (IUser)new WebUser(), new ArrayList());
                while (it_field.hasNext()) {
                    FormField field = it_field.next();
                    fieldCell = new Cell();
                    String fieldName = field.getName();
                    fieldCell.addElement((Element)new Paragraph(fieldName != null ? fieldName : "", fontChinese));
                    field_info.addCell(fieldCell);
                    fieldCell = new Cell();
                    fieldCell.addElement((Element)new Paragraph(fieldName != null ? tableMapping.getColumnName(fieldName) : "", fontChinese));
                    field_info.addCell(fieldCell);
                    fieldCell = new Cell();
                    String fieldTabName = field.getTagName();
                    String fieldType = this.getFieldType(fieldTabName);
                    if (field instanceof IncludeField) {
                        String includeType = ((IncludeField)field).getIncludeType();
                        if (!StringUtil.isBlank((String)fieldType) && "0".equals(includeType)) {
                            fieldType = fieldType + "(\u89c6\u56fe)";
                        }
                    }
                    fieldCell.addElement((Element)new Paragraph(fieldType != null ? fieldType : "", fontChinese));
                    field_info.addCell(fieldCell);
                    fieldCell = new Cell();
                    String des_field = field.getDiscript(runner);
                    fieldCell.addElement((Element)new Paragraph(des_field != null ? des_field : "", fontChinese));
                    field_info.addCell(fieldCell);
                    fieldCell = new Cell();
                    fieldCell.setColspan(4);
                    String valueScript = field.getValueScript();
                    String validateScript = field.getValidateRule();
                    String hiddenScript = field.getHiddenScript();
                    String hiddenPrintScript = field.getHiddenPrintScript();
                    String readOnlyScript = field.getReadonlyScript();
                    String optionsScript = "";
                    if (field instanceof CheckboxField || field instanceof RadioField || field instanceof SelectField || field instanceof SelectAboutField || field instanceof SuggestField) {
                        if (field instanceof CheckboxField) {
                            CheckboxField checkboxField = (CheckboxField)field;
                            optionsScript = checkboxField.getOptionsScript();
                        } else if (field instanceof RadioField) {
                            RadioField radioField = (RadioField)field;
                            optionsScript = radioField.getOptionsScript();
                        } else if (field instanceof SelectField) {
                            SelectField selectField = (SelectField)field;
                            optionsScript = selectField.getOptionsScript();
                        } else if (field instanceof SelectAboutField) {
                            SelectAboutField selectAboutField = (SelectAboutField)field;
                            optionsScript = selectAboutField.getOptionsScript();
                        } else if (field instanceof SuggestField) {
                            SuggestField suggestField = (SuggestField)field;
                            optionsScript = suggestField.getOptionsScript();
                        }
                    }
                    if (StringUtil.isBlank((String)valueScript) && StringUtil.isBlank((String)validateScript) && StringUtil.isBlank((String)hiddenScript) && StringUtil.isBlank((String)hiddenPrintScript) && StringUtil.isBlank((String)readOnlyScript) && StringUtil.isBlank((String)optionsScript)) continue;
                    if (!StringUtil.isBlank((String)valueScript)) {
                        fieldCell.addElement((Element)new Paragraph("\u503c\u811a\u672c\uff1a\n" + StringUtil.dencodeHTML((String)valueScript), fontChinese));
                    }
                    if (!StringUtil.isBlank((String)validateScript)) {
                        fieldCell.addElement((Element)new Paragraph("\u6821\u9a8c\u811a\u672c\uff1a\n" + StringUtil.dencodeHTML((String)validateScript), fontChinese));
                    }
                    if (!StringUtil.isBlank((String)hiddenScript)) {
                        fieldCell.addElement((Element)new Paragraph("\u9690\u85cf\u811a\u672c\uff1a\n" + StringUtil.dencodeHTML((String)hiddenScript), fontChinese));
                    }
                    if (!StringUtil.isBlank((String)hiddenPrintScript)) {
                        fieldCell.addElement((Element)new Paragraph("\u6253\u5370\u65f6\u9690\u85cf\u811a\u672c\uff1a\n" + StringUtil.dencodeHTML((String)hiddenPrintScript), fontChinese));
                    }
                    if (!StringUtil.isBlank((String)readOnlyScript)) {
                        fieldCell.addElement((Element)new Paragraph("\u53ea\u8bfb\u811a\u672c\uff1a\n" + StringUtil.dencodeHTML((String)readOnlyScript), fontChinese));
                    }
                    if (!StringUtil.isBlank((String)optionsScript)) {
                        fieldCell.addElement((Element)new Paragraph("\u9009\u9879\u811a\u672c\uff1a\n" + StringUtil.dencodeHTML((String)optionsScript), fontChinese));
                    }
                    field_info.addCell(fieldCell);
                }
            }
            return field_info;
        }
        return null;
    }

    public String getOperationType(int keyType) {
        return FormActivtyType.activity_map.get(keyType);
    }

    public String getFieldType(String keyClassName) {
        return FormFieldType.field_map.get(keyClassName);
    }

    public static class FormFieldType {
        public static final Map<String, String> field_map = new HashMap<String, String>();

        static {
            field_map.put("InputField", "\u5355\u884c\u6587\u672c\u6846");
            field_map.put("NumberField", "\u6570\u5b57\u6846");
            field_map.put("TextAreaField", "\u591a\u884c\u6587\u672c\u6846");
            field_map.put("SelectField", "\u4e0b\u62c9\u6846");
            field_map.put("DateField", "\u65e5\u671f\u9009\u62e9\u6846");
            field_map.put("CheckboxField", "\u590d\u9009\u6846");
            field_map.put("RadioField", "\u5355\u9009\u6846");
            field_map.put("DepartmentField", "\u90e8\u95e8\u9009\u62e9\u6846");
            field_map.put("TreeDepartmentField", "\u6811\u5f62\u90e8\u95e8\u9009\u62e9\u6846");
            field_map.put("UserField", "\u7528\u6237\u9009\u62e9\u6846");
            field_map.put("SelectAboutField", "\u5de6\u53f3\u9009\u62e9\u6846");
            field_map.put("SuggestField", "\u4e0b\u62c9\u63d0\u793a\u6846");
            field_map.put("ButtonField", "\u6309\u94ae");
            field_map.put("ViewDialogField", "\u89c6\u56fe\u9009\u62e9\u6846");
            field_map.put("TabField", "\u9009\u9879\u5361");
            field_map.put("CalctextField", "\u8ba1\u7b97\u811a\u672c");
            field_map.put("IncludeField", "\u5305\u542b\u5143\u7d20");
            field_map.put("AttachmentUploadField", "\u6587\u4ef6\u4e0a\u4f20");
            field_map.put("AttachmentUploadToDataBaseField", "\u6587\u4ef6\u4e0a\u4f20\u5230\u6570\u636e\u5e93");
            field_map.put("ImageUploadField", "\u56fe\u7247\u4e0a\u4f20");
            field_map.put("ImageUploadToDataBaseField", "\u56fe\u7247\u4e0a\u4f20\u5230\u6570\u636e\u5e93");
            field_map.put("FileManagerField", "\u6587\u4ef6\u7ba1\u7406");
            field_map.put("OnLineTakePhotoField", "\u5728\u7ebf\u62cd\u7167");
            field_map.put("ReminderField", "\u5f85\u529e\u63d0\u9192");
            field_map.put("MapField", "\u5730\u56fe");
            field_map.put("WordField", "word\u7f16\u8f91\u5668");
            field_map.put("HTMLEditorField", "HTML\u7f16\u8f91\u5668");
        }
    }

    public static class FormActivtyType {
        public static final Map<Integer, String> activity_map = new HashMap<Integer, String>();

        static {
            activity_map.put(13, "\u65e0");
            activity_map.put(34, "\u4fdd\u5b58(\u4e0d\u5e26\u6d41\u7a0b)");
            activity_map.put(4, "\u4fdd\u5b58(\u5e26\u6d41\u7a0b)");
            activity_map.put(11, "\u4fdd\u5b58\u5e76\u8fd4\u56de");
            activity_map.put(12, "\u4fdd\u5b58\u5e76\u65b0\u5efa(\u5e26\u4e45\u6570\u636e)");
            activity_map.put(17, "\u4fdd\u5b58\u5e76\u65b0\u5efa(\u4e0d\u5e26\u4e45\u6570\u636e)");
            activity_map.put(19, "\u4fdd\u5b58\u8349\u7a3f(\u4e0d\u8fdb\u884c\u6821\u9a8c)");
            activity_map.put(21, "\u4fdd\u5b58\u5e76\u590d\u5236");
            activity_map.put(9, "\u4fdd\u5b58\u5e76\u5173\u95ed\u7a97\u53e3");
            activity_map.put(10, "\u8fd4\u56de");
            activity_map.put(14, "\u6253\u5370");
            activity_map.put(15, "\u5e26\u6d41\u7a0b\u5386\u53f2\u6253\u5370");
            activity_map.put(5, "\u6d41\u7a0b\u5904\u7406");
            activity_map.put(33, "\u6d41\u7a0b\u542f\u52a8");
            activity_map.put(8, "\u5173\u95ed\u7a97\u53e3");
            activity_map.put(25, "PDF\u5bfc\u51fa");
            activity_map.put(26, "\u6587\u4ef6\u4e0b\u8f7d");
            activity_map.put(28, "\u7535\u5b50\u7b7e\u7ae0");
            activity_map.put(30, "\u52a8\u6001\u6253\u5370");
            activity_map.put(32, "\u8df3\u8f6c");
        }
    }
}

