/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.overview;

import cn.myapps.common.model.datasource.DataSource;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.datasource.service.DataSourceDesignTimeService;
import cn.myapps.designtime.overview.IOverview;
import com.lowagie.text.Cell;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.util.List;

public class DataSourceOverview
implements IOverview {
    @Override
    public Table buildOverview(String applicationId) throws Exception {
        Table dTable = new Table(1);
        dTable.setPadding(2.0f);
        dTable.setSpacing(0.0f);
        dTable.setBorderWidth(1.0f);
        dTable.setWidth(100.0f);
        if (!StringUtil.isBlank((String)applicationId)) {
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontChinese = new Font(bfChinese, 10.0f, 0, Color.BLACK);
            Cell dc = new Cell();
            dc.setBackgroundColor(Color.gray);
            dc.addElement((Element)new Paragraph("\u6570\u636e\u6e90\uff1a", fontChinese));
            dTable.addCell(dc);
            dc = new Cell();
            Table dsTable = new Table(5);
            dsTable.setWidth(96.0f);
            dsTable.setPadding(0.0f);
            dsTable.setSpacing(0.0f);
            dsTable.setBorderWidth(1.0f);
            Cell cell = new Cell();
            cell.setBackgroundColor(Color.gray);
            cell.addElement((Element)new Paragraph("\u540d\u79f0 ", fontChinese));
            dsTable.addCell(cell);
            cell = new Cell();
            cell.setBackgroundColor(Color.gray);
            cell.addElement((Element)new Paragraph("\u6570\u636e\u9a71\u52a8\u7c7b ", fontChinese));
            dsTable.addCell(cell);
            cell = new Cell();
            cell.setBackgroundColor(Color.gray);
            cell.addElement((Element)new Paragraph("\u5730\u5740 ", fontChinese));
            dsTable.addCell(cell);
            cell = new Cell();
            cell.setBackgroundColor(Color.gray);
            cell.addElement((Element)new Paragraph("\u8fde\u63a5\u6c60\u5927\u5c0f ", fontChinese));
            dsTable.addCell(cell);
            cell = new Cell();
            cell.setBackgroundColor(Color.gray);
            cell.addElement((Element)new Paragraph("\u8fde\u63a5\u8d85\u65f6\u65f6\u95f4", fontChinese));
            dsTable.addCell(cell);
            DataSourceDesignTimeService dsService = DesignTimeServiceManager.dataSourceDesignTimeService();
            List dts = dsService.list(applicationId, null);
            if (dts != null) {
                for (DataSource dt : dts) {
                    if (dt == null) continue;
                    String dName = dt.getName();
                    String driver = dt.getDriverClass();
                    String url = dt.getUrl();
                    String pSize = dt.getPoolsize();
                    String timeOut = dt.getTimeout();
                    cell = new Cell();
                    cell.addElement((Element)new Paragraph(dName != null ? dName : "", fontChinese));
                    dsTable.addCell(cell);
                    cell = new Cell();
                    cell.addElement((Element)new Paragraph(driver != null ? driver : "", fontChinese));
                    dsTable.addCell(cell);
                    cell = new Cell();
                    cell.addElement((Element)new Paragraph(url != null ? url : "", fontChinese));
                    dsTable.addCell(cell);
                    cell = new Cell();
                    cell.addElement((Element)new Paragraph(pSize != null ? pSize : "", fontChinese));
                    dsTable.addCell(cell);
                    cell = new Cell();
                    cell.addElement((Element)new Paragraph(timeOut != null ? timeOut : "", fontChinese));
                    dsTable.addCell(cell);
                }
            }
            dc.addElement((Element)dsTable);
            dTable.addCell(dc);
        }
        return dTable;
    }
}

