/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.module.controller;

import cn.myapps.common.model.module.Module;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.module.service.ModuleDesignTimeService;
import cn.myapps.designtime.module.service.ModuleDwrService;
import cn.myapps.util.StringUtil;
import cn.myapps.util.sequence.Sequence;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Component
@RequestMapping(value={"/api/designtime"})
@Scope(value="prototype")
public class ModuleDesignTimeController
extends AbstractDesignTimeController {
    private ModuleDesignTimeService moduleService = DesignTimeServiceManager.moduleDesignTimeService();

    @GetMapping(value={"/applications/{applicationId}/modules"})
    @ApiOperation(value="\u6839\u636e\u4e0a\u7ea7\u83b7\u53d6\u6a21\u5757\u5217\u8868", notes="\u6839\u636e\u4e0a\u7ea7\u83b7\u53d6\u6a21\u5757\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="parentId", value="\u4e0a\u7ea7Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6Id", required=true, paramType="path", dataType="string")})
    public Resource getModulesByParentId(@PathVariable String applicationId, String parentId) {
        try {
            if (StringUtil.isBlank((String)parentId)) {
                parentId = applicationId;
            }
            ArrayList list = new ArrayList();
            List modules = this.moduleService.getChildsByParentId(parentId, "");
            for (Module module : modules) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", module.getName());
                map.put("id", module.getId());
                map.put("superior", module.getSuperior());
                map.put("uri", module.getUri());
                map.put("applicationId", module.getApplicationid());
                List subModules = this.moduleService.getChildsByParentId(module.getId(), null);
                if (subModules != null && !subModules.isEmpty()) {
                    map.put("hasChild", false);
                } else {
                    map.put("hasChild", true);
                }
                list.add(map);
            }
            return this.success("ok", list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(value={"/applications/modules/{moduleId}"})
    @ApiOperation(value="\u83b7\u53d6\u6a21\u5757\u8be6\u60c5", notes="\u83b7\u53d6\u6a21\u5757\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="moduleId", value="\u6a21\u5757Id", required=true, paramType="path", dataType="string")})
    public Resource getModule(@PathVariable String moduleId) {
        try {
            Module module = (Module)this.moduleService.findById(moduleId);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", module.getId());
            map.put("name", module.getName());
            map.put("orderNo", module.getOrderNo());
            map.put("description", module.getDescription());
            map.put("uri", module.getUri());
            map.put("superior", module.getSuperior());
            if (!StringUtil.isBlank((String)module.getSuperior())) {
                Module parentModule = (Module)this.moduleService.findById(module.getSuperior());
                map.put("superiorName", parentModule.getName());
            } else {
                map.put("superiorName", "");
            }
            return this.success("ok", map);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(value={"/applications/{applicationId}/modules"})
    @ApiOperation(value="\u65b0\u5efa\u6a21\u5757", notes="\u65b0\u5efa\u6a21\u5757")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6Id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u6a21\u5757\u6570\u636e\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource createModule(@PathVariable String applicationId, @RequestBody String content) {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            Module module = (Module)this.json2obj(json, Module.class);
            if (StringUtil.isBlank((String)module.getSuperior())) {
                module.setParentId(applicationId);
            } else {
                module.setParentId(module.getSuperior());
            }
            module.setApplicationid(applicationId);
            String validateMessage = this.validate(module);
            if (!StringUtil.isBlank((String)validateMessage)) {
                return this.error(40001, validateMessage, null);
            }
            module.setId(Sequence.getDesignTimeSequence());
            this.moduleService.save((Object)module);
            JSONObject result = new JSONObject();
            result.put((Object)"id", (Object)module.getId());
            return this.success("ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(value={"/applications/{applicationId}/modules/{moduleId}"})
    @ApiOperation(value="\u66f4\u65b0\u6a21\u5757", notes="\u66f4\u65b0\u6a21\u5757")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6Id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="moduleId", value="\u6a21\u5757Id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u6a21\u5757\u6570\u636e\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource updateModule(@PathVariable String applicationId, @PathVariable String moduleId, @RequestBody String content) {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            String name = json.getString("name");
            String description = json.getString("description");
            int orderNo = json.getInt("orderNo");
            String superior = json.getString("superior");
            Module oldModule = (Module)this.moduleService.findById(moduleId);
            Module module = Module.clone((Module)oldModule);
            module.setDescription(description);
            module.setOrderNo(orderNo);
            module.setSuperior(superior);
            if (StringUtil.isBlank((String)module.getSuperior())) {
                module.setParentId(applicationId);
            } else {
                module.setParentId(module.getSuperior());
            }
            module.setName(name);
            String validateMessage = this.validate(module);
            if (!StringUtil.isBlank((String)validateMessage)) {
                return this.error(40001, validateMessage, null);
            }
            this.moduleService.update((Object)module);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(value={"/applications/modules"})
    @ApiOperation(value="\u5220\u9664\u6a21\u5757", notes="\u5220\u9664\u6a21\u5757")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource deleteModule(@RequestBody String[] ids) {
        try {
            this.moduleService.delete(ids);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(value={"/applications/{applicationId}/allmodules"})
    @ApiOperation(value="\u83b7\u53d6\u6811\u5f62\u7ed3\u6784\u6240\u6709\u6a21\u5757\u5217\u8868", notes="\u83b7\u53d6\u6811\u5f62\u7ed3\u6784\u6240\u6709\u6a21\u5757\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6Id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="currentModuleId", value="\u5f53\u524d\u6a21\u5757id", required=false, paramType="query", dataType="string")})
    public Resource getTreeModule(@PathVariable String applicationId, String currentModuleId) {
        try {
            ModuleDwrService moduleService = new ModuleDwrService();
            Map map = moduleService.getModuleSelected(applicationId, currentModuleId);
            ArrayList list = new ArrayList();
            for (String key : map.keySet()) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("id", key);
                data.put("value", (String)map.get(key));
                list.add(data);
            }
            return this.success("ok", list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    private String validate(Module module) throws Exception {
        if (StringUtil.isBlank((String)module.getName())) {
            return "\u6a21\u5757\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        List list = this.moduleService.list(module.getParentId(), "");
        for (Module m : list) {
            if (StringUtil.isBlank((String)module.getId())) {
                if (m.getName().equals(module.getName()) && m.getParentId().equals(module.getParentId())) {
                    return "\u540c\u7ea7\u6a21\u5757\u540d\u79f0\u5df2\u5b58\u5728!";
                }
                if (!(module.getParent() instanceof Module) || !m.getName().equals(module.getName()) || !module.getParent().getName().equals(m.getName())) continue;
                return "\u540d\u79f0\u4e0d\u53ef\u4ee5\u8ddf\u4e0a\u7ea7\u76f8\u540c!";
            }
            if (m.getName().equals(module.getName()) && m.getParentId().equals(module.getParentId()) && !module.getId().equals(m.getId())) {
                return "\u540c\u7ea7\u6a21\u5757\u540d\u79f0\u5df2\u5b58\u5728!";
            }
            if (module.getParent() instanceof Module && m.getName().equals(module.getName()) && module.getParent().getName().equals(m.getName()) && !module.getId().equals(m.getId())) {
                return "\u540d\u79f0\u4e0d\u53ef\u4ee5\u8ddf\u4e0a\u7ea7\u76f8\u540c!";
            }
            if (!module.getName().equals(m.getName()) || !m.getParentId().equals(module.getId())) continue;
            return "\u4e0b\u7ea7\u5b58\u5728\u76f8\u540c\u540d\u79f0!";
        }
        return null;
    }
}

