/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.menu.controller;

import cn.myapps.common.Environment;
import cn.myapps.common.FileSystemDesignTimeSerializable;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.report.Report;
import cn.myapps.common.model.resource.ResourceVO;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.menu.controller.ResourceUtil;
import cn.myapps.designtime.report.service.ReportDesignTimeService;
import cn.myapps.designtime.resource.service.ResourceDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.util.sequence.Sequence;
import com.jayway.jsonpath.JsonPath;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.sf.json.JSONObject;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Api(tags={"\u83dc\u5355\u8bbe\u8ba1\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime/applications"}, produces={"application/json;charset=UTF-8"})
public class MenuController
extends AbstractDesignTimeController {
    private ResourceDesignTimeService resourceDesignTimeService = DesignTimeServiceManager.resourceDesignTimeService();

    @GetMapping(path={"/{applicationId}/menus"})
    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355\u5217\u8868", notes="\u83b7\u53d6\u83dc\u5355\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="isMobile", value="\u662f\u5426\u79fb\u52a8\u7aef", required=true, paramType="query", dataType="boolean"), @ApiImplicitParam(name="parentId", value="\u7236\u7ea7id", required=false, paramType="query", dataType="string")})
    public Resource doGetMenusList(@PathVariable String applicationId, @RequestParam boolean isMobile, String parentId) throws Exception {
        try {
            ArrayList list = new ArrayList();
            List menusList = new ArrayList();
            if (StringUtil.isBlank((String)parentId)) {
                parentId = applicationId;
            }
            menusList = isMobile ? this.resourceDesignTimeService.getChildsByParentId(parentId, "mobilemenu", "mobilemenu", "") : this.resourceDesignTimeService.getChildsByParentId(parentId, "");
            for (ResourceVO resourceVO : menusList) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", resourceVO.getName());
                map.put("id", resourceVO.getId());
                map.put("superior", resourceVO.getSuperior());
                map.put("uri", resourceVO.getUri());
                map.put("applicationId", resourceVO.getApplicationid());
                map.put("permissionType", resourceVO.getPermissionType());
                List subMenus = isMobile ? this.resourceDesignTimeService.getChildsByParentId(resourceVO.getId(), "mobilemenu", "mobilemenu", "") : this.resourceDesignTimeService.getChildsByParentId(resourceVO.getId(), "");
                if (subMenus != null && !subMenus.isEmpty()) {
                    map.put("hasChild", false);
                } else {
                    map.put("hasChild", true);
                }
                list.add(map);
            }
            return this.success("ok", list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/menus/{menuId}"})
    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355\u8be6\u60c5", notes="\u83b7\u53d6\u83dc\u5355\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="menuId", value="\u83dc\u5355id", required=true, paramType="path", dataType="string")})
    public Resource doGetMenuDetailed(@PathVariable String menuId) throws Exception {
        try {
            ResourceVO menu = (ResourceVO)this.resourceDesignTimeService.findById(menuId);
            if (!StringUtil.isBlank((String)menu.getLinkType()) && menu.getLinkType().equals("09") && StringUtil.isBlank((String)menu.getModuleid())) {
                ReportDesignTimeService reportService = DesignTimeServiceManager.reportDesignTimeService();
                String reportId = menu.getActionContent().substring(menu.getActionContent().indexOf("=") + 1);
                Report report = (Report)reportService.findById(reportId);
                menu.setActionContent(reportId);
                menu.setModuleid(report.getParentId());
            }
            return this.success("ok", menu);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/menus/copy"})
    @ApiOperation(value="\u590d\u5236\u83dc\u5355", notes="\u590d\u5236\u83dc\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="destid", value="\u76ee\u6807\u4e0a\u7ea7\u83dc\u5355", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="isMobile", value="\u662f\u5426\u79fb\u52a8\u7aef", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="ids", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCopyMenus(@PathVariable String applicationId, @RequestBody String[] ids, @RequestParam String destid, @RequestParam String isMobile) {
        try {
            ApplicationDesignTimeService appService = DesignTimeServiceManager.applicationDesignTimeService();
            ResourceDesignTimeService resourceService = DesignTimeServiceManager.resourceDesignTimeService();
            ResourceVO parent = resourceService.doView(destid);
            String parentId = "";
            if (parent != null) {
                parentId = parent.getId();
            }
            if (isMobile.equals("true")) {
                for (int i = 0; i < ids.length; ++i) {
                    ResourceVO copyMenu = resourceService.doView(ids[i]);
                    ResourceVO menu = ResourceVO.clone((ResourceVO)copyMenu);
                    if (parent != null) {
                        menu.setParent((FileSystemDesignTimeSerializable)parent);
                        menu.setParentId(parentId);
                    } else {
                        Application application = (Application)appService.findById(applicationId);
                        menu.setParent((FileSystemDesignTimeSerializable)application);
                        menu.setParentId(applicationId);
                    }
                    menu.setId("");
                    menu.setSuperior(parentId);
                    menu.setUri("");
                    menu.setIsMobile("false");
                    resourceService.save((Object)menu);
                }
            } else {
                for (int i = 0; i < ids.length; ++i) {
                    ResourceVO copyMenu = resourceService.doView(ids[i]);
                    ResourceVO menu = ResourceVO.clone((ResourceVO)copyMenu);
                    String linkType = menu.getLinkType();
                    if (!(StringUtil.isBlank((String)linkType) || "00".equals(linkType) || "01".equals(linkType) || "02".equals(linkType) || "09".equals(linkType) || "12".equals(linkType))) {
                        menu.setLinkType("");
                        menu.setActionContent("");
                    }
                    if (parent != null) {
                        menu.setParent((FileSystemDesignTimeSerializable)parent);
                        menu.setParentId(parentId);
                    } else {
                        Application application = (Application)appService.findById(applicationId);
                        menu.setParent((FileSystemDesignTimeSerializable)application);
                        menu.setParentId(applicationId);
                        menu.setActionContent("");
                    }
                    menu.setId("");
                    menu.setSuperior(parentId);
                    menu.setUri("");
                    menu.setIsMobile("true");
                    resourceService.save((Object)menu);
                }
            }
            return this.success("ok", "\u6210\u529f\u590d\u5236\u83dc\u5355");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/menus"})
    @ApiOperation(value="\u65b0\u5efa\u83dc\u5355", notes="\u65b0\u5efa\u83dc\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="isMobile", value="\u662f\u5426\u79fb\u52a8\u7aef", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateMenu(@PathVariable String applicationId, @RequestParam String isMobile, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            ResourceVO menu = (ResourceVO)this.json2obj(json, ResourceVO.class);
            menu.setApplicationid(applicationId);
            String superiorId = menu.getSuperior();
            if (superiorId != null && !"".equals(superiorId)) {
                menu.setParentId(superiorId);
            } else {
                menu.setParentId(applicationId);
            }
            String menuId = Sequence.getDesignTimeSequence();
            menu.setId(menuId);
            menu.setIsMobile(isMobile);
            menu.setDescription(menu.getName());
            String validateMessage = this.validate(menu);
            if (!StringUtil.isBlank((String)validateMessage)) {
                return this.error(40001, validateMessage, null);
            }
            this.resourceDesignTimeService.saveOrUpdate((Object)menu);
            JSONObject menuJson = new JSONObject();
            menuJson.put((Object)"id", (Object)menuId);
            return this.success("ok", menuJson);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/{applicationId}/menus/{menuId}"})
    @ApiOperation(value="\u66f4\u65b0\u8868\u5355", notes="\u66f4\u65b0\u8868\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="superiorId", value="\u4e0a\u7ea7\u83dc\u5355id", required=false, paramType="path", dataType="string"), @ApiImplicitParam(name="menuId", value="\u83dc\u5355id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdateMenu(@PathVariable String applicationId, String superiorId, @PathVariable String menuId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            ResourceVO menu = (ResourceVO)this.json2obj(json, ResourceVO.class);
            menu.setApplicationid(applicationId);
            if (menu.getSuperior() != null && !"".equals(menu.getSuperior())) {
                menu.setParentId(menu.getSuperior());
            } else {
                menu.setParentId(applicationId);
            }
            menu.setDescription(menu.getName());
            menu.setId(menuId);
            String validateMessage = this.validate(menu);
            if (!StringUtil.isBlank((String)validateMessage)) {
                return this.error(40001, validateMessage, null);
            }
            this.resourceDesignTimeService.saveOrUpdate((Object)menu);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/menus"})
    @ApiOperation(value="\u5220\u9664\u83dc\u5355", notes="\u5220\u9664\u83dc\u5355\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doDeleteMenu(@RequestBody String content) throws Exception {
        try {
            List ids = (List)JsonPath.parse((String)content).json();
            String[] idArray = new String[]{};
            idArray = ids.toArray(idArray);
            this.resourceDesignTimeService.delete(idArray);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/form/{formId}/menus"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355\u521b\u5efa\u83dc\u5355", notes="\u6839\u636e\u8868\u5355\u521b\u5efa\u83dc\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6Id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="formId", value="\u8868\u5355Id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateMenuByForm(@PathVariable String applicationId, @PathVariable String formId, @RequestBody String content) throws Exception {
        try {
            FormDesignTimeService fp = DesignTimeServiceManager.formDesignTimeService();
            Form f = (Form)fp.findById(formId);
            if (f == null) {
                return this.error(500, "{*[\u9875\u9762\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\uff01]*}", null);
            }
            JSONObject json = JSONObject.fromObject((Object)content);
            String name = (String)json.get("name");
            String superior = (String)json.get("superior");
            String showType = (String)json.get("showType");
            ResourceVO from_rVO = new ResourceVO();
            if (StringUtil.isBlank((String)superior)) {
                from_rVO.setParentId(applicationId);
                ApplicationDesignTimeService applicationService = DesignTimeServiceManager.applicationDesignTimeService();
                FileSystemDesignTimeSerializable parent = (FileSystemDesignTimeSerializable)applicationService.findById(applicationId);
                from_rVO.setParent(parent);
            } else {
                from_rVO.setParentId(superior);
                ResourceDesignTimeService resourceService = DesignTimeServiceManager.resourceDesignTimeService();
                ResourceVO parent = resourceService.doView(superior);
                from_rVO.setParent((FileSystemDesignTimeSerializable)parent);
            }
            if ("mobile".equals(showType)) {
                from_rVO.setType("100");
                from_rVO.setIsMobile("true");
            } else {
                from_rVO.setType("00");
                from_rVO.setIsMobile("false");
            }
            from_rVO.setLinkName(name);
            from_rVO.setSuperior(superior);
            from_rVO.setDescription(name);
            from_rVO.setActionContent(formId);
            from_rVO.setLinkName(name);
            from_rVO.setApplicationid(f.getApplicationid());
            from_rVO.setLinkType(ResourceVO.LinkType.FORM.getCode());
            from_rVO.setQueryString("[]");
            from_rVO.setOpentarget("detail");
            from_rVO.setModuleid(f.getParentId());
            from_rVO.setDescription(from_rVO.getName());
            from_rVO.setApplicationid(f.getApplicationid());
            from_rVO.setName(name);
            ResourceDesignTimeService rp = DesignTimeServiceManager.resourceDesignTimeService();
            if (!rp.validateDoCreateMenu(from_rVO)) {
                throw new OBPMValidateException("{*[page.name.notexist]*}");
            }
            rp.saveOrUpdate((Object)from_rVO);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/view/{viewId}/menus"})
    @ApiOperation(value="\u6839\u636e\u89c6\u56fe\u521b\u5efa\u83dc\u5355", notes="\u6839\u636e\u89c6\u56fe\u521b\u5efa\u83dc\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6Id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="viewId", value="\u89c6\u56feId", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateMenuByView(@PathVariable String applicationId, @PathVariable String viewId, @RequestBody String content) throws Exception {
        try {
            ViewDesignTimeService vp = DesignTimeServiceManager.viewDesignTimeService();
            AbstractView v = (AbstractView)vp.findById(viewId);
            if (v == null) {
                return this.error(500, "{*[\u9875\u9762\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\uff01]*}", null);
            }
            JSONObject json = JSONObject.fromObject((Object)content);
            String name = (String)json.get("name");
            String superior = (String)json.get("superior");
            String showType = (String)json.get("showType");
            ResourceVO view_rVO = new ResourceVO();
            if ("mobile".equals(showType)) {
                view_rVO.setType("100");
                view_rVO.setIsMobile("true");
            } else {
                view_rVO.setType("00");
                view_rVO.setIsMobile("false");
            }
            if (StringUtil.isBlank((String)superior)) {
                view_rVO.setParentId(applicationId);
                ApplicationDesignTimeService applicationService = DesignTimeServiceManager.applicationDesignTimeService();
                FileSystemDesignTimeSerializable parent = (FileSystemDesignTimeSerializable)applicationService.findById(applicationId);
                view_rVO.setParent(parent);
            } else {
                view_rVO.setParentId(superior);
                ResourceDesignTimeService resourceService = DesignTimeServiceManager.resourceDesignTimeService();
                ResourceVO parent = resourceService.doView(superior);
                view_rVO.setParent((FileSystemDesignTimeSerializable)parent);
            }
            view_rVO.setSuperior(superior);
            view_rVO.setLinkName(name);
            view_rVO.setDescription(name);
            view_rVO.setActionContent(viewId);
            view_rVO.setApplicationid(v.getApplicationid());
            view_rVO.setLinkName(name);
            view_rVO.setLinkType(ResourceVO.LinkType.VIEW.getCode());
            view_rVO.setQueryString("[]");
            view_rVO.setOpentarget("detail");
            view_rVO.setModuleid(v.getParentId());
            view_rVO.setApplicationid(v.getApplicationid());
            view_rVO.setName(name);
            ResourceDesignTimeService rp = DesignTimeServiceManager.resourceDesignTimeService();
            if (!rp.validateDoCreateMenu(view_rVO)) {
                throw new OBPMValidateException("{*[page.name.notexist]*}");
            }
            rp.saveOrUpdate((Object)view_rVO);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/{applicationId}/menu/getAllMenus"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u83dc\u5355", notes="\u83b7\u53d6\u6240\u6709\u83dc\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6Id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="showType", value="\u7c7b\u578b", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="type", value="\u83dc\u5355\u7c7b\u578b", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="currentMenuId", value="\u5f53\u524d\u83dc\u5355id", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="name", value="\u83dc\u5355\u540d\u79f0", required=false, paramType="query", dataType="string")})
    public Resource getAllMenus(@RequestParam(required=false, defaultValue="") String currentMenuId, @RequestParam(required=false, defaultValue="") String type, @PathVariable String applicationId, @RequestParam String showType, String name) {
        ResourceUtil resourceUtil = new ResourceUtil();
        try {
            Map<String, String> dm = new HashMap<String, String>();
            if (type != null) {
                List resources;
                ParamsTable params = new ParamsTable();
                ResourceDesignTimeService proxy = DesignTimeServiceManager.resourceDesignTimeService();
                params.setParameter("_orderby", (Object)"orderno");
                ArrayList<ResourceVO> dc = new ArrayList();
                if (showType.equals("pc")) {
                    resources = proxy.list(applicationId, "menu", "menu", null);
                    for (ResourceVO resourceVO : resources) {
                        if (!resourceVO.getUri().endsWith(".menu")) continue;
                        dc.add(resourceVO);
                    }
                } else if (showType.equals("mobile")) {
                    resources = proxy.list(applicationId, "mobilemenu", "mobilemenu", null);
                    for (ResourceVO resourceVO : resources) {
                        if (!applicationId.equals(resourceVO.getParentId())) continue;
                        dc.add(resourceVO);
                    }
                } else {
                    dc = proxy.list(applicationId, "menu", "menu", null);
                    resources = proxy.list(applicationId, "mobilemenu", "mobilemenu", null);
                    dc.addAll(resources);
                }
                dm = ResourceUtil.deepSearchMenuTree(dc, null, currentMenuId, 0);
            } else {
                dm.put("", "\u65e0");
            }
            ArrayList list = new ArrayList();
            for (String key : dm.keySet()) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("id", key);
                data.put("value", (String)dm.get(key));
                list.add(data);
            }
            return this.success("ok", list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(value={"/icons"})
    @ApiOperation(value="\u83b7\u53d6\u56fe\u6807\u96c6\u5408", notes="\u83b7\u53d6\u56fe\u6807\u96c6\u5408")
    public Resource getIcons() {
        try {
            File dir;
            File[] files;
            ArrayList<IconLibFile> rtn = new ArrayList<IconLibFile>();
            Environment ev = Environment.getInstance();
            ParamsTable params = this.getParams();
            String dirPath = params.getParameterAsString("path");
            String path = PropertyUtil.getPath() + "/uploads/lib/icon";
            String uploadsPath = "/uploads/lib/icon";
            if (!StringUtil.isBlank((String)dirPath)) {
                path = PropertyUtil.getPath() + dirPath;
                uploadsPath = dirPath;
            }
            if (ev != null && (files = (dir = new File(path)).listFiles()) != null && files.length > 0) {
                DecimalFormat format = new DecimalFormat("#.##");
                for (int i = 0; i < files.length; ++i) {
                    IconLibFile icon;
                    if (files[i].isDirectory()) {
                        icon = new IconLibFile();
                        icon.setName(files[i].getName());
                        icon.setPath(uploadsPath + "/" + files[i].getName());
                        icon.setFileType(2);
                        rtn.add(icon);
                        continue;
                    }
                    if (!this.isImageFile(files[i].getName())) continue;
                    icon = new IconLibFile();
                    BufferedImage bufferedImage = ImageIO.read(files[i]);
                    icon.setSize(bufferedImage.getWidth() + " x " + bufferedImage.getHeight());
                    icon.setLength(format.format((double)files[i].length() / 1024.0) + " KB");
                    icon.setName(files[i].getName());
                    icon.setWidth(bufferedImage.getWidth());
                    icon.setPath(uploadsPath + "/" + files[i].getName());
                    icon.setFileType(1);
                    rtn.add(icon);
                }
            }
            return this.success("ok", rtn);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @DeleteMapping(path={"/icon"})
    @ApiOperation(value="\u5220\u9664\u81ea\u5b9a\u4e49\u56fe\u6807", notes="\u5220\u9664\u81ea\u5b9a\u4e49\u56fe\u6807")
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", value="\u56fe\u6807\u8def\u5f84", required=true, paramType="path", dataType="string")})
    public Resource doDeleteIcon(@RequestBody String[] path) throws Exception {
        for (int i = 0; i < path.length; ++i) {
            String realPath = PropertyUtil.getPath() + path[i];
            File icon = new File(realPath);
            if (!icon.exists()) {
                return this.error(4001, "\u56fe\u6807\u4e0d\u5b58\u5728", null);
            }
            icon.delete();
        }
        return this.success("ok", "\u5220\u9664\u6210\u529f");
    }

    private boolean isImageFile(String name) {
        return (name = name.toLowerCase()).indexOf("png") >= 0 || name.indexOf("ico") >= 0 || name.indexOf(".gif") >= 0 || name.indexOf(".jpg") >= 0 || name.indexOf(".jpeg") >= 0 || name.indexOf(".bmp") >= 0;
    }

    private String validate(ResourceVO resourceVO) throws Exception {
        if (StringUtil.isBlank((String)resourceVO.getName())) {
            return "\u83dc\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        List list = this.resourceDesignTimeService.list(resourceVO.getParentId(), "");
        for (ResourceVO r : list) {
            if (StringUtil.isBlank((String)resourceVO.getId())) {
                if (r.getName().equals(resourceVO.getName()) && r.getParentId().equals(resourceVO.getParentId()) && r.getFileSuffix().equals(resourceVO.getFileSuffix())) {
                    return "\u540c\u7ea7\u83dc\u5355\u540d\u79f0\u5df2\u5b58\u5728!";
                }
                if (!(resourceVO.getParent() instanceof ResourceVO) || !r.getName().equals(resourceVO.getName()) || !resourceVO.getParent().getName().equals(r.getName())) continue;
                return "\u540d\u79f0\u4e0d\u53ef\u4ee5\u8ddf\u4e0a\u7ea7\u76f8\u540c!";
            }
            if (r.getName().equals(resourceVO.getName()) && r.getParentId().equals(resourceVO.getParentId()) && !resourceVO.getId().equals(r.getId()) && r.getFileSuffix().equals(resourceVO.getFileSuffix())) {
                return "\u540c\u7ea7\u83dc\u5355\u540d\u79f0\u5df2\u5b58\u5728!";
            }
            if (!(resourceVO.getParent() instanceof ResourceVO) || !r.getName().equals(resourceVO.getName()) || !resourceVO.getParent().getName().equals(r.getName()) || resourceVO.getId().equals(r.getId())) continue;
            return "\u540d\u79f0\u4e0d\u53ef\u4ee5\u8ddf\u4e0a\u7ea7\u76f8\u540c!";
        }
        return null;
    }

    public class IconLibFile {
        public static final int IMAGE = 1;
        public static final int DIR = 2;
        private String name;
        private String size;
        private String length;
        private int width;
        private String path;
        private int fileType;

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSize() {
            return this.size;
        }

        public void setSize(String size) {
            this.size = size;
        }

        public String getLength() {
            return this.length;
        }

        public void setLength(String length) {
            this.length = length;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public int getFileType() {
            return this.fileType;
        }

        public void setFileType(int fileType) {
            this.fileType = fileType;
        }
    }
}

