/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.form.controller;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.model.table.Confirm;
import cn.myapps.common.model.table.NeedConfirmException;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.activity.controller.ActivityUtil;
import cn.myapps.designtime.activity.service.ActivityDesignTimeService;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.helper.service.HelpHelper;
import cn.myapps.designtime.helper.toc.ITopic;
import cn.myapps.designtime.helper.toc.TocFileParser;
import cn.myapps.designtime.helper.toc.impl.Toc;
import cn.myapps.runtime.dynaform.document.dql.DQLASTUtil;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.form.ejb.CalctextField;
import cn.myapps.runtime.dynaform.form.ejb.FileManagerField;
import cn.myapps.runtime.dynaform.form.ejb.FlowHistoryField;
import cn.myapps.runtime.dynaform.form.ejb.FlowReminderHistoryField;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.FormField;
import cn.myapps.runtime.dynaform.form.ejb.HTMLEditorField;
import cn.myapps.runtime.dynaform.form.ejb.ImageUploadToDataBaseField;
import cn.myapps.runtime.dynaform.form.ejb.IncludeField;
import cn.myapps.runtime.dynaform.form.ejb.InputField;
import cn.myapps.runtime.dynaform.form.ejb.ReminderField;
import cn.myapps.runtime.dynaform.form.ejb.SelectAboutField;
import cn.myapps.runtime.dynaform.form.ejb.SuggestField;
import cn.myapps.runtime.dynaform.form.ejb.TabField;
import cn.myapps.runtime.dynaform.form.ejb.TextareaField;
import cn.myapps.runtime.dynaform.form.ejb.ViewDialogField;
import cn.myapps.runtime.dynaform.form.ejb.mapping.ColumnMapping;
import cn.myapps.runtime.dynaform.form.ejb.mapping.TableMapping;
import cn.myapps.runtime.dynaform.form.helper.FormHelper;
import cn.myapps.runtime.macro.runner.IRunner;
import cn.myapps.runtime.macro.runner.JavaScriptFactory;
import cn.myapps.util.http.CookieUtil;
import cn.myapps.util.sequence.Sequence;
import com.jayway.jsonpath.JsonPath;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u8868\u5355\u8bbe\u8ba1\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime/applications"}, produces={"application/json;charset=UTF-8"})
public class FormController
extends AbstractDesignTimeController {
    private FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
    private ActivityDesignTimeService activityService = DesignTimeServiceManager.activityDesignTimeService();

    @GetMapping(path={"/modules/{moduleId}/forms"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u5217\u8868", notes="\u83b7\u53d6\u8868\u5355\u5217\u8868\uff08\u53ef\u6839\u636e\u540d\u5b57\u6216\u8005\u63cf\u8ff0\u67e5\u8be2\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="moduleId", value="\u6a21\u5757id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="name", value="\u540d\u79f0", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="description", value="\u63cf\u8ff0", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="type", value="\u8868\u5355\u7c7b\u578b", required=false, paramType="query", dataType="String"), @ApiImplicitParam(name="pageNo", value="\u5f53\u524d\u9875\u6570", required=true, paramType="query", dataType="String"), @ApiImplicitParam(name="linesPerPage", value="\u6bcf\u9875\u884c\u6570", required=true, paramType="query", dataType="String")})
    public Resource doGetFormList(@PathVariable String moduleId, @RequestParam(required=false) String name, String description, @RequestParam(required=false) String type, String pageNo, String linesPerPage) throws Exception {
        int page = pageNo != null && pageNo.length() > 0 ? Integer.parseInt(pageNo) : 1;
        int line = linesPerPage != null && linesPerPage.length() > 0 ? Integer.parseInt(linesPerPage) : 10;
        int formType = type != null && type.length() > 0 ? Integer.parseInt(type) : 0;
        try {
            DataPackage forms = new DataPackage();
            forms = this.formService.queryByNameOrDescript(moduleId, name, page, line);
            Collection formsList = forms.getDatas();
            JSONArray formArray = new JSONArray();
            if (formType != 0) {
                for (Form form : formsList) {
                    if (form.getType() != formType) continue;
                    String formId = form.getId();
                    String formName = form.getName();
                    String formDiscription = form.getDescription();
                    int formOrderno = form.getOrderno();
                    JSONObject formJson = new JSONObject();
                    formJson.put((Object)"id", (Object)formId);
                    formJson.put((Object)"name", (Object)formName);
                    formJson.put((Object)"description", (Object)formDiscription);
                    formJson.put((Object)"orderno", (Object)formOrderno);
                    formArray.add((Object)formJson);
                }
                return this.success("ok", formArray);
            }
            return this.success("ok", forms);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/modules/forms/{formId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u8be6\u60c5", notes="\u83b7\u53d6\u8868\u5355\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="formId", value="\u8868\u5355id", required=true, paramType="path", dataType="string")})
    public Resource doGetFormDetailed(@PathVariable String formId) throws Exception {
        try {
            Form form = (Form)this.formService.findById(formId);
            return this.success("ok", form);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/modules/{moduleId}/forms"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u65b0\u5efa\u8868\u5355", notes="\u65b0\u5efa\u8868\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="moduleId", value="\u6a21\u5757id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateForm(@PathVariable String applicationId, @PathVariable String moduleId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            Form form = (Form)this.json2obj(json, Form.class);
            form.setApplicationid(applicationId);
            form.setParentId(moduleId);
            String formId = Sequence.getDesignTimeSequence();
            form.setId(formId);
            this.doSaveValidate(form);
            this.formService.doCreate(form);
            JSONObject formJson = new JSONObject();
            formJson.put((Object)"id", (Object)formId);
            return this.success("ok", formJson);
        }
        catch (OBPMValidateException ex) {
            ex.printStackTrace();
            return this.error(40001, ex.getValidateMessage(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/{applicationId}/modules/{moduleId}/forms/{formId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u8868\u5355", notes="\u66f4\u65b0\u8868\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="moduleId", value="\u6a21\u5757id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="formId", value="\u8868\u5355id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdateForm(@PathVariable String applicationId, @PathVariable String moduleId, @PathVariable String formId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            Form form = (Form)this.json2obj(json, Form.class);
            form.setApplicationid(applicationId);
            form.setParentId(moduleId);
            form.setId(formId);
            this.doSaveValidate(form);
            this.formService.doUpdate(form);
            return this.success("ok", null);
        }
        catch (OBPMValidateException ex) {
            ex.printStackTrace();
            if (ex.getCause() != null && ex.getCause() instanceof NeedConfirmException) {
                Collection confirms = null;
                NeedConfirmException cause = (NeedConfirmException)ex.getCause();
                confirms = cause.getConfirms();
                Iterator iterator = confirms.iterator();
                if (iterator.hasNext()) {
                    Confirm confirm = (Confirm)iterator.next();
                    return this.error(40001, confirm.getMessage(), null);
                }
                return this.error(40001, ex.getValidateMessage(), null);
            }
            return this.error(40001, ex.getValidateMessage(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/modules/forms"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u8868\u5355", notes="\u5220\u9664\u8868\u5355\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doDeleteForm(@RequestBody String content) throws Exception {
        try {
            List ids = (List)JsonPath.parse((String)content).json();
            String[] idArray = new String[]{};
            idArray = ids.toArray(idArray);
            this.formService.delete(idArray);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/modules/forms/{formId}/fields"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u5b57\u6bb5\u5217\u8868", notes="\u83b7\u53d6\u8868\u5355\u5b57\u6bb5\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="formId", value="\u8868\u5355id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="type", value="\u83b7\u53d6\u5b57\u6bb5\u7684\u7c7b\u578b", required=false, paramType="query", dataType="string")})
    public Resource doGetFormField(@PathVariable String formId, @RequestParam(required=false) String type) throws Exception {
        try {
            JSONArray fieldArray = new JSONArray();
            Form form = (Form)this.formService.findById(formId);
            if (form != null) {
                form.inited();
                Collection colls = form.getAllFields();
                IRunner runner = JavaScriptFactory.getInstance((String)"", (String)form.getApplicationid());
                runner.initBSFManager((IDocument)new Document(), new ParamsTable(), (IUser)this.getUser(), new ArrayList());
                for (FormField field : colls) {
                    if (type == null && (field instanceof IncludeField || field instanceof HTMLEditorField || field instanceof TabField || field instanceof CalctextField || field instanceof FlowHistoryField || field instanceof FileManagerField || field instanceof ImageUploadToDataBaseField || field instanceof ViewDialogField || field instanceof ReminderField || field instanceof FlowReminderHistoryField) || type != null && "eventMapping".equals(type) && !(field instanceof InputField) && !(field instanceof SuggestField) || type != null && "dataMapping".equals(type) && !(field instanceof TextareaField)) continue;
                    JSONObject fieldJson = new JSONObject();
                    fieldJson.put((Object)"id", (Object)field.getId());
                    fieldJson.put((Object)"name", (Object)field.getName());
                    String discript = field.getDiscript(runner);
                    fieldJson.put((Object)"discript", (Object)discript);
                    fieldJson.put((Object)"type", (Object)field.getFieldtype());
                    fieldArray.add((Object)fieldJson);
                }
            }
            return this.success("ok", fieldArray);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/modules/forms/{formId}/clearFields"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u6e05\u9664\u6570\u636e\u5b57\u6bb5\u5217\u8868", notes="\u83b7\u53d6\u8868\u5355\u6e05\u9664\u6570\u636e\u5b57\u6bb5\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="formId", value="\u8868\u5355id", required=true, paramType="path", dataType="string")})
    public Resource doGetFormClearField(@PathVariable String formId) throws Exception {
        try {
            JSONArray fieldArray = new JSONArray();
            Form form = (Form)this.formService.findById(formId);
            if (form != null) {
                form.inited();
                Collection colls = form.getValueStoreFields();
                for (FormField field : colls) {
                    JSONObject fieldJson = new JSONObject();
                    fieldJson.put((Object)"id", (Object)field.getId());
                    fieldJson.put((Object)"name", (Object)field.getName());
                    fieldJson.put((Object)"type", (Object)field.getFieldtype());
                    fieldArray.add((Object)fieldJson);
                }
            }
            return this.success("ok", fieldArray);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/modules/forms/{formId}/activitys"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u64cd\u4f5c\u5217\u8868", notes="\u83b7\u53d6\u8868\u5355\u64cd\u4f5c\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="formId", value="\u8868\u5355id", required=true, paramType="path", dataType="string")})
    public Resource doGetFormActivityList(@PathVariable String formId) throws Exception {
        try {
            Form form = (Form)this.formService.findById(formId);
            form.setActivities(null);
            List list = form.getActivities();
            return this.success("ok", list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/modules/forms/activitys/{activityId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u64cd\u4f5c\u8be6\u60c5", notes="\u83b7\u53d6\u8868\u5355\u64cd\u4f5c\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="activityId", value="\u8868\u5355\u64cd\u4f5cid", required=true, paramType="path", dataType="string")})
    public Resource doGetFormActivity(@PathVariable String activityId) throws Exception {
        try {
            Activity activity = (Activity)this.activityService.findById(activityId);
            return this.success("ok", activity);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/modules/forms/{formId}/activitys"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u65b0\u5efa\u8868\u5355\u64cd\u4f5c", notes="\u65b0\u5efa\u8868\u5355\u64cd\u4f5c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="formId", value="\u8868\u5355id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateFormActivity(@PathVariable String applicationId, @PathVariable String formId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            Activity activity = (Activity)this.json2obj(json, Activity.class);
            List<Object> activities = new ArrayList();
            ActivityUtil activityUtil = new ActivityUtil();
            Form form = (Form)this.formService.findById(formId);
            if (!StringUtil.isBlank((String)form.getActivityXML())) {
                activities = activityUtil.parseXML(form.getActivityXML());
            }
            for (Activity act : activities) {
                if (act == null || !StringUtil.isBlank((String)activity.getId()) && act.getId().equals(activity.getId()) || !activity.getName().equals(act.getName())) continue;
                throw new Exception("\u8be5\u6309\u94ae\u540d\u79f0\u5df2\u5b58\u5728");
            }
            if (activity != null) {
                activity.setApplicationid(applicationId);
                activity.setParentForm(formId);
                activity.setParentId(formId);
                String activityId = Sequence.getDesignTimeSequence();
                if (StringUtil.isBlank((String)activity.getId())) {
                    activity.setId(activityId);
                }
                this.activityService.saveOrUpdate((Object)activity);
                JSONObject columnJson = new JSONObject();
                columnJson.put((Object)"id", (Object)activityId);
                return this.success("ok", columnJson);
            }
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/{applicationId}/modules/forms/{formId}/activitys/{activityId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u8868\u5355\u64cd\u4f5c", notes="\u66f4\u65b0\u8868\u5355\u64cd\u4f5c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="formId", value="\u8868\u5355id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="activityId", value="\u8868\u5355\u64cd\u4f5cid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdateFormActivity(@PathVariable String applicationId, @PathVariable String formId, @PathVariable String activityId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            Activity activity = (Activity)this.json2obj(json, Activity.class);
            if (activity != null) {
                activity.setApplicationid(applicationId);
                activity.setParentId(formId);
                activity.setParentForm(formId);
                activity.setId(activityId);
                this.activityService.update((Object)activity);
            }
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/modules/forms/activitys"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u8868\u5355\u64cd\u4f5c", notes="\u5220\u9664\u8868\u5355\u64cd\u4f5c\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doDeleteFormActivity(@RequestBody String[] ids) {
        try {
            this.activityService.delete(ids);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/modules/forms/getSequence"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u91cd\u7f6e\u5b57\u6bb5\u7f16\u53f7(\u8fd4\u56de\u968f\u673a\u6570)", notes="\u91cd\u7f6e\u5b57\u6bb5\u7f16\u53f7(\u8fd4\u56de\u968f\u673a\u6570)")
    public Resource getSequence() {
        try {
            return this.success("ok", Sequence.getDesignTimeSequence());
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/modules/forms/cleardata"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6e05\u9664\u8868\u5355\u5b57\u6bb5\u6570\u636e", notes="\u6e05\u9664\u8868\u5355\u5b57\u6bb5\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string"), @ApiImplicitParam(name="formId", value="\u8868\u5355id", required=true, paramType="query", dataType="string")})
    public Resource cleardata(@RequestParam String formId, @RequestBody String[] fields) {
        try {
            Form form = (Form)this.formService.findById(formId);
            this.formService.doClearColumnData(form, fields);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/modules/forms/help"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u8868\u5355\u5e2e\u52a9\u63a5\u53e3", notes="\u8868\u5355\u5e2e\u52a9\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5e2e\u52a9id", required=true, paramType="query", dataType="string")})
    public Resource getFormHelp(@RequestParam String id) throws Exception {
        ITopic topic;
        String language = CookieUtil.getMultiLanguage((HttpServletRequest)this.request);
        JSONObject data = new JSONObject();
        TocFileParser tocp = TocFileParser.getInstance();
        Toc toc = tocp.getToc(language);
        if (this.validateString(id).booleanValue() && (topic = toc.getTopicById(id)) != null && this.validateString(topic.getId()).booleanValue()) {
            data.put((Object)"href", (Object)topic.getHref());
            data.put((Object)"label", (Object)("{*[" + topic.getLabel() + "]*}"));
        }
        return this.success("ok", data);
    }

    @GetMapping(path={"/modules/getHelpTreeIndex"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5e2e\u52a9\u63a5\u53e3\u6811\u5f62\u7ed3\u6784", notes="\u5e2e\u52a9\u63a5\u53e3\u6811\u5f62\u7ed3\u6784")
    public Resource getHelpTreeIndex() throws Exception {
        HelpHelper helpHelper = new HelpHelper();
        String html = helpHelper.doHelpTreeIndex("", this.request);
        return this.success("ok", html);
    }

    @GetMapping(path={"/modules/forms/dataBaseTableMap"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u8868\u540d\u79f0\u6620\u5c04", notes="\u83b7\u53d6\u6570\u636e\u8868\u540d\u79f0\u6620\u5c04")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="query", dataType="string")})
    public Resource getDataBaseTableMap(@RequestParam String applicationId) {
        try {
            FormHelper formHelper = new FormHelper();
            Map dataBaseTableMap = formHelper.getDataBaseTableMap(applicationId);
            return this.success("ok", dataBaseTableMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/modules/forms/dataBaseColumnMap"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5e93\u5217\u540d\u79f0\u6620\u5c04", notes="\u83b7\u53d6\u6570\u636e\u5e93\u5217\u540d\u79f0\u6620\u5c04")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="tableName", value="\u8868\u540d", required=true, paramType="query", dataType="string")})
    public Resource getDataBaseColumnMap(@RequestParam String tableName, @RequestParam String applicationId) throws Exception {
        try {
            FormHelper formHelper = new FormHelper();
            Map dataBaseColumnMap = formHelper.getDataBaseColumnMap(tableName, applicationId);
            return this.success("ok", dataBaseColumnMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/modules/forms/synchronouslyData"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6620\u5c04\u8868\u5355\u540c\u6b65\u6570\u636e", notes="\u6620\u5c04\u8868\u5355\u540c\u6b65\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="formId", value="\u8868\u5355id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="domainId", value="\u4f01\u4e1a\u57dfid", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="tableName", value="\u8868\u540d", required=true, paramType="query", dataType="string")})
    public Resource synchronouslyData(@RequestParam String formId, @RequestParam String domainId, @RequestParam String tableName) throws Exception {
        try {
            Form form = this.formService.doView(formId);
            if (form == null) {
                return this.error(500, "\u8be5\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fdd\u5b58\u540e\u64cd\u4f5c\uff01", null);
            }
            if (StringUtil.isBlank((String)form.getTableMapping().getPrimaryKeyName())) {
                return this.error(500, "{*[noPrimaryKeyName]*}", null);
            }
            ParamsTable params = this.getParams();
            params.setParameter("domainName", (Object)domainId);
            params.setParameter("application", (Object)form.getApplicationid());
            String reuslt = this.formService.doSynchronouslyData(params, (IUser)this.getUser(), form);
            String msg = "";
            if (reuslt == "success") {
                msg = "{*[synchronouslyDataSuccess]*}";
            } else if (reuslt == "exist") {
                msg = "{*[hasSynchronouslyData]*}";
            } else if (reuslt == "noexist") {
                msg = "{*[Database]*}{*[Table]*}" + tableName + "{*[Data]*} IS NULL";
            }
            return this.success("ok", msg);
        }
        catch (Exception e) {
            return this.error(500, e.getMessage(), null);
        }
    }

    public Boolean validateString(String str) {
        Boolean rtn = false;
        if (str != null && !str.equals("") && !str.equals("undefined")) {
            rtn = true;
        }
        return rtn;
    }

    private void doSaveValidate(Form form) throws Exception {
        String name = "";
        ParamsTable params = this.getParams();
        if (form != null) {
            name = form.getName();
            params.setParameter("s_name", (Object)name);
            Form form_Exsited = this.formService.doViewByFormName(name, form.getApplicationid());
            if (form_Exsited != null && StringUtil.isBlank((String)form.getId())) {
                throw new OBPMValidateException("[" + name + "]{*[core.form.exist]*}");
            }
            if (form_Exsited != null && !form_Exsited.getId().trim().equalsIgnoreCase(form.getId())) {
                throw new OBPMValidateException("[" + name + "]{*[core.form.exist]*}");
            }
        }
        Collection formFields = form.getValueStoreFields();
        if (form.getType() == 256) {
            Collection fields = form.getFields();
            for (FormField formField : fields) {
                if (!(formField instanceof SelectAboutField)) continue;
                throw new OBPMValidateException("\u67e5\u8be2\u8868\u5355\u4e0d\u80fd\u5305\u542b\u5de6\u53f3\u9009\u62e9\u6846");
            }
        }
        String tableName = form.getTableMapping().getTableName();
        int type = form.getType();
        if (StringUtil.isBlank((String)tableName) && type == 65536) {
            throw new OBPMValidateException(" {*[core.form.type.tableName.select]*} ");
        }
        if (!StringUtil.isBlank((String)tableName) && type == 65536) {
            TableMapping tableMapping = form.getTableMapping();
            if (null != tableMapping.getPrimaryKeyMapping()) {
                Collection columnMappings = tableMapping.getColumnMappings();
                if (null != columnMappings && columnMappings.size() > 0) {
                    for (ColumnMapping cm : columnMappings) {
                        if (!cm.getColumnName().equals("") ^ !cm.getFieldName().equals("")) {
                            throw new OBPMValidateException("{*[core.mapping.field.select]*}");
                        }
                        if (cm.getFieldName().equals("MAPPINGID")) continue;
                        for (String systemField : DQLASTUtil.SYSTEM_FIELDS) {
                            if (!systemField.equalsIgnoreCase(cm.getColumnName())) continue;
                            throw new OBPMValidateException("{*[core.mapping.field.was.duplicate.with.sys]*}: " + cm.getColumnName());
                        }
                    }
                }
            } else {
                throw new OBPMValidateException("{*[core.mapping.primarykey.select]*}");
            }
        }
        this.formService.doChangeValidate(form);
    }
}

