/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.fckeditor.connector;

import cn.myapps.designtime.fckeditor.connector.Connector;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import net.fckeditor.connector.exception.FolderAlreadyExistsException;
import net.fckeditor.connector.exception.InvalidCurrentFolderException;
import net.fckeditor.connector.exception.InvalidNewFolderNameException;
import net.fckeditor.connector.exception.ReadException;
import net.fckeditor.connector.exception.WriteException;
import net.fckeditor.handlers.Command;
import net.fckeditor.handlers.PropertiesLoader;
import net.fckeditor.handlers.RequestCycleHandler;
import net.fckeditor.handlers.ResourceType;
import net.fckeditor.requestcycle.Context;
import net.fckeditor.requestcycle.ThreadLocalData;
import net.fckeditor.response.GetResponse;
import net.fckeditor.response.UploadResponse;
import net.fckeditor.tool.Utils;
import net.fckeditor.tool.UtilsFile;
import net.fckeditor.tool.UtilsResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dispatcher {
    private static final Logger logger = LoggerFactory.getLogger(net.fckeditor.connector.Dispatcher.class);
    private Connector connector;

    Dispatcher(ServletContext servletContext) throws Exception {
        String className = "cn.myapps.designtime.fckeditor.connector.ContextConnector";
        if (Utils.isEmpty((String)className)) {
            logger.error("Empty Connector implementation class name provided");
        } else {
            try {
                Class<?> clazz = Class.forName(className);
                this.connector = (Connector)clazz.newInstance();
            }
            catch (Throwable var4) {
                logger.error("Connector implementation {} could not be instantiated", (Object)className);
                throw new RuntimeException("Connector implementation " + className + " could not be instantiated", var4);
            }
        }
        this.connector.init(servletContext);
    }

    GetResponse doGet(HttpServletRequest request) {
        Context context = ThreadLocalData.getContext();
        context.logBaseParameters();
        GetResponse getResponse = null;
        if (!Command.isValidForGet((String)context.getCommandStr())) {
            getResponse = GetResponse.getInvalidCommandError();
        } else if (!ResourceType.isValidType((String)context.getTypeStr())) {
            getResponse = GetResponse.getInvalidResourceTypeError();
        } else if (!UtilsFile.isValidPath((String)context.getCurrentFolderStr())) {
            getResponse = GetResponse.getInvalidCurrentFolderError();
        } else {
            ResourceType type = context.getResourceType();
            Command command = context.getCommand();
            if ((command.equals((Object)Command.GET_FOLDERS) || command.equals((Object)Command.GET_FOLDERS_AND_FILES)) && !RequestCycleHandler.isGetResourcesEnabled((HttpServletRequest)request)) {
                getResponse = GetResponse.getGetResourcesDisabledError();
            } else if (command.equals((Object)Command.CREATE_FOLDER) && !RequestCycleHandler.isCreateFolderEnabled((HttpServletRequest)request)) {
                getResponse = GetResponse.getCreateFolderDisabledError();
            } else {
                try {
                    if (command.equals((Object)Command.CREATE_FOLDER)) {
                        String url = request.getParameter("NewFolderName");
                        String sanitizedNewFolderNameStr = UtilsFile.sanitizeFolderName((String)url);
                        if (Utils.isEmpty((String)sanitizedNewFolderNameStr)) {
                            getResponse = GetResponse.getInvalidNewFolderNameError();
                        } else {
                            this.connector.createFolder(type, context.getCurrentFolderStr(), sanitizedNewFolderNameStr);
                            getResponse = GetResponse.getOK();
                        }
                    } else if (command.equals((Object)Command.GET_FOLDERS) || command.equals((Object)Command.GET_FOLDERS_AND_FILES)) {
                        String url = UtilsResponse.getUrl((String)(request.getContextPath() + "/uploads/lib"), (ResourceType)type, (String)context.getCurrentFolderStr());
                        getResponse = this.getFoldersAndOrFiles(command, type, context.getCurrentFolderStr(), url);
                    }
                }
                catch (InvalidCurrentFolderException var8) {
                    getResponse = GetResponse.getInvalidCurrentFolderError();
                }
                catch (InvalidNewFolderNameException var9) {
                    getResponse = GetResponse.getInvalidNewFolderNameError();
                }
                catch (FolderAlreadyExistsException var10) {
                    getResponse = GetResponse.getFolderAlreadyExistsError();
                }
                catch (WriteException var11) {
                    getResponse = GetResponse.getCreateFolderWriteError();
                }
                catch (ReadException var12) {
                    getResponse = GetResponse.getGetResourcesReadError();
                }
            }
        }
        return getResponse;
    }

    private GetResponse getFoldersAndOrFiles(Command command, ResourceType type, String currentFolder, String constructedUrl) throws InvalidCurrentFolderException, ReadException {
        GetResponse getResponse = new GetResponse(command, type, currentFolder, constructedUrl);
        getResponse.setFolders(this.connector.getFolders(type, currentFolder));
        if (command.equals((Object)Command.GET_FOLDERS_AND_FILES)) {
            getResponse.setFiles(this.connector.getFiles(type, currentFolder));
        }
        return getResponse;
    }

    UploadResponse doPost(HttpServletRequest request) {
        Context context = ThreadLocalData.getContext();
        context.logBaseParameters();
        UploadResponse uploadResponse = null;
        if (!RequestCycleHandler.isFileUploadEnabled((HttpServletRequest)request)) {
            uploadResponse = UploadResponse.getFileUploadDisabledError();
        } else if (!Command.isValidForPost((String)context.getCommandStr())) {
            uploadResponse = UploadResponse.getInvalidCommandError();
        } else if (!ResourceType.isValidType((String)context.getTypeStr())) {
            uploadResponse = UploadResponse.getInvalidResourceTypeError();
        } else if (!UtilsFile.isValidPath((String)context.getCurrentFolderStr())) {
            uploadResponse = UploadResponse.getInvalidCurrentFolderError();
        } else {
            ResourceType type = context.getDefaultResourceType();
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            try {
                List items = upload.parseRequest(request);
                FileItem uplFile = (FileItem)items.get(0);
                String fileName = FilenameUtils.getName((String)uplFile.getName());
                logger.debug("Parameter NewFile: {}", (Object)fileName);
                if (type.isDeniedExtension(FilenameUtils.getExtension((String)fileName))) {
                    uploadResponse = UploadResponse.getInvalidFileTypeError();
                } else if (type.equals((Object)ResourceType.IMAGE) && PropertiesLoader.isSecureImageUploads() && !UtilsFile.isImage((InputStream)uplFile.getInputStream())) {
                    uploadResponse = UploadResponse.getInvalidFileTypeError();
                } else {
                    String sanitizedFileName = UtilsFile.sanitizeFileName((String)fileName);
                    logger.debug("Parameter NewFile (sanitized): {}", (Object)sanitizedFileName);
                    String newFileName = this.connector.fileUpload(type, context.getCurrentFolderStr(), sanitizedFileName, uplFile.getInputStream());
                    String fileUrl = UtilsResponse.fileUrl((String)RequestCycleHandler.getUserFilesPath((HttpServletRequest)request), (ResourceType)type, (String)context.getCurrentFolderStr(), (String)newFileName);
                    if (sanitizedFileName.equals(newFileName)) {
                        uploadResponse = UploadResponse.getOK((String)fileUrl);
                    } else {
                        uploadResponse = UploadResponse.getFileRenamedWarning((String)fileUrl, (String)newFileName);
                        logger.debug("Parameter NewFile (renamed): {}", (Object)newFileName);
                    }
                }
                uplFile.delete();
            }
            catch (InvalidCurrentFolderException var13) {
                uploadResponse = UploadResponse.getInvalidCurrentFolderError();
            }
            catch (WriteException var14) {
                uploadResponse = UploadResponse.getFileUploadWriteError();
            }
            catch (IOException var15) {
                uploadResponse = UploadResponse.getFileUploadWriteError();
            }
            catch (FileUploadException var16) {
                uploadResponse = UploadResponse.getFileUploadWriteError();
            }
        }
        return uploadResponse;
    }
}

