/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.datasource.controller;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.datasource.DataSource;
import cn.myapps.common.model.table.Column;
import cn.myapps.common.model.table.Table;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceFactory;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.datasource.model.TableMetadata;
import cn.myapps.designtime.datasource.service.DataSourceDesignTimeService;
import cn.myapps.designtime.dynaform.dts.metadata.ejb.MetadataProcessBean;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.form.service.FormDesignTimeServiceImpl;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.FormField;
import cn.myapps.runtime.dynaform.form.ejb.FormTableProcessBean;
import cn.myapps.runtime.dynaform.form.ejb.mapping.TableMapping;
import cn.myapps.runtime.dynaform.view.tree.Node;
import cn.myapps.util.DbTypeUtil;
import cn.myapps.util.StringUtil;
import cn.myapps.util.sequence.Sequence;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u6570\u636e\u6e90\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime/applications"}, produces={"application/json;charset=UTF-8"})
public class DataSourceController
extends AbstractDesignTimeController {
    private DataSourceDesignTimeService dataSourceDesignTimeService = DesignTimeServiceManager.dataSourceDesignTimeService();

    @GetMapping(path={"/{applicationId}/datasources"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u6e90\u5217\u8868", notes="\u83b7\u53d6\u6570\u636e\u6e90\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="linesPerPage", value="\u9875\u6761\u6570", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="name", value="\u6570\u636e\u6e90\u540d\u79f0", required=true, paramType="path", dataType="string")})
    public Resource getDataSourcesList(@PathVariable String applicationId, String name, String pageNo, String linesPerPage) {
        int page = pageNo != null && pageNo.length() > 0 ? Integer.parseInt(pageNo) : 1;
        int line = linesPerPage != null && linesPerPage.length() > 0 ? Integer.parseInt(linesPerPage) : 10;
        try {
            DataPackage data = this.dataSourceDesignTimeService.query(applicationId, name, page, line);
            return this.success("ok", data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/{applicationId}/datasources/{dataSourceId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u6e90\u8be6\u60c5", notes="\u83b7\u53d6\u6570\u636e\u6e90\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceId", value="\u6570\u636e\u6e90id", required=true, paramType="path", dataType="string")})
    public Resource doGetDataSource(@PathVariable String applicationId, @PathVariable String dataSourceId) throws Exception {
        try {
            DataSource dataSource = (DataSource)this.dataSourceDesignTimeService.findById(dataSourceId);
            return this.success("ok", dataSource);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/datasources"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u65b0\u5efa\u6570\u636e\u6e90", notes="\u65b0\u5efa\u6570\u636e\u6e90")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateDataSources(@PathVariable String applicationId, @RequestBody String content) throws Exception {
        try {
            JSONObject jsonObject = JSONObject.fromObject((Object)content);
            DataSource ds = (DataSource)this.json2obj(jsonObject, DataSource.class);
            if (StringUtil.isBlank((String)ds.getId())) {
                ds.setId(Sequence.getDesignTimeSequence());
            }
            ds.setParentId(applicationId);
            this.doSaveValidate(ds);
            this.dataSourceDesignTimeService.save((Object)ds);
            return this.success("ok", ds);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/{applicationId}/datasources/{dataSourceId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u6570\u636e\u6e90", notes="\u66f4\u65b0\u6570\u636e\u6e90")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="dataSourceId", value="\u6570\u636e\u6e90id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdateDataSources(@PathVariable String applicationId, @PathVariable String dataSourceId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            DataSource ds = (DataSource)this.json2obj(json, DataSource.class);
            ds.setId(dataSourceId);
            ds.setParentId(applicationId);
            this.doSaveValidate(ds);
            this.dataSourceDesignTimeService.saveOrUpdate((Object)ds);
            return this.success("ok", ds);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/{applicationId}/datasources"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u6570\u636e\u6e90", notes="\u5220\u9664\u6570\u636e\u6e90\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doDeleteDataSources(@RequestBody String[] ids) throws Exception {
        try {
            this.dataSourceDesignTimeService.delete(ids);
            return this.success("ok", "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/testdatasources"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6d4b\u8bd5\u6570\u636e\u6e90", notes="\u6d4b\u8bd5\u6570\u636e\u6e90")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource testDataSources(@RequestBody String content) throws Exception {
        JSONObject jsonObject = JSONObject.fromObject((Object)content);
        String username = (String)jsonObject.get("username");
        String password = (String)jsonObject.get("password");
        String driverClass = (String)jsonObject.get("driverClass");
        String url = (String)jsonObject.get("url");
        String msg = "{*[cn.myapps.core.deploy.application.connect_success]*}!";
        try {
            Class.forName(driverClass).newInstance();
            Connection conn = DriverManager.getConnection(url, username, password);
            conn.close();
        }
        catch (ClassNotFoundException e) {
            msg = "\u6570\u636e\u9a71\u52a8\u586b\u5199\u9519\u8bef! \n";
            return this.error(500, msg, null);
        }
        catch (Exception e) {
            msg = "{*[cn.myapps.core.deploy.application.connect_error]*}! \n\u539f\u56e0:\u5730\u5740\u6216\u7528\u6237\u540d\u79f0,\u5bc6\u7801\u586b\u5199\u9519\u8bef!";
            return this.error(500, msg, null);
        }
        return this.success("ok", msg);
    }

    @GetMapping(path={"/{applicationId}/datasources/getMetadata"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6e90\u6570\u636e", notes="\u83b7\u53d6\u6e90\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="datasourceId", value="\u6570\u636e\u6e90id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="subNodes", value="\u5b50\u8282\u70b9", required=true, paramType="path", dataType="string")})
    public Resource doGetMetadata(@PathVariable String applicationId, String datasourceId, String subNodes) throws Exception {
        ArrayList<Node> childrenNodes;
        block7: {
            block6: {
                childrenNodes = new ArrayList<Node>();
                if (subNodes != null && !"".equals(subNodes)) break block6;
                if (cn.myapps.common.util.StringUtil.isBlank((String)applicationId)) break block7;
                List dts = this.dataSourceDesignTimeService.list(applicationId, null);
                for (DataSource ds : dts) {
                    ApplicationDesignTimeService appService = (ApplicationDesignTimeService)DesignTimeServiceFactory.resolve(ApplicationDesignTimeService.class);
                    Application app = (Application)appService.findById(applicationId);
                    if (ds == null) continue;
                    Node node = new Node();
                    node.setId(ds.getId());
                    node.setData(ds.getName());
                    node.addAttr("name", (Object)ds.getName());
                    node.addAttr("appication", (Object)ds.getApplicationid());
                    node.addAttr("datasourceId", (Object)ds.getId());
                    node.addAttr("curNode", (Object)"isDts");
                    if (app != null && app.getDatasourceId().equals(ds.getId())) {
                        node.addAttr("rel", (Object)"db_selected");
                    } else {
                        node.addAttr("rel", (Object)"db");
                    }
                    node.addAttr("subNodes", (Object)"isTables");
                    node.setState("closed");
                    childrenNodes.add(node);
                }
                break block7;
            }
            if ("isTables".equals(subNodes)) {
                FormDesignTimeService fp = (FormDesignTimeService)DesignTimeServiceFactory.resolve(FormDesignTimeService.class);
                Collection forms = fp.getFormsByApplication(applicationId);
                DataSource ds = (DataSource)this.dataSourceDesignTimeService.findById(datasourceId);
                Collection tables = DbTypeUtil.getTables(null, (String)ds.getDbTypeName(), (Connection)ds.getConnection());
                ArrayList<String> table_names = new ArrayList<String>();
                for (Table table : tables) {
                    if (table == null) continue;
                    table_names.add(table.getName());
                }
                for (Form form : forms) {
                    TableMapping tableMapping;
                    if (form == null || !table_names.contains((tableMapping = new TableMapping(form)).getTableName())) continue;
                    Node node = new Node();
                    node.setId(form.getId());
                    node.setData(tableMapping.getTableName());
                    node.addAttr("name", (Object)tableMapping.getTableName());
                    node.addAttr("formId", (Object)form.getId());
                    node.addAttr("datasourceId", (Object)datasourceId);
                    node.addAttr("curNode", (Object)"isTable");
                    node.addAttr("rel", (Object)"table");
                    node.addAttr("subNodes", (Object)"none");
                    node.addAttr("appication", (Object)form.getApplicationid());
                    node.setState("closed");
                    childrenNodes.add(node);
                }
            }
        }
        return this.success("ok", childrenNodes);
    }

    @GetMapping(path={"/{applicationId}/datasources/getIndex"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u7d22\u5f15\u4fe1\u606f", notes="\u83b7\u53d6\u7d22\u5f15\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="datasourceId", value="\u6570\u636e\u6e90id", required=true, paramType="path", dataType="string")})
    public Resource doGetIndex(@PathVariable String applicationId, String datasourceId) throws Exception {
        DataSource datasource = (DataSource)this.dataSourceDesignTimeService.findById(datasourceId);
        MetadataProcessBean process = new MetadataProcessBean();
        Collection datas = process.getAllTables(datasource);
        return this.success("ok", datas);
    }

    @GetMapping(value={"/{applicationid}/datasources/optimization"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u4f18\u5316\u7d22\u5f15", notes="\u4f18\u5316\u7d22\u5f15")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationid", value="\u5e94\u7528id", required=true, paramType="path", dataType="string")})
    public Resource doIndexOptimization(@PathVariable String applicationid) {
        try {
            ApplicationDesignTimeService appservice = (ApplicationDesignTimeService)DesignTimeServiceFactory.resolve(ApplicationDesignTimeService.class);
            Application application = (Application)appservice.findById(applicationid);
            DataSource datasource = (DataSource)this.dataSourceDesignTimeService.findById(application.getDatasourceId());
            MetadataProcessBean process = new MetadataProcessBean();
            process.doIndexOptimization(datasource);
            return this.success("ok", "\u4f18\u5316\u5b8c\u6210");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @GetMapping(path={"/{applicationId}/datasources/getTable"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f", notes="\u83b7\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="datasourceId", value="\u6570\u636e\u6e90id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="formId", value="\u8868\u5355id", required=true, paramType="path", dataType="string")})
    public Resource doGetTable(@PathVariable String applicationId, String datasourceId, String formId) throws Exception {
        TableMetadata tableMetadata = new TableMetadata();
        DataSource datasource = (DataSource)this.dataSourceDesignTimeService.findById(datasourceId);
        MetadataProcessBean process = new MetadataProcessBean();
        tableMetadata.setDatasource(datasource);
        FormDesignTimeService fp = (FormDesignTimeService)DesignTimeServiceFactory.resolve(FormDesignTimeService.class);
        Form form = (Form)fp.findById(formId);
        tableMetadata.setForm(form);
        return this.success("ok", tableMetadata);
    }

    @GetMapping(path={"/{applicationId}/datasources/synFormTable"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u540c\u6b65\u8868\u5355\u5b57\u6bb5", notes="\u540c\u6b65\u8868\u5355\u5b57\u6bb5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="datasourceId", value="\u6570\u636e\u6e90id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="formId", value="\u8868\u5355id", required=true, paramType="path", dataType="string")})
    public Resource doSynFormTable(@PathVariable String applicationId, String datasourceId, String formId) throws Exception {
        FormDesignTimeServiceImpl fp = new FormDesignTimeServiceImpl();
        Form form = (Form)fp.findById(formId);
        ArrayList<Form> forms = new ArrayList<Form>();
        Collection superior_form = fp.getSuperiors(form);
        forms.add(form);
        forms.addAll(superior_form);
        DataSource ds = (DataSource)this.dataSourceDesignTimeService.findById(datasourceId);
        for (Form f : forms) {
            if (f == null || ds == null) continue;
            TableMapping tableMapping = new TableMapping(f);
            Table table = DbTypeUtil.getTable((String)tableMapping.getTableName(), (String)ds.getDbTypeName(), (Connection)ds.getConnection());
            Collection columns = table.getColumns();
            ArrayList<String> columnNames = new ArrayList<String>();
            for (Column column : columns) {
                if (column == null) continue;
                columnNames.add(column.getName());
            }
            Collection fields = f.getFields();
            ArrayList<FormField> fields_old = new ArrayList<FormField>();
            for (FormField field : fields) {
                if (field == null || !columnNames.contains(tableMapping.getColumnName(field.getName()))) continue;
                fields_old.add(field);
            }
            Form form_old = (Form)f.clone();
            form_old.removeAllField(form_old.getAllFields());
            form_old.addAllField(fields_old);
            FormTableProcessBean ftp = new FormTableProcessBean(f.getApplicationid());
            ftp.setDatasourceId(datasourceId);
            ftp.synDynaTable(f, form_old);
        }
        return this.success("ok", "\u540c\u6b65\u5b8c\u6210");
    }

    private void doSaveValidate(DataSource dataSource) throws Exception {
        DataSource dataSource_Exsited = this.dataSourceDesignTimeService.getDataSourceByName(dataSource.getName(), dataSource.getParentId());
        if (dataSource_Exsited != null && StringUtil.isBlank((String)dataSource.getId())) {
            throw new OBPMValidateException("[" + dataSource.getName() + "]{*[core.form.exist]*}");
        }
        if (dataSource_Exsited != null && !dataSource_Exsited.getId().trim().equalsIgnoreCase(dataSource.getId())) {
            throw new OBPMValidateException("[" + dataSource.getName() + "]{*[core.form.exist]*}");
        }
    }
}

